/* 
 * Copyright (C) 1998 Janne Lf <jlof@mail.student.oulu.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <math.h>
#include <gtk/gtk.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "gtkglarea.h"

gint init(GtkWidget *widget)
{
  /* OpenGL functions can be called only if begingl returns true */
  if (gtk_gl_area_begingl(GTK_GL_AREA(widget))) {
    glViewport(0,0, widget->allocation.width, widget->allocation.height);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0,100, 100,0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    /* end opengl calls by calling endgl */
    gtk_gl_area_endgl(GTK_GL_AREA(widget));
  }
  return TRUE;
}


/* When widget is exposed it's contents are redrawn. */
gint draw(GtkWidget *widget, GdkEventExpose *event)
{
  /* Draw only last expose. */
  if (event->count > 0) {
    return TRUE;
  }

  /* OpenGL functions can be called only if gtk_gl_area_begingl
     returns true, you can't call gl* functions anywhere except
     inside gtk_gl_area_begingl()/gtk_gl_area_endgl() pairs.
  */
  if (gtk_gl_area_begingl(GTK_GL_AREA(widget))) {

    /* Draw simple triangle */
    glClearColor(0,0,0,1);
    glClear(GL_COLOR_BUFFER_BIT);
    glColor3f(1,1,1);
    glBegin(GL_TRIANGLES);
    glVertex2f(10,10);
    glVertex2f(10,90);
    glVertex2f(90,90);
    glEnd();

   /* Opengl rendering is done for now. */
    gtk_gl_area_endgl(GTK_GL_AREA(widget));
  }

  /* Swap backbuffer to front */
  gtk_gl_area_swapbuffers(GTK_GL_AREA(widget));
  
  return TRUE;
}

/* When glarea widget size changes, viewport size is set to match the new size */
gint reshape(GtkWidget *widget, GdkEventConfigure *event)
{
  /* OpenGL functions can be called only if begingl returns true */
  if (gtk_gl_area_begingl(GTK_GL_AREA(widget))) {

    glViewport(0,0, widget->allocation.width, widget->allocation.height);
    /* end opengl calls by calling endgl */
    gtk_gl_area_endgl(GTK_GL_AREA(widget));
  }
  return TRUE;
}


int main(int argc, char **argv)
{
  GtkWidget *window,*glarea;

  /* Attribute list for gtkglarea widget. Specifies a
     list of Boolean attributes and enum/integer
     attribute/value pairs. The last attribute must be
     GDK_GL_NONE. See glXChooseVisual manpage for further
     explanation.
  */
  gint attrlist[] = {
    GDK_GL_RGBA,
    GDK_GL_DOUBLEBUFFER,
    GDK_GL_NONE
  };

  /* initialize gtk */
  gtk_init(&argc, &argv);

  /* Check if OpenGL (GLX extension) is supported. */
  if (gdk_gl_query() == FALSE) {
    g_print("OpenGL not supported\n");
    return 0;
  }

  /* Create new top level window. */
  window = gtk_window_new( GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "Simple");
  gtk_container_border_width(GTK_CONTAINER(window), 10);

  /* Quit form main if got delete event */
  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);


  /* You should always delete gtk_gl_area widgets before exit or else
     GLX contexts are left undeleted, this may cause problems (=core dump)
     in some systems.
     Destroy method of objects is not automatically called on exit.
     You need to manually enable this feature. Do gtk_quit_add_destroy()
     for all your top level windows unless you are certain that they get
     destroy signal by other means.
  */
  gtk_quit_add_destroy(1, GTK_OBJECT(window));


  /* Create new OpenGL widget. */
  glarea = GTK_WIDGET(gtk_gl_area_new(attrlist));
  /* Events for widget must be set before X Window is created */
  gtk_widget_set_events(GTK_WIDGET(glarea),
			GDK_EXPOSURE_MASK|
			GDK_BUTTON_PRESS_MASK);

  /* Connect signal handlers */
  /* Redraw image when exposed. */
  gtk_signal_connect(GTK_OBJECT(glarea), "expose_event",
		     GTK_SIGNAL_FUNC(draw), NULL);
  /* When window is resized viewport needs to be resized also. */
  gtk_signal_connect(GTK_OBJECT(glarea), "configure_event",
		     GTK_SIGNAL_FUNC(reshape), NULL);
  /* Do initialization when widget has been realized. */
  gtk_signal_connect(GTK_OBJECT(glarea), "realize",
		     GTK_SIGNAL_FUNC(init), NULL);

  /* set minimum size */
  gtk_widget_set_usize(GTK_WIDGET(glarea), 100,100);
		    
  /* put glarea into window and show it all */
  gtk_container_add(GTK_CONTAINER(window),GTK_WIDGET(glarea));
  gtk_widget_show(GTK_WIDGET(glarea));
  gtk_widget_show(GTK_WIDGET(window));

  gtk_main();

  return 0;
}
