/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtktreefactory.h"

#include <gtk/gtk.h>

GtkTreeEntry tree_items[] =
{
  { "1", NULL },
  { "1/1.1", NULL },
  { "1/1.2", NULL },
  { "1/1.3", NULL },
  { "2", NULL },
  { "2/2.1", NULL },
  { "2/2.1/2.1.1", NULL },
  { "2/2.1/2.1.2", NULL },
  { "2/2.1/2.1.3", NULL },
  { "2/2.2", NULL },
  { "2/2.3", NULL },
  { "3", NULL },
  { "3/3.1", NULL },
};
gint ntree_items = sizeof(tree_items) / sizeof(tree_items[0]);

static void
create_widgets()
{
    GtkTreeFactory *tree_factory;
    GtkWidget *tree;
    
    GtkWidget *dialog;
    GtkWidget *quit_button;

    dialog = gtk_dialog_new();

    tree_factory = gtk_tree_factory_new();
    gtk_tree_factory_add_entries(tree_factory, tree_items, ntree_items);

    tree = tree_factory->widget;
    gtk_widget_show(tree);

    gtk_box_pack_start_defaults(GTK_BOX (GTK_DIALOG (dialog)->vbox),
				tree);

    quit_button = gtk_button_new_with_label("Quit");
    gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		       (GtkSignalFunc)gtk_main_quit, NULL);
    gtk_widget_show(quit_button);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       quit_button, TRUE, TRUE, 0);

    gtk_widget_show(dialog);
}

int
main(int argc, char **argv)
{
    gtk_init(&argc, &argv);

    create_widgets();

    gtk_main();

    return 0;
}
