/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtk.h>
#include "gtkvtree.h"
#include "gtkhtreeitem.h"

static void
create_widgets()
{
    GtkWidget *vtree;
    GtkWidget *htree_item;
    
    GtkWidget *dialog;
    GtkWidget *quit_button;


    dialog = gtk_dialog_new();

    vtree = gtk_vtree_new();
    gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(dialog)->vbox), vtree);
    
    htree_item = gtk_htree_item_new_with_label("tree 0 item 0");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    htree_item = gtk_htree_item_new_with_label("tree 0 item 1");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    htree_item = gtk_htree_item_new_with_label("tree 0 item 2");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    htree_item = gtk_htree_item_new_with_label("tree 0 item 3");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    gtk_widget_show(vtree);

    vtree = gtk_vtree_new();
    gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(dialog)->vbox), vtree);
    
    htree_item = gtk_htree_item_new_with_label("tree 1 item 0");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    htree_item = gtk_htree_item_new_with_label("tree 1 item 1");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    htree_item = gtk_htree_item_new_with_label("tree 1 item 2");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    htree_item = gtk_htree_item_new_with_label("tree 1 item 3");
    gtk_tree_append(GTK_TREE (vtree), htree_item);
    gtk_widget_show(htree_item);

    gtk_widget_show(vtree);


    quit_button = gtk_button_new_with_label("Quit");
    gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		       (GtkSignalFunc)gtk_main_quit, NULL);
    gtk_widget_show(quit_button);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       quit_button, TRUE, TRUE, 0);

    gtk_widget_show(dialog);
}

int
main(int argc, char **argv)
{
    gtk_init(&argc, &argv);

    create_widgets();

    gtk_main();

    return 0;
}
