/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtkvtreefork.h"

#include "gtktree.h"
#include "gtktreeitem.h"


static void gtk_vtree_fork_class_init (GtkVTreeForkClass *klass);
static void gtk_vtree_fork_init       (GtkVTreeFork      *vtree_fork);
static gint gtk_vtree_fork_expose     (GtkWidget          *widget,
				       GdkEventExpose     *event);
static void gtk_vtree_fork__xxx_expand (GtkTreeFork *tree_fork); /* XXX rename me! */
static void gtk_vtree_fork__xxx_collapse (GtkTreeFork *tree_fork); /* XXX rename me! */


guint
gtk_vtree_fork_get_type ()
{
  static guint vtree_fork_type = 0;

  if (!vtree_fork_type)
    {
      GtkTypeInfo vtree_fork_info =
      {
	"GtkVTreeFork",
	sizeof (GtkVTreeFork),
	sizeof (GtkVTreeForkClass),
	(GtkClassInitFunc) gtk_vtree_fork_class_init,
	(GtkObjectInitFunc) gtk_vtree_fork_init,
	(GtkArgFunc) NULL,
      };

      vtree_fork_type
	  = gtk_type_unique (gtk_tree_fork_get_type (), &vtree_fork_info);
    }

  return vtree_fork_type;
}

static void
gtk_vtree_fork_class_init (GtkVTreeForkClass *klass)
{
  GtkWidgetClass *widget_class;
  GtkTreeForkClass *tree_fork_class;

  widget_class = (GtkWidgetClass*) klass;
  tree_fork_class = (GtkTreeForkClass*) klass;

  widget_class->expose_event = gtk_vtree_fork_expose;

  tree_fork_class->_xxx_expand = gtk_vtree_fork__xxx_expand;
  tree_fork_class->_xxx_collapse = gtk_vtree_fork__xxx_collapse;
}

static void
gtk_vtree_fork_init (GtkVTreeFork *vtree_fork)
{
  GTK_WIDGET (vtree_fork)->requisition.width = 10;
  GTK_WIDGET (vtree_fork)->requisition.height = 1;

  vtree_fork->vtree_fork_type = GTK_VTREE_FORK_TYPE_A;
}

GtkWidget*
gtk_vtree_fork_new (GtkVTreeForkType vtree_fork_type)
{
  GtkVTreeFork *vtree_fork;

  vtree_fork = gtk_type_new (gtk_vtree_fork_get_type ());
  vtree_fork->vtree_fork_type = vtree_fork_type;

  return GTK_WIDGET (vtree_fork);
}


static gint
gtk_vtree_fork_expose (GtkWidget      *widget,
		       GdkEventExpose *event)
{
  GtkVTreeFork *vtree_fork;
  GtkTreeItem *tree_item;
  GtkBin *bin;
    
  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_VTREE_FORK (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);

  vtree_fork = GTK_VTREE_FORK (widget);


  tree_item = GTK_TREE_ITEM (GTK_WIDGET (vtree_fork)->parent);
  bin = GTK_BIN (tree_item);

  if (tree_item &&
      GTK_WIDGET_DRAWABLE (GTK_WIDGET (tree_item)))
    {
      if (tree_item->subtree &&
	  GTK_WIDGET_VISIBLE (tree_item->subtree))
	{
	  GList *children;
	  GtkWidget *child;
	  gint x1, y1, x2, y2;
	  gint min_y, max_y;

	  x1 = GTK_WIDGET (vtree_fork)->allocation.x + 2;
	  y1 = bin->child->allocation.y + (bin->child->allocation.height / 2);

	  min_y = y1;
	  max_y = y1;

	  children
	      = gtk_container_children (GTK_CONTAINER (tree_item->subtree));

	  while (children)
	    {
	      child = children->data;
	      children = children->next;

	      x2 = GTK_WIDGET (vtree_fork)->allocation.x
		  + GTK_WIDGET (vtree_fork)->allocation.width - 2;
	      if (!GTK_WIDGET_NO_WINDOW (tree_item))
		{
		  y2 = child->allocation.y
		      + GTK_BIN (child)->child->allocation.y
		      + (GTK_BIN (child)->child->allocation.height / 2);
		}
	      else
		{
		  y2 = GTK_BIN (child)->child->allocation.y
		      + (GTK_BIN (child)->child->allocation.height / 2);
		}

	      if (vtree_fork->vtree_fork_type == GTK_VTREE_FORK_TYPE_A)
		{
		  gdk_draw_line (GTK_WIDGET (tree_item)->window,
				 GTK_WIDGET (tree_item)->style->black_gc,
				 x1, y1, x2, y2);
		}
	      else if (vtree_fork->vtree_fork_type == GTK_VTREE_FORK_TYPE_B)
		{
		  gdk_draw_line (GTK_WIDGET (tree_item)->window,
				 GTK_WIDGET (tree_item)->style->black_gc,
				 (x1+x2)/2, y2, x2, y2);
		}

	      min_y = MIN (min_y, y2);
	      max_y = MAX (max_y, y2);
	    }

	  if (vtree_fork->vtree_fork_type == GTK_VTREE_FORK_TYPE_B)
	    {
	      gdk_draw_line (GTK_WIDGET (tree_item)->window,
			     GTK_WIDGET (tree_item)->style->black_gc,
			     x1, y1, (x1+x2)/2, y1);

	      gdk_draw_line (GTK_WIDGET (tree_item)->window,
			     GTK_WIDGET (tree_item)->style->black_gc,
			     (x1+x2)/2, min_y, (x1+x2)/2, max_y);
	    }

	  g_list_free (children);
	}
    }

  return FALSE;
}

void
gtk_vtree_fork__xxx_expand (GtkTreeFork *tree_fork) /* XXX rename me! */
{
  g_return_if_fail (tree_fork != NULL);
  g_return_if_fail (GTK_IS_VTREE_FORK (tree_fork));

  if (!GTK_WIDGET_VISIBLE (GTK_WIDGET (tree_fork)))
    {
      gtk_widget_show (GTK_WIDGET (tree_fork));
    }
}

void
gtk_vtree_fork__xxx_collapse (GtkTreeFork *tree_fork) /* XXX rename me! */
{
  g_return_if_fail (tree_fork != NULL);
  g_return_if_fail (GTK_IS_VTREE_FORK (tree_fork));

  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (tree_fork)))
    {
      gtk_widget_hide (GTK_WIDGET (tree_fork));
    }
}
