;; Toolbar support for X.
;; Copyright (C) 1994 Andy Piper <andyp@parallax.demon.co.uk>
;; Copyright (C) 1995 Board of Trustees, University of Illinois

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;; DO NOT attempt to dump this file.  It will cause the dump to die a
;; horrible death.

(if (not (featurep 'xpm))
    (error "Attempted to load toolbars without XPM support!"))

(defun x-init-toolbar-from-resources (locale)
  (x-init-specifier-from-resources
   top-toolbar-height 'natnum locale
   '("topToolBarHeight" . "TopToolBarHeight"))
  (x-init-specifier-from-resources
   bottom-toolbar-height 'natnum locale
   '("bottomToolBarHeight" . "BottomToolBarHeight"))
  (x-init-specifier-from-resources
   left-toolbar-width 'natnum locale
   '("leftToolBarWidth" . "LeftToolBarWidth"))
  (x-init-specifier-from-resources
   right-toolbar-width 'natnum locale
   '("rightToolBarWidth" . "RightToolBarWidth")))

;;
;; toolbar ispell variables and defuns
;;

(defun toolbar-ispell ()
  "Intelligently spell the region or buffer."
  (interactive)
  (if (x-selection-exists-p)
      (ispell-region (region-beginning) (region-end))
    (ispell-buffer)))

;;
;; toolbar mail variables and defuns
;;

(defvar toolbar-use-separate-mail-frame nil
  "If non-nil run mail in a separate frame.")

(defvar toolbar-mail-frame nil
  "The frame in which mail is displayed.")

(defvar toolbar-mail-command 'vm
  "The mail reader to run.")

(defun toolbar-mail ()
  "Run mail in a separate frame."
  (interactive)
  (if (not toolbar-use-separate-mail-frame)
      (funcall toolbar-mail-command)
    (if (or (not toolbar-mail-frame)
	    (not (frame-live-p toolbar-mail-frame)))
	(progn
	  (setq toolbar-mail-frame (make-frame))
	  (add-hook 'vm-quit-hook
		    '(lambda ()
		       (save-excursion
			 (if (frame-live-p toolbar-mail-frame)
			     (delete-frame toolbar-mail-frame)))))
	  (select-frame toolbar-mail-frame)
	  (raise-frame toolbar-mail-frame)
	  (funcall toolbar-mail-command)))
    (if (frame-iconified-p toolbar-mail-frame)
	(deiconify-frame toolbar-mail-frame))
    (select-frame toolbar-mail-frame)
    (raise-frame toolbar-mail-frame)))

;;
;; toolbar info variables and defuns
;;

(defvar toolbar-info-frame nil
  "The frame in which info is displayed.")

(defun toolbar-info ()
  "Run info in a separate frame."
  (interactive)
  (if (or (not toolbar-info-frame)
	  (not (frame-live-p toolbar-info-frame)))
      (progn
	(setq toolbar-info-frame (make-frame))
	(select-frame toolbar-info-frame)
	(raise-frame toolbar-info-frame)
	(info)))
  (if (frame-iconified-p toolbar-info-frame)
      (deiconify-frame toolbar-info-frame))
  (select-frame toolbar-info-frame)
  (raise-frame toolbar-info-frame)
  (switch-to-buffer "*info*"))

;;
;; toolbar debug variables and defuns
;;

(defun toolbar-debug ()
  (interactive)
  (call-interactively 'gdb)
  )

;;
;; toolbar news variables and defuns
;;

(defvar toolbar-news-frame nil
  "The frame in which news is displayed.")

(defun toolbar-news ()
  "Run GNUS in a separate frame."
  (interactive)
  (if (or (not toolbar-news-frame)
	  (not (frame-live-p toolbar-news-frame)))
      (progn
	(setq toolbar-news-frame (make-frame))
	(add-hook 'gnus-exit-gnus-hook
		  '(lambda ()
		     (if (frame-live-p toolbar-news-frame)
			 (delete-frame toolbar-news-frame))))
	(select-frame toolbar-news-frame)
	(raise-frame toolbar-news-frame)
	(gnus)))
  (if (frame-iconified-p toolbar-news-frame)
      (deiconify-frame toolbar-news-frame))
  (select-frame toolbar-news-frame)
  (raise-frame toolbar-news-frame))

(defvar toolbar-file-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 4 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c white\",
\"+	c Gray60\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXooooooooooXXXXXXXXXXX\",
\"XXXXXXXoOOOOOOOOooXXXXXXXXXX\",
\"XXXXXXXoOOOOOOOOo+oXXXXXXXXX\",
\"XXXXXXXoOOOOOOOOo++oXXXXXXXX\",
\"XXXXXXXoOOOOOOOOoooooXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXooooooooooooooXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
   "A file icon pair.")

(defvar toolbar-folder-icon
  (toolbar-make-button-list
   "/* XPM */
static char * folder[] = {
\"28 28 4 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c white\",
\"+	c Gray60\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXoXXXXXXXooXXXXXooXXX\",
\"XXXXXoooOoXXXoooOoXXooo+oXXX\",
\"XXXooOOOOooooOOOoooo++++oXXX\",
\"XXXoOOOOOOOOOooo+++++++oXXXX\",
\"XXXXoOOOOOOoo++++++++++oXXXX\",
\"XXXXoOOOOOOo++++ooo+++oXXXXX\",
\"XXXXoOOOOOOo+ooo++++++oXXXXX\",
\"XXXXXoOOOOo+++++++++++oXXXXX\",
\"XXXXXoOOOOo+++oo+++++oXXXXXX\",
\"XXXXXXoOOo++oo+++++oooXXXXXX\",
\"XXXXXXoOOo++++++oooXXXXXXXXX\",
\"XXXXXXoOOo+++oooXXXXXXXXXXXX\",
\"XXXXXXXoo+oooXXXXXXXXXXXXXXX\",
\"XXXXXXXoooXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A folder icon pair")

(defvar toolbar-disk-icon
  (toolbar-make-button-list
   "/* XPM */
static char * disk[] = {
\"28 28 5 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c Gray60\",
\"+	c Gray90\",
\"@	c Gray40\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXooooooooooooooooooXXXXX\",
\"XXXXXoOOo++++++++++oOOoXXXXX\",
\"XXXXXoOOo++++++++++oOOoXXXXX\",
\"XXXXXoOOo++++++++++oOooXXXXX\",
\"XXXXXoOOo++++++++++oOOoXXXXX\",
\"XXXXXoOOo++++++++++oOOoXXXXX\",
\"XXXXXoOOo++++++++++oOOoXXXXX\",
\"XXXXXoOOo++++++++++oOOoXXXXX\",
\"XXXXXoOOo++++++++++oOOoXXXXX\",
\"XXXXXoOOooooooooooooOOoXXXXX\",
\"XXXXXoOOOOOOOOOOOOOOOOoXXXXX\",
\"XXXXXoOOOOOOOOOOOOOOOOoXXXXX\",
\"XXXXXoOOooooooooooooOOoXXXXX\",
\"XXXXXoOOo@@@@@@@o++oOOoXXXXX\",
\"XXXXXoOOo@@@@@@@o++oOOoXXXXX\",
\"XXXXXoOOo@@@@@@@o++oOOoXXXXX\",
\"XXXXXXoOo@@@@@@@o++oOOoXXXXX\",
\"XXXXXXXooooooooooooooooXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A disk icon pair.")

(defvar toolbar-printer-icon
  (toolbar-make-button-list
   "/* XPM */
static char * printer[] = {
\"28 28 6 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c white\",
\"+	c Gray60\",
\"@	c Gray90\",
\"#	c Gray40\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXoooooooooXXXXXXXXXXXXX\",
\"XXXXXXoOOOOOOOooXXXXXXXXXXXX\",
\"XXXXXXoOooooOOoXoXXXXXXXXXXX\",
\"XXXXXXoOOOOOOOoooooooXXXXXXX\",
\"XXXXXXoOoooOOOOOOoXo+ooXXXXX\",
\"XXXXXXoOOOOOOOOOOoo++++oXXXX\",
\"XXXXXXoooooooooooo++++ooXXXX\",
\"XXXXXo@@@@@@@@@@@o+++o+oXXXX\",
\"XXXXo@@@@@@@@@@@@@o+o++oXXXX\",
\"XXXooooooooooooooooo+++oXXXX\",
\"XXXo@@@@@@@@@@@@@@@o+++oXXXX\",
\"XXXo@@@@@@@@@@@@@@@o++ooXXXX\",
\"XXXo@@@@@@@@@@@@@@@o+ooXXXXX\",
\"XXXo@@@@@@@@@@@@@@@oo#oXXXXX\",
\"XXXooooooooooooooooo#oXXXXXX\",
\"XXXXo+++++++++++++o#oXXXXXXX\",
\"XXXXXo+++++++++++o#oXXXXXXXX\",
\"XXXXXo+++++++++++ooXXXXXXXXX\",
\"XXXXXXooooooooooooXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A printer icon pair.")

(defvar toolbar-cut-icon
  (toolbar-make-button-list
   "/* XPM */
static char * cut[] = {
\"28 28 4 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c Gray90\",
\"+	c white\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXoooooXXXXXXXXXXXXXXXXXX\",
\"XXXXooXXXooXXXXXXXXXXXXXXXXX\",
\"XXXooXXXXXooXXXXXXXXXXoooXXX\",
\"XXXoXXXXXXXoXXXXXXXXooOOooXX\",
\"XXXooXXXXXoooXXXXXooOOooXXXX\",
\"XXXXooXXXoooooXXXoooooXXXXXX\",
\"XXXXXoooooXXXooooooXXXXXXXXX\",
\"XXXXXXXXXXXXXXo+oXXXXXXXXXXX\",
\"XXXXXoooooXXXooooooXXXXXXXXX\",
\"XXXXooXXXoooooXXXoooooXXXXXX\",
\"XXXooXXXXXoooXXXXXooOOooXXXX\",
\"XXXoXXXXXXXoXXXXXXXXooOOooXX\",
\"XXXooXXXXXooXXXXXXXXXXoooXXX\",
\"XXXXooXXXooXXXXXXXXXXXXXXXXX\",
\"XXXXXoooooXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A cut icon pair.")

(defvar toolbar-copy-icon
  (toolbar-make-button-list
   "/* XPM */
static char * copy[] = {
\"28 28 4 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c white\",
\"+	c Gray60\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXoooooooooXXXXXXXXXXXXXX\",
\"XXXXXoOOOOOOOooXXXXXXXXXXXXX\",
\"XXXXXoOOOOOOOo+oXXXXXXXXXXXX\",
\"XXXXXoOoooooOooooXXXXXXXXXXX\",
\"XXXXXoOOOOOOOOOOoXXXXXXXXXXX\",
\"XXXXXoOooooOOOOOoXXXXXXXXXXX\",
\"XXXXXoOOOOOOOOOOoXXXXXXXXXXX\",
\"XXXXXoOOOOOoooooooooXXXXXXXX\",
\"XXXXXoOooOOoOOOOOOOooXXXXXXX\",
\"XXXXXoOOOOOoOOOOOOOo+oXXXXXX\",
\"XXXXXoOOOOOoOoooooOooooXXXXX\",
\"XXXXXoOOOOOoOOOOOOOOOOoXXXXX\",
\"XXXXXoOOOOOoOooooOOOOOoXXXXX\",
\"XXXXXoooooooOOOOOOOOOOoXXXXX\",
\"XXXXXXXXXXXoOOOOOOOOOOoXXXXX\",
\"XXXXXXXXXXXoOoooooooOOoXXXXX\",
\"XXXXXXXXXXXoOOOOOOOOOOoXXXXX\",
\"XXXXXXXXXXXoOOOOOOOOOOoXXXXX\",
\"XXXXXXXXXXXoOOOOOOOOOOoXXXXX\",
\"XXXXXXXXXXXoOOOOOOOOOOoXXXXX\",
\"XXXXXXXXXXXooooooooooooXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A copy icon pair.")

(defvar toolbar-paste-icon
  (toolbar-make-button-list
   "/* XPM */
static char * paste[] = {
\"28 28 5 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c Gray90\",
\"+	c Gray60\",
\"@	c white\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXooXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXoOOoXXXXXXXXXXXX\",
\"XXXXXXooooooOooOooooooXXXXXX\",
\"XXXXXo++++oOOOOOOo++++oXXXXX\",
\"XXXXXo+++oooooooooo+++oXXXXX\",
\"XXXXXo++++++++++++++++oXXXXX\",
\"XXXXXo++++++++++++++++oXXXXX\",
\"XXXXXo++++++++++++++++oXXXXX\",
\"XXXXXo++++++++++++++++oXXXXX\",
\"XXXXXo++++++++++++++++oXXXXX\",
\"XXXXXo++++++oooooooooooXXXXX\",
\"XXXXXo++++++o@@@@@@@@ooXXXXX\",
\"XXXXXo++++++o@@@@@@@@o+oXXXX\",
\"XXXXXo++++++o@oooooo@ooooXXX\",
\"XXXXXo++++++o@@@@@@@@@@@oXXX\",
\"XXXXXo++++++o@oooo@@@@@@oXXX\",
\"XXXXXo++++++o@@@@@@@@@@@oXXX\",
\"XXXXXo++++++o@@@@@@@@@@@oXXX\",
\"XXXXXo++++++o@oooooooo@@oXXX\",
\"XXXXXoooooooo@@@@@@@@@@@oXXX\",
\"XXXXXXXXXXXXo@@@@@@@@@@@oXXX\",
\"XXXXXXXXXXXXo@@@@@@@@@@@oXXX\",
\"XXXXXXXXXXXXoooooooooooooXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A paste icon pair.")

(defvar toolbar-undo-icon
  (toolbar-make-button-list
   "/* XPM */
static char * undo[] = {
\"28 28 5 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c Gray60\",
\"+	c Gray90\",
\"@	c white\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXooXXXXXXX\",
\"XXXXXXXXXXXXXXXXXooOOooooXXX\",
\"XXXXXXXXXXXXXXXooOOOOOOOOooX\",
\"XXXXXXXXXXXXXooOOOOOOOOOooXX\",
\"XXXXXXXXXXXoo++ooooOOOooOoXX\",
\"XXXXXXXXXoo++++++++oooOOoXXX\",
\"XXXXXXXoo+++++++++oooOOOoXXX\",
\"XXXXXoo+++++++++oo++oOOoXXXX\",
\"XXXXoo++++++++oo+++oOooXXXXX\",
\"XXXo++oooo++oo+++++ooXXXXXXX\",
\"XXXo++++++oo+++++ooXXXXXXXXX\",
\"XXo+++++++o++++ooXXXXXXXXXXX\",
\"XXo+++++++o++ooXXXXXXXXXXXXX\",
\"Xoo++++++o+ooXXXXXXXXXXXXXXX\",
\"X@@oooo++ooXXXXXXXXXXXXXXXXX\",
\"X@@@@@@ooXXXXXXXXXXXXXXXXXXX\",
\"X@@@@@@XXXXXXXXXXXXXXXXXXXXX\",
\"X@@@@XXXXXXXXXXXXXXXXXXXXXXX\",
\"X@@@XXXXXXXXXXXXXXXXXXXXXXXX\",
\"X@XXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "An undo icon pair.")

(defvar toolbar-spell-icon
  (toolbar-make-button-list
"/* XPM */
static char * dict[] = {
\"28 28 6 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c Gray90\",
\"+	c Gray40\",
\"@	c Gray60\",
\"#	c white\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXoooooooooooooooooXXXXX\",
\"XXXXXoXoOOOOOOOOOOOOO+oXXXXX\",
\"XXXXXooooooooooooooooOoXXXXX\",
\"XXXXoXo++o@@@@@@o+++oOoXXXXX\",
\"XXXXXoo++o@@@@@@@o++oOoXXXXX\",
\"XXXXXoo++o@@@@@@@@o+oOoXXXXX\",
\"XXXXoXo++o@ooooooo@ooOoXXXXX\",
\"XXXXXoo++o@o#####o@@oOoXXXXX\",
\"XXXXXoo++o@ooooooo@@oOoXXXXX\",
\"XXXXoXo++o@@@@@@@@@@oO###XXX\",
\"XXXXXoo++o@ooooooo@@###++XXX\",
\"XXXXXoo++o@@@@@@@@####+XXXXX\",
\"XXXX#Xo++o@@@@@@####++oXXXXX\",
\"XXX###o++o@@@@####++oOoXXXXX\",
\"XX####o++o@@@####+@@oOoXXXXX\",
\"XX+####++o@####++@@ooOoXXXXX\",
\"XXX+####+o####+@@@o+oOoXXXXX\",
\"XXXX+########+@@@o++oooXXXXX\",
\"XXXXo+######+@@@o+++oXXXXXXX\",
\"XXXXXo+####+oooooooooXXXXXXX\",
\"XXXXXXX+##+XXXXXXXXXXXXXXXXX\",
\"XXXXXXXX++XXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A spell icon pair.")

(defvar toolbar-replace-icon
  (toolbar-make-button-list
   "/* XPM */
static char * replace[] = {
\"28 28 2 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXooXXXXooooXXXXXXXXXXXX\",
\"XXXXXXooXXXXooXXoXXXXXXXXXXX\",
\"XXXXXoXooXXXooXXoXXXXXXXXXXX\",
\"XXXXXoXooXXXoooooXXXXXXXXXXX\",
\"XXXXoXXXooXXooXXXoXXoooXXXXX\",
\"XXXXooooooXXooXXXoXXooXXXXXX\",
\"XXXoXXXXXooXooXXXoXXoXoXXXXX\",
\"XXXoXXXXXooXoooooXXXXXXoXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXoXXXX\",
\"XXXXXXXXXXXXoXXXXXXXXXXoXXXX\",
\"XXXXXXXXXXXoXXXXXXXXXXXoXXXX\",
\"XXXXXXXXXXXoXXXXXXXXXXoXXXXX\",
\"XXXXXXXXXXoXXXXXXXXXXoXXXXXX\",
\"XXXXXXXXXoXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXoXXXXXXooooXXXXXXXX\",
\"XXXXXXXXoXXXXXXooXXXoXXXXXXX\",
\"XXXXXoXoXXXXXXXooXXXXXXXXXXX\",
\"XXXXXooXXXXXXXXooXXXXXXXXXXX\",
\"XXXXXooooXXXXXXooXXXXXXXXXXX\",
\"XXXXXooXXXXXXXXooXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXooXXXoXXXXXXX\",
\"XXXXXXXXXXXXXXXXooooXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A replace icon pair.")

(defvar toolbar-mail-icon
  (toolbar-make-button-list
   "/* XPM */
static char * mail[] = {
\"28 28 5 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c Gray90\",
\"+	c Gray60\",
\"@	c white\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXoooooooooooXXXXXXXXXX\",
\"XXXXXXXoOOOOOOOOOooXXXXXXXXX\",
\"XXXXXXXoOOOOOOOOOo+oXXXXXXXX\",
\"XXXXXXXoOOOOOOOOOooooXXXXXXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXooooooooooooooooooooooooXX\",
\"XXo@@@@@@@@@@@@@@@@@@@@@@oXX\",
\"XXo@oo@@@@@@@@@@@@@@@ooo@oXX\",
\"XXo@@@@@@@@@@@@@@@@@@o+o@oXX\",
\"XXo@@@@@@@@@@@@@@@@@@o+o@oXX\",
\"XXo@@@@@ooooooooo@@@@ooo@oXX\",
\"XXo@@@@@@@@@@@@@@@@@@@@@@oXX\",
\"XXo@@@@@ooooooo@@@@@@@@@@oXX\",
\"XXo@@@@@@@@@@@@@@@@@@@@@@oXX\",
\"XXo@@@@@ooooo@@@@@@@@@@@@oXX\",
\"XXo@@@@@@@@@@@@@@@@@@@@@@oXX\",
\"XXo@@@@@@@@@@@@@@@@@@@@@@oXX\",
\"XXo@@@@@@@@@@@@@@@@@@@@@@oXX\",
\"XXooooooooooooooooooooooooXX\",
\"XXXXXXXoOOOOOOOOOOOOoXXXXXXX\",
\"XXXXXXXooooooooooooooXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A mail icon pair.")

(defvar toolbar-info-icon
  (toolbar-make-button-list
   "/* XPM */
static char * info[] = {
\"28 28 2 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXoooooooXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXooooooXXXXXXXXXXXX\",
\"XXXXXXXXXoooooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXoooooooXXXXXXXXXXX\",
\"XXXXXXXXXoooooooooXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "An info icon pair.")

(defvar toolbar-compile-icon
  (toolbar-make-button-list
   "/* XPM */
static char * makefile[] = {
\"28 28 6 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c white\",
\"+	c Gray40\",
\"@	c Gray90\",
\"#	c white\",
\"XXXXXXXXXoooXXXXXXXXXXXXXXXX\",
\"XXXXXXXoooOoooXXXXXXXXXXXXXX\",
\"XXXXXXXo++o++oXXXXXXXXXXXXXX\",
\"XXXXXXoo+ooo+ooXXXXXXXXXXXXX\",
\"XXXXXXo++o++++oXXXXXXXXXXXXX\",
\"XXXXXXoo++o++ooXXXXXXXXXXXXX\",
\"XXXXXXXo+++++ooooXXXXXXXXXXX\",
\"XXXXXXXooo+oooo@oXXoXXXXXXXX\",
\"XXXXXXXXXooo@o@@@oo@oXXXXXXX\",
\"XXXXXXXXXo@@@@@@@@@@ooXXXXXX\",
\"XXXXXXXXXXo@@@ooo@@@oXXXXXXX\",
\"XXXXXXXXXXo@@o@o#o@@oXXXXXXX\",
\"XXXXXXXXoo@@o@o###o@@ooXXXXX\",
\"XXXXXXXXo@@@oo####o@@@oXXXXX\",
\"XXXXXXXXooo@o@o###o@oooXXXXX\",
\"XXXXXXXXXXo@@o@o#o@@oXXXXXXX\",
\"XXXXXXXXXXo@@@ooo@@@oXXXXXXX\",
\"XXXXXXXXXo@@@@@@@@@@@oXXXXXX\",
\"XXXXXXXXXoo@oo@@oooooXXXXXXX\",
\"XXXXXXXoooXooo@@oXXoXXXXXXXX\",
\"XXXXXXXo++o++ooooXXXXXXXXXXX\",
\"XXXXXXoo+ooo+ooXXXXXXXXXXXXX\",
\"XXXXXXo++o++++oXXXXXXXXXXXXX\",
\"XXXXXXoo++o++ooXXXXXXXXXXXXX\",
\"XXXXXXXo+++++oXXXXXXXXXXXXXX\",
\"XXXXXXXooo+oooXXXXXXXXXXXXXX\",
\"XXXXXXXXXoooXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A compile icon.")

(defvar toolbar-debug-icon
  (toolbar-make-button-list
"/* XPM */
static char * bug_xpm[] = {
\"28 28 6 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c Gray40\",
\"+	c Gray60\",
\"@	c white\",
\"#	c Gray90\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXooooooooooooooooXXXXXX\",
\"XXXXXoooooooooOoOoOoOooXXXXX\",
\"XXXXXoooooooooOoOoOoOooXXXXX\",
\"XXXXXoooooooooooooooooo+XXXX\",
\"XXXXXXo@@@@@@@@@@@##Xo++XXXX\",
\"XXXXXo@@@@@@@@@@@@##XXo+XXXX\",
\"XXXXXo@@@@@@@@@@@@##XXoXXXXX\",
\"XXXXXo@@@@@@@@@@@@##XXo+XXXX\",
\"XXXXXo@@@@@@@@@@@@##XXo+XXXX\",
\"XXXXXo@@@@@@o@@oo@##XXo+XXXX\",
\"XXXXXo@@@o@@o@oooo##XXo+XXXX\",
\"XXXXXo@@@@o@oo@ooo##XXo+XXXX\",
\"XXXXXo@@@@@oooooo@##XXo+XXXX\",
\"XXXXXo@ooo@ooooo@@##XXo+XXXX\",
\"XXXXXo@@@oo@oooooo##XXo+XXXX\",
\"XXXXXo@@o@ooooo@@@##XXo+XXXX\",
\"XXXXXo@oooooo@@o@@##XXo+XXXX\",
\"XXXXXo@oooooo@@@o@##XXo+XXXX\",
\"XXXXXo@ooooooo@@@@##XXo+XXXX\",
\"XXXXXo@ooooo@o@@@@##XXo+XXXX\",
\"XXXXXo@@ooo@@o@@@@##XXo+XXXX\",
\"XXXXXo@@@@@@@@@@@@##XXo+XXXX\",
\"XXXXXXoooooooooooooooo++XXXX\",
\"XXXXXX++++++++++++++++++XXXX\",
\"XXXXXXX++++++++++++++++XXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "A debugger icon.")

(defvar toolbar-news-icon
  (toolbar-make-button-list
   "/* XPM */
static char * news_xpm[] = {
\"28 28 5 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c black\",
\"O	c white\",
\"+	c gray60\",
\"@	c gray\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXooooooooooXXXXX\",
\"XXXooooooooooOOOoOOOoOOoXXXX\",
\"XXoooOOOoOoooOoOoOoOOoOo++XX\",
\"XXo@oOOooOOooOooOooOooOOo++X\",
\"oo@o@oOOOOOOOOOOOOOOOOOOOo+X\",
\"o@@o@oOooooooooooooooOooOo++\",
\"oo@o@oOOOOOOOOOOOOOOOOOOOOo+\",
\"oo@@o@oOoOoOoOoooOoOoooooOo+\",
\"o@o@o@oOOoOooOOOOOOoOooOooOo\",
\"ooo@@o@oOoooooOoOOooOoooooOo\",
\"Xo@o@o@oOOooooOOOOOOOOoOooOo\",
\"XXoo@@o@oOoooooOOooooOoooooo\",
\"XXo@o@o@oOOooOooOooOoOoooOOo\",
\"XXXoo@@o@oOoOoooOooooOooOooo\",
\"XXXoXo@o@oOoooOoOooooOoooo++\",
\"XXXXoXoo@oOoOooooooooo++++++\",
\"XXXXXooooooooo++++++++++++++\",
\"XXXXXXX++++++++++++++++++XXX\",
\"XXXXXXXX+++++++++XXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
   "A news icons.")

(defvar initial-toolbar-spec
  '([toolbar-file-icon		find-file	t	"Open a file"	]
    [toolbar-folder-icon	dired		t	"View directory"]
    [toolbar-disk-icon		save-buffer	t	"Save buffer"	]
    [toolbar-printer-icon	print-buffer	t	"Print buffer"	]
    [toolbar-cut-icon		x-kill-primary-selection t "Kill region"]
    [toolbar-copy-icon		x-copy-primary-selection t "Copy region"]
    [toolbar-paste-icon		x-yank-clipboard-selection t
				"Paste from clipboard"]
    [toolbar-undo-icon		undo		t	"Undo edit"	]
    [toolbar-spell-icon		toolbar-ispell	t	"Spellcheck"	]
    [toolbar-replace-icon	query-replace	t	"Replace text"	]
    [toolbar-mail-icon		toolbar-mail	t	"Mail"		]
    [toolbar-info-icon		toolbar-info	t	"Information"	]
    [toolbar-compile-icon	compile		t	"Compile"	]
    [toolbar-debug-icon		toolbar-debug	t	"Debug"		]
    [toolbar-news-icon		toolbar-news	t	"News"		])
  "The initial toolbar for a buffer.")

(set-specifier default-toolbar initial-toolbar-spec)


(provide 'x-toolbar)
