;;; ucs-latin-add.el --- UCS table of Latin Extended Additional

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Latin Extended Additional

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; LATIN CAPITAL LETTER A WITH DOT BELOW
(ucs-set-char #x1EA0 ?-2) ; VISCII-1.1-80-A

;; LATIN SMALL LETTER A WITH DOT BELOW
(ucs-set-char #x1EA1 ?-1) ; VISCII-1.1-D5-A

;; LATIN CAPITAL LETTER A WITH HOOK ABOVE
(ucs-set-char #x1EA2 ?-2) ; VISCII-1.1-C4-A

;; LATIN SMALL LETTER A WITH HOOK ABOVE
(ucs-set-char #x1EA3 ?-1) ; VISCII-1.1-E4-A

;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
(ucs-set-char #x1EA4 ?-2) ; VISCII-1.1-84-A

;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
(ucs-set-char #x1EA5 ?-1) ; VISCII-1.1-A4-A

;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
(ucs-set-char #x1EA6 ?-2) ; VISCII-1.1-85-A

;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
(ucs-set-char #x1EA7 ?-1) ; VISCII-1.1-A5-A

;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
(ucs-set-char #x1EA8 ?-2) ; VISCII-1.1-86-A

;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
(ucs-set-char #x1EA9 ?-1) ; VISCII-1.1-A6-A

;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
(ucs-set-char #x1EAA ?-2) ; VISCII-1.1-06-A

;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
(ucs-set-char #x1EAB ?-1) ; VISCII-1.1-E7-A

;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
(ucs-set-char #x1EAC ?-2) ; VISCII-1.1-87-A

;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
(ucs-set-char #x1EAD ?-1) ; VISCII-1.1-A7-A

;; LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
(ucs-set-char #x1EAE ?-2) ; VISCII-1.1-81-A

;; LATIN SMALL LETTER A WITH BREVE AND ACUTE
(ucs-set-char #x1EAF ?-1) ; VISCII-1.1-A1-A

;; LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
(ucs-set-char #x1EB0 ?-2) ; VISCII-1.1-82-A

;; LATIN SMALL LETTER A WITH BREVE AND GRAVE
(ucs-set-char #x1EB1 ?-1) ; VISCII-1.1-A2-A

;; LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
(ucs-set-char #x1EB2 ?-2) ; VISCII-1.1-02-A

;; LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
(ucs-set-char #x1EB3 ?-1) ; VISCII-1.1-C6-A

;; LATIN CAPITAL LETTER A WITH BREVE AND TILDE
(ucs-set-char #x1EB4 ?-2) ; VISCII-1.1-05-A

;; LATIN SMALL LETTER A WITH BREVE AND TILDE
(ucs-set-char #x1EB5 ?-1) ; VISCII-1.1-C7-A

;; LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
(ucs-set-char #x1EB6 ?-2) ; VISCII-1.1-83-A

;; LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
(ucs-set-char #x1EB7 ?-1) ; VISCII-1.1-A3-A

;; LATIN CAPITAL LETTER E WITH DOT BELOW
(ucs-set-char #x1EB8 ?-2) ; VISCII-1.1-89-A

;; LATIN SMALL LETTER E WITH DOT BELOW
(ucs-set-char #x1EB9 ?-1) ; VISCII-1.1-A9-A

;; LATIN CAPITAL LETTER E WITH HOOK ABOVE
(ucs-set-char #x1EBA ?-2) ; VISCII-1.1-CB-A

;; LATIN SMALL LETTER E WITH HOOK ABOVE
(ucs-set-char #x1EBB ?-1) ; VISCII-1.1-EB-A

;; LATIN CAPITAL LETTER E WITH TILDE
(ucs-set-char #x1EBC ?-2) ; VISCII-1.1-88-A

;; LATIN SMALL LETTER E WITH TILDE
(ucs-set-char #x1EBD ?-1) ; VISCII-1.1-A8-A

;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
(ucs-set-char #x1EBE ?-2) ; VISCII-1.1-8A-A

;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
(ucs-set-char #x1EBF ?-1) ; VISCII-1.1-AA-A

;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
(ucs-set-char #x1EC0 ?-2) ; VISCII-1.1-8B-A

;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
(ucs-set-char #x1EC1 ?-1) ; VISCII-1.1-AB-A

;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
(ucs-set-char #x1EC2 ?-2) ; VISCII-1.1-8C-A

;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
(ucs-set-char #x1EC3 ?-1) ; VISCII-1.1-AC-A

;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
(ucs-set-char #x1EC4 ?-2) ; VISCII-1.1-8D-A

;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
(ucs-set-char #x1EC5 ?-1) ; VISCII-1.1-AD-A

;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
(ucs-set-char #x1EC6 ?-2) ; VISCII-1.1-8E-A

;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
(ucs-set-char #x1EC7 ?-1) ; VISCII-1.1-AE-A

;; LATIN CAPITAL LETTER I WITH HOOK ABOVE
(ucs-set-char #x1EC8 ?-2) ; VISCII-1.1-9B-A

;; LATIN SMALL LETTER I WITH HOOK ABOVE
(ucs-set-char #x1EC9 ?-1) ; VISCII-1.1-EF-A

;; LATIN CAPITAL LETTER I WITH DOT BELOW
(ucs-set-char #x1ECA ?-2) ; VISCII-1.1-98-A

;; LATIN SMALL LETTER I WITH DOT BELOW
(ucs-set-char #x1ECB ?-1) ; VISCII-1.1-B8-A

;; LATIN CAPITAL LETTER O WITH DOT BELOW
(ucs-set-char #x1ECC ?-2) ; VISCII-1.1-9A-A

;; LATIN SMALL LETTER O WITH DOT BELOW
(ucs-set-char #x1ECD ?-1) ; VISCII-1.1-F7-A

;; LATIN CAPITAL LETTER O WITH HOOK ABOVE
(ucs-set-char #x1ECE ?-2) ; VISCII-1.1-99-A

;; LATIN SMALL LETTER O WITH HOOK ABOVE
(ucs-set-char #x1ECF ?-1) ; VISCII-1.1-F6-A

;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
(ucs-set-char #x1ED0 ?-2) ; VISCII-1.1-8F-A

;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
(ucs-set-char #x1ED1 ?-1) ; VISCII-1.1-AF-A

;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
(ucs-set-char #x1ED2 ?-2) ; VISCII-1.1-90-A

;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
(ucs-set-char #x1ED3 ?-1) ; VISCII-1.1-B0-A

;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
(ucs-set-char #x1ED4 ?-2) ; VISCII-1.1-91-A

;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
(ucs-set-char #x1ED5 ?-1) ; VISCII-1.1-B1-A

;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
(ucs-set-char #x1ED6 ?-2) ; VISCII-1.1-92-A

;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
(ucs-set-char #x1ED7 ?-1) ; VISCII-1.1-B2-A

;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
(ucs-set-char #x1ED8 ?-2) ; VISCII-1.1-93-A

;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
(ucs-set-char #x1ED9 ?-1) ; VISCII-1.1-B5-A

;; LATIN CAPITAL LETTER O WITH HORN AND ACUTE
(ucs-set-char #x1EDA ?-2) ; VISCII-1.1-95-A

;; LATIN SMALL LETTER O WITH HORN AND ACUTE
(ucs-set-char #x1EDB ?-1) ; VISCII-1.1-BE-A

;; LATIN CAPITAL LETTER O WITH HORN AND GRAVE
(ucs-set-char #x1EDC ?-2) ; VISCII-1.1-96-A

;; LATIN SMALL LETTER O WITH HORN AND GRAVE
(ucs-set-char #x1EDD ?-1) ; VISCII-1.1-B6-A

;; LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
(ucs-set-char #x1EDE ?-2) ; VISCII-1.1-97-A

;; LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
(ucs-set-char #x1EDF ?-1) ; VISCII-1.1-B7-A

;; LATIN CAPITAL LETTER O WITH HORN AND TILDE
(ucs-set-char #x1EE0 ?-2) ; VISCII-1.1-B3-A

;; LATIN SMALL LETTER O WITH HORN AND TILDE
(ucs-set-char #x1EE1 ?-1) ; VISCII-1.1-DE-A

;; LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
(ucs-set-char #x1EE2 ?-2) ; VISCII-1.1-94-A

;; LATIN SMALL LETTER O WITH HORN AND DOT BELOW
(ucs-set-char #x1EE3 ?-1) ; VISCII-1.1-FE-A

;; LATIN CAPITAL LETTER U WITH DOT BELOW
(ucs-set-char #x1EE4 ?-2) ; VISCII-1.1-9E-A

;; LATIN SMALL LETTER U WITH DOT BELOW
(ucs-set-char #x1EE5 ?-1) ; VISCII-1.1-F8-A

;; LATIN CAPITAL LETTER U WITH HOOK ABOVE
(ucs-set-char #x1EE6 ?-2) ; VISCII-1.1-9C-A

;; LATIN SMALL LETTER U WITH HOOK ABOVE
(ucs-set-char #x1EE7 ?-1) ; VISCII-1.1-FC-A

;; LATIN CAPITAL LETTER U WITH HORN AND ACUTE
(ucs-set-char #x1EE8 ?-2) ; VISCII-1.1-BA-A

;; LATIN SMALL LETTER U WITH HORN AND ACUTE
(ucs-set-char #x1EE9 ?-1) ; VISCII-1.1-D1-A

;; LATIN CAPITAL LETTER U WITH HORN AND GRAVE
(ucs-set-char #x1EEA ?-2) ; VISCII-1.1-BB-A

;; LATIN SMALL LETTER U WITH HORN AND GRAVE
(ucs-set-char #x1EEB ?-1) ; VISCII-1.1-D7-A

;; LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
(ucs-set-char #x1EEC ?-2) ; VISCII-1.1-BC-A

;; LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
(ucs-set-char #x1EED ?-1) ; VISCII-1.1-D8-A

;; LATIN CAPITAL LETTER U WITH HORN AND TILDE
(ucs-set-char #x1EEE ?-2) ; VISCII-1.1-FF-A

;; LATIN SMALL LETTER U WITH HORN AND TILDE
(ucs-set-char #x1EEF ?-1) ; VISCII-1.1-E6-A

;; LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
(ucs-set-char #x1EF0 ?-2) ; VISCII-1.1-B9-A

;; LATIN SMALL LETTER U WITH HORN AND DOT BELOW
(ucs-set-char #x1EF1 ?-1) ; VISCII-1.1-F1-A

;; LATIN CAPITAL LETTER Y WITH GRAVE
(ucs-set-char #x1EF2 ?-2) ; VISCII-1.1-9F-A

;; LATIN SMALL LETTER Y WITH GRAVE
(ucs-set-char #x1EF3 ?-1) ; VISCII-1.1-CF-A

;; LATIN CAPITAL LETTER Y WITH DOT BELOW
(ucs-set-char #x1EF4 ?-2) ; VISCII-1.1-1E-A

;; LATIN SMALL LETTER Y WITH DOT BELOW
(ucs-set-char #x1EF5 ?-1) ; VISCII-1.1-DC-A

;; LATIN CAPITAL LETTER Y WITH HOOK ABOVE
(ucs-set-char #x1EF6 ?-2) ; VISCII-1.1-14-A

;; LATIN SMALL LETTER Y WITH HOOK ABOVE
(ucs-set-char #x1EF7 ?-1) ; VISCII-1.1-D6-A

;; LATIN CAPITAL LETTER Y WITH TILDE
(ucs-set-char #x1EF8 ?-2) ; VISCII-1.1-19-A

;; LATIN SMALL LETTER Y WITH TILDE
(ucs-set-char #x1EF9 ?-1) ; VISCII-1.1-DB-A

;;; ucs-latin-add.el ends here
