;;; ucs-katakana.el --- UCS table of Katakana

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Katakana

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(ucs-set-char #x30A1 ?$(C+!(B) ; KS0-C-2B21
(ucs-set-char #x30A1 ?$@%!(B) ; J78-@-2521
(ucs-set-char #x30A1 ?$A%!(B) ; GB0-A-2521
(ucs-set-char #x30A1 ?$B%!(B) ; J83-B-2521

(ucs-set-char #x30A2 ?$(C+"(B) ; KS0-C-2B22
(ucs-set-char #x30A2 ?$@%"(B) ; J78-@-2522
(ucs-set-char #x30A2 ?$A%"(B) ; GB0-A-2522
(ucs-set-char #x30A2 ?$B%"(B) ; J83-B-2522

(ucs-set-char #x30A3 ?$(C+#(B) ; KS0-C-2B23
(ucs-set-char #x30A3 ?$@%#(B) ; J78-@-2523
(ucs-set-char #x30A3 ?$A%#(B) ; GB0-A-2523
(ucs-set-char #x30A3 ?$B%#(B) ; J83-B-2523

(ucs-set-char #x30A4 ?$(C+$(B) ; KS0-C-2B24
(ucs-set-char #x30A4 ?$@%$(B) ; J78-@-2524
(ucs-set-char #x30A4 ?$A%$(B) ; GB0-A-2524
(ucs-set-char #x30A4 ?$B%$(B) ; J83-B-2524

(ucs-set-char #x30A5 ?$(C+%(B) ; KS0-C-2B25
(ucs-set-char #x30A5 ?$@%%(B) ; J78-@-2525
(ucs-set-char #x30A5 ?$A%%(B) ; GB0-A-2525
(ucs-set-char #x30A5 ?$B%%(B) ; J83-B-2525

(ucs-set-char #x30A6 ?$(C+&(B) ; KS0-C-2B26
(ucs-set-char #x30A6 ?$@%&(B) ; J78-@-2526
(ucs-set-char #x30A6 ?$A%&(B) ; GB0-A-2526
(ucs-set-char #x30A6 ?$B%&(B) ; J83-B-2526

(ucs-set-char #x30A7 ?$(C+'(B) ; KS0-C-2B27
(ucs-set-char #x30A7 ?$@%'(B) ; J78-@-2527
(ucs-set-char #x30A7 ?$A%'(B) ; GB0-A-2527
(ucs-set-char #x30A7 ?$B%'(B) ; J83-B-2527

(ucs-set-char #x30A8 ?$(C+((B) ; KS0-C-2B28
(ucs-set-char #x30A8 ?$@%((B) ; J78-@-2528
(ucs-set-char #x30A8 ?$A%((B) ; GB0-A-2528
(ucs-set-char #x30A8 ?$B%((B) ; J83-B-2528

(ucs-set-char #x30A9 ?$(C+)(B) ; KS0-C-2B29
(ucs-set-char #x30A9 ?$@%)(B) ; J78-@-2529
(ucs-set-char #x30A9 ?$A%)(B) ; GB0-A-2529
(ucs-set-char #x30A9 ?$B%)(B) ; J83-B-2529

(ucs-set-char #x30AA ?$(C+*(B) ; KS0-C-2B2A
(ucs-set-char #x30AA ?$@%*(B) ; J78-@-252A
(ucs-set-char #x30AA ?$A%*(B) ; GB0-A-252A
(ucs-set-char #x30AA ?$B%*(B) ; J83-B-252A

(ucs-set-char #x30AB ?$(C++(B) ; KS0-C-2B2B
(ucs-set-char #x30AB ?$@%+(B) ; J78-@-252B
(ucs-set-char #x30AB ?$A%+(B) ; GB0-A-252B
(ucs-set-char #x30AB ?$B%+(B) ; J83-B-252B

(ucs-set-char #x30AC ?$(C+,(B) ; KS0-C-2B2C
(ucs-set-char #x30AC ?$@%,(B) ; J78-@-252C
(ucs-set-char #x30AC ?$A%,(B) ; GB0-A-252C
(ucs-set-char #x30AC ?$B%,(B) ; J83-B-252C

(ucs-set-char #x30AD ?$(C+-(B) ; KS0-C-2B2D
(ucs-set-char #x30AD ?$@%-(B) ; J78-@-252D
(ucs-set-char #x30AD ?$A%-(B) ; GB0-A-252D
(ucs-set-char #x30AD ?$B%-(B) ; J83-B-252D

(ucs-set-char #x30AE ?$(C+.(B) ; KS0-C-2B2E
(ucs-set-char #x30AE ?$@%.(B) ; J78-@-252E
(ucs-set-char #x30AE ?$A%.(B) ; GB0-A-252E
(ucs-set-char #x30AE ?$B%.(B) ; J83-B-252E

(ucs-set-char #x30AF ?$(C+/(B) ; KS0-C-2B2F
(ucs-set-char #x30AF ?$@%/(B) ; J78-@-252F
(ucs-set-char #x30AF ?$A%/(B) ; GB0-A-252F
(ucs-set-char #x30AF ?$B%/(B) ; J83-B-252F

(ucs-set-char #x30B0 ?$(C+0(B) ; KS0-C-2B30
(ucs-set-char #x30B0 ?$@%0(B) ; J78-@-2530
(ucs-set-char #x30B0 ?$A%0(B) ; GB0-A-2530
(ucs-set-char #x30B0 ?$B%0(B) ; J83-B-2530

(ucs-set-char #x30B1 ?$(C+1(B) ; KS0-C-2B31
(ucs-set-char #x30B1 ?$@%1(B) ; J78-@-2531
(ucs-set-char #x30B1 ?$A%1(B) ; GB0-A-2531
(ucs-set-char #x30B1 ?$B%1(B) ; J83-B-2531

(ucs-set-char #x30B2 ?$(C+2(B) ; KS0-C-2B32
(ucs-set-char #x30B2 ?$@%2(B) ; J78-@-2532
(ucs-set-char #x30B2 ?$A%2(B) ; GB0-A-2532
(ucs-set-char #x30B2 ?$B%2(B) ; J83-B-2532

(ucs-set-char #x30B3 ?$(C+3(B) ; KS0-C-2B33
(ucs-set-char #x30B3 ?$@%3(B) ; J78-@-2533
(ucs-set-char #x30B3 ?$A%3(B) ; GB0-A-2533
(ucs-set-char #x30B3 ?$B%3(B) ; J83-B-2533

(ucs-set-char #x30B4 ?$(C+4(B) ; KS0-C-2B34
(ucs-set-char #x30B4 ?$@%4(B) ; J78-@-2534
(ucs-set-char #x30B4 ?$A%4(B) ; GB0-A-2534
(ucs-set-char #x30B4 ?$B%4(B) ; J83-B-2534

(ucs-set-char #x30B5 ?$(C+5(B) ; KS0-C-2B35
(ucs-set-char #x30B5 ?$@%5(B) ; J78-@-2535
(ucs-set-char #x30B5 ?$A%5(B) ; GB0-A-2535
(ucs-set-char #x30B5 ?$B%5(B) ; J83-B-2535

(ucs-set-char #x30B6 ?$(C+6(B) ; KS0-C-2B36
(ucs-set-char #x30B6 ?$@%6(B) ; J78-@-2536
(ucs-set-char #x30B6 ?$A%6(B) ; GB0-A-2536
(ucs-set-char #x30B6 ?$B%6(B) ; J83-B-2536

(ucs-set-char #x30B7 ?$(C+7(B) ; KS0-C-2B37
(ucs-set-char #x30B7 ?$@%7(B) ; J78-@-2537
(ucs-set-char #x30B7 ?$A%7(B) ; GB0-A-2537
(ucs-set-char #x30B7 ?$B%7(B) ; J83-B-2537

(ucs-set-char #x30B8 ?$(C+8(B) ; KS0-C-2B38
(ucs-set-char #x30B8 ?$@%8(B) ; J78-@-2538
(ucs-set-char #x30B8 ?$A%8(B) ; GB0-A-2538
(ucs-set-char #x30B8 ?$B%8(B) ; J83-B-2538

(ucs-set-char #x30B9 ?$(C+9(B) ; KS0-C-2B39
(ucs-set-char #x30B9 ?$@%9(B) ; J78-@-2539
(ucs-set-char #x30B9 ?$A%9(B) ; GB0-A-2539
(ucs-set-char #x30B9 ?$B%9(B) ; J83-B-2539

(ucs-set-char #x30BA ?$(C+:(B) ; KS0-C-2B3A
(ucs-set-char #x30BA ?$@%:(B) ; J78-@-253A
(ucs-set-char #x30BA ?$A%:(B) ; GB0-A-253A
(ucs-set-char #x30BA ?$B%:(B) ; J83-B-253A

(ucs-set-char #x30BB ?$(C+;(B) ; KS0-C-2B3B
(ucs-set-char #x30BB ?$@%;(B) ; J78-@-253B
(ucs-set-char #x30BB ?$A%;(B) ; GB0-A-253B
(ucs-set-char #x30BB ?$B%;(B) ; J83-B-253B

(ucs-set-char #x30BC ?$(C+<(B) ; KS0-C-2B3C
(ucs-set-char #x30BC ?$@%<(B) ; J78-@-253C
(ucs-set-char #x30BC ?$A%<(B) ; GB0-A-253C
(ucs-set-char #x30BC ?$B%<(B) ; J83-B-253C

(ucs-set-char #x30BD ?$(C+=(B) ; KS0-C-2B3D
(ucs-set-char #x30BD ?$@%=(B) ; J78-@-253D
(ucs-set-char #x30BD ?$A%=(B) ; GB0-A-253D
(ucs-set-char #x30BD ?$B%=(B) ; J83-B-253D

(ucs-set-char #x30BE ?$(C+>(B) ; KS0-C-2B3E
(ucs-set-char #x30BE ?$@%>(B) ; J78-@-253E
(ucs-set-char #x30BE ?$A%>(B) ; GB0-A-253E
(ucs-set-char #x30BE ?$B%>(B) ; J83-B-253E

(ucs-set-char #x30BF ?$(C+?(B) ; KS0-C-2B3F
(ucs-set-char #x30BF ?$@%?(B) ; J78-@-253F
(ucs-set-char #x30BF ?$A%?(B) ; GB0-A-253F
(ucs-set-char #x30BF ?$B%?(B) ; J83-B-253F

(ucs-set-char #x30C0 ?$(C+@(B) ; KS0-C-2B40
(ucs-set-char #x30C0 ?$@%@(B) ; J78-@-2540
(ucs-set-char #x30C0 ?$A%@(B) ; GB0-A-2540
(ucs-set-char #x30C0 ?$B%@(B) ; J83-B-2540

(ucs-set-char #x30C1 ?$(C+A(B) ; KS0-C-2B41
(ucs-set-char #x30C1 ?$@%A(B) ; J78-@-2541
(ucs-set-char #x30C1 ?$A%A(B) ; GB0-A-2541
(ucs-set-char #x30C1 ?$B%A(B) ; J83-B-2541

(ucs-set-char #x30C2 ?$(C+B(B) ; KS0-C-2B42
(ucs-set-char #x30C2 ?$@%B(B) ; J78-@-2542
(ucs-set-char #x30C2 ?$A%B(B) ; GB0-A-2542
(ucs-set-char #x30C2 ?$B%B(B) ; J83-B-2542

(ucs-set-char #x30C3 ?$(C+C(B) ; KS0-C-2B43
(ucs-set-char #x30C3 ?$@%C(B) ; J78-@-2543
(ucs-set-char #x30C3 ?$A%C(B) ; GB0-A-2543
(ucs-set-char #x30C3 ?$B%C(B) ; J83-B-2543

(ucs-set-char #x30C4 ?$(C+D(B) ; KS0-C-2B44
(ucs-set-char #x30C4 ?$@%D(B) ; J78-@-2544
(ucs-set-char #x30C4 ?$A%D(B) ; GB0-A-2544
(ucs-set-char #x30C4 ?$B%D(B) ; J83-B-2544

(ucs-set-char #x30C5 ?$(C+E(B) ; KS0-C-2B45
(ucs-set-char #x30C5 ?$@%E(B) ; J78-@-2545
(ucs-set-char #x30C5 ?$A%E(B) ; GB0-A-2545
(ucs-set-char #x30C5 ?$B%E(B) ; J83-B-2545

(ucs-set-char #x30C6 ?$(C+F(B) ; KS0-C-2B46
(ucs-set-char #x30C6 ?$@%F(B) ; J78-@-2546
(ucs-set-char #x30C6 ?$A%F(B) ; GB0-A-2546
(ucs-set-char #x30C6 ?$B%F(B) ; J83-B-2546

(ucs-set-char #x30C7 ?$(C+G(B) ; KS0-C-2B47
(ucs-set-char #x30C7 ?$@%G(B) ; J78-@-2547
(ucs-set-char #x30C7 ?$A%G(B) ; GB0-A-2547
(ucs-set-char #x30C7 ?$B%G(B) ; J83-B-2547

(ucs-set-char #x30C8 ?$(C+H(B) ; KS0-C-2B48
(ucs-set-char #x30C8 ?$@%H(B) ; J78-@-2548
(ucs-set-char #x30C8 ?$A%H(B) ; GB0-A-2548
(ucs-set-char #x30C8 ?$B%H(B) ; J83-B-2548

(ucs-set-char #x30C9 ?$(C+I(B) ; KS0-C-2B49
(ucs-set-char #x30C9 ?$@%I(B) ; J78-@-2549
(ucs-set-char #x30C9 ?$A%I(B) ; GB0-A-2549
(ucs-set-char #x30C9 ?$B%I(B) ; J83-B-2549

(ucs-set-char #x30CA ?$(C+J(B) ; KS0-C-2B4A
(ucs-set-char #x30CA ?$@%J(B) ; J78-@-254A
(ucs-set-char #x30CA ?$A%J(B) ; GB0-A-254A
(ucs-set-char #x30CA ?$B%J(B) ; J83-B-254A

(ucs-set-char #x30CB ?$(C+K(B) ; KS0-C-2B4B
(ucs-set-char #x30CB ?$@%K(B) ; J78-@-254B
(ucs-set-char #x30CB ?$A%K(B) ; GB0-A-254B
(ucs-set-char #x30CB ?$B%K(B) ; J83-B-254B

(ucs-set-char #x30CC ?$(C+L(B) ; KS0-C-2B4C
(ucs-set-char #x30CC ?$@%L(B) ; J78-@-254C
(ucs-set-char #x30CC ?$A%L(B) ; GB0-A-254C
(ucs-set-char #x30CC ?$B%L(B) ; J83-B-254C

(ucs-set-char #x30CD ?$(C+M(B) ; KS0-C-2B4D
(ucs-set-char #x30CD ?$@%M(B) ; J78-@-254D
(ucs-set-char #x30CD ?$A%M(B) ; GB0-A-254D
(ucs-set-char #x30CD ?$B%M(B) ; J83-B-254D

(ucs-set-char #x30CE ?$(C+N(B) ; KS0-C-2B4E
(ucs-set-char #x30CE ?$@%N(B) ; J78-@-254E
(ucs-set-char #x30CE ?$A%N(B) ; GB0-A-254E
(ucs-set-char #x30CE ?$B%N(B) ; J83-B-254E

(ucs-set-char #x30CF ?$(C+O(B) ; KS0-C-2B4F
(ucs-set-char #x30CF ?$@%O(B) ; J78-@-254F
(ucs-set-char #x30CF ?$A%O(B) ; GB0-A-254F
(ucs-set-char #x30CF ?$B%O(B) ; J83-B-254F

(ucs-set-char #x30D0 ?$(C+P(B) ; KS0-C-2B50
(ucs-set-char #x30D0 ?$@%P(B) ; J78-@-2550
(ucs-set-char #x30D0 ?$A%P(B) ; GB0-A-2550
(ucs-set-char #x30D0 ?$B%P(B) ; J83-B-2550

(ucs-set-char #x30D1 ?$(C+Q(B) ; KS0-C-2B51
(ucs-set-char #x30D1 ?$@%Q(B) ; J78-@-2551
(ucs-set-char #x30D1 ?$A%Q(B) ; GB0-A-2551
(ucs-set-char #x30D1 ?$B%Q(B) ; J83-B-2551

(ucs-set-char #x30D2 ?$(C+R(B) ; KS0-C-2B52
(ucs-set-char #x30D2 ?$@%R(B) ; J78-@-2552
(ucs-set-char #x30D2 ?$A%R(B) ; GB0-A-2552
(ucs-set-char #x30D2 ?$B%R(B) ; J83-B-2552

(ucs-set-char #x30D3 ?$(C+S(B) ; KS0-C-2B53
(ucs-set-char #x30D3 ?$@%S(B) ; J78-@-2553
(ucs-set-char #x30D3 ?$A%S(B) ; GB0-A-2553
(ucs-set-char #x30D3 ?$B%S(B) ; J83-B-2553

(ucs-set-char #x30D4 ?$(C+T(B) ; KS0-C-2B54
(ucs-set-char #x30D4 ?$@%T(B) ; J78-@-2554
(ucs-set-char #x30D4 ?$A%T(B) ; GB0-A-2554
(ucs-set-char #x30D4 ?$B%T(B) ; J83-B-2554

(ucs-set-char #x30D5 ?$(C+U(B) ; KS0-C-2B55
(ucs-set-char #x30D5 ?$@%U(B) ; J78-@-2555
(ucs-set-char #x30D5 ?$A%U(B) ; GB0-A-2555
(ucs-set-char #x30D5 ?$B%U(B) ; J83-B-2555

(ucs-set-char #x30D6 ?$(C+V(B) ; KS0-C-2B56
(ucs-set-char #x30D6 ?$@%V(B) ; J78-@-2556
(ucs-set-char #x30D6 ?$A%V(B) ; GB0-A-2556
(ucs-set-char #x30D6 ?$B%V(B) ; J83-B-2556

(ucs-set-char #x30D7 ?$(C+W(B) ; KS0-C-2B57
(ucs-set-char #x30D7 ?$@%W(B) ; J78-@-2557
(ucs-set-char #x30D7 ?$A%W(B) ; GB0-A-2557
(ucs-set-char #x30D7 ?$B%W(B) ; J83-B-2557

(ucs-set-char #x30D8 ?$(C+X(B) ; KS0-C-2B58
(ucs-set-char #x30D8 ?$@%X(B) ; J78-@-2558
(ucs-set-char #x30D8 ?$A%X(B) ; GB0-A-2558
(ucs-set-char #x30D8 ?$B%X(B) ; J83-B-2558

(ucs-set-char #x30D9 ?$(C+Y(B) ; KS0-C-2B59
(ucs-set-char #x30D9 ?$@%Y(B) ; J78-@-2559
(ucs-set-char #x30D9 ?$A%Y(B) ; GB0-A-2559
(ucs-set-char #x30D9 ?$B%Y(B) ; J83-B-2559

(ucs-set-char #x30DA ?$(C+Z(B) ; KS0-C-2B5A
(ucs-set-char #x30DA ?$@%Z(B) ; J78-@-255A
(ucs-set-char #x30DA ?$A%Z(B) ; GB0-A-255A
(ucs-set-char #x30DA ?$B%Z(B) ; J83-B-255A

(ucs-set-char #x30DB ?$(C+[(B) ; KS0-C-2B5B
(ucs-set-char #x30DB ?$@%[(B) ; J78-@-255B
(ucs-set-char #x30DB ?$A%[(B) ; GB0-A-255B
(ucs-set-char #x30DB ?$B%[(B) ; J83-B-255B

(ucs-set-char #x30DC ?$(C+\(B) ; KS0-C-2B5C
(ucs-set-char #x30DC ?$@%\(B) ; J78-@-255C
(ucs-set-char #x30DC ?$A%\(B) ; GB0-A-255C
(ucs-set-char #x30DC ?$B%\(B) ; J83-B-255C

(ucs-set-char #x30DD ?$(C+](B) ; KS0-C-2B5D
(ucs-set-char #x30DD ?$@%](B) ; J78-@-255D
(ucs-set-char #x30DD ?$A%](B) ; GB0-A-255D
(ucs-set-char #x30DD ?$B%](B) ; J83-B-255D

(ucs-set-char #x30DE ?$(C+^(B) ; KS0-C-2B5E
(ucs-set-char #x30DE ?$@%^(B) ; J78-@-255E
(ucs-set-char #x30DE ?$A%^(B) ; GB0-A-255E
(ucs-set-char #x30DE ?$B%^(B) ; J83-B-255E

(ucs-set-char #x30DF ?$(C+_(B) ; KS0-C-2B5F
(ucs-set-char #x30DF ?$@%_(B) ; J78-@-255F
(ucs-set-char #x30DF ?$A%_(B) ; GB0-A-255F
(ucs-set-char #x30DF ?$B%_(B) ; J83-B-255F

(ucs-set-char #x30E0 ?$(C+`(B) ; KS0-C-2B60
(ucs-set-char #x30E0 ?$@%`(B) ; J78-@-2560
(ucs-set-char #x30E0 ?$A%`(B) ; GB0-A-2560
(ucs-set-char #x30E0 ?$B%`(B) ; J83-B-2560

(ucs-set-char #x30E1 ?$(C+a(B) ; KS0-C-2B61
(ucs-set-char #x30E1 ?$@%a(B) ; J78-@-2561
(ucs-set-char #x30E1 ?$A%a(B) ; GB0-A-2561
(ucs-set-char #x30E1 ?$B%a(B) ; J83-B-2561

(ucs-set-char #x30E2 ?$(C+b(B) ; KS0-C-2B62
(ucs-set-char #x30E2 ?$@%b(B) ; J78-@-2562
(ucs-set-char #x30E2 ?$A%b(B) ; GB0-A-2562
(ucs-set-char #x30E2 ?$B%b(B) ; J83-B-2562

(ucs-set-char #x30E3 ?$(C+c(B) ; KS0-C-2B63
(ucs-set-char #x30E3 ?$@%c(B) ; J78-@-2563
(ucs-set-char #x30E3 ?$A%c(B) ; GB0-A-2563
(ucs-set-char #x30E3 ?$B%c(B) ; J83-B-2563

(ucs-set-char #x30E4 ?$(C+d(B) ; KS0-C-2B64
(ucs-set-char #x30E4 ?$@%d(B) ; J78-@-2564
(ucs-set-char #x30E4 ?$A%d(B) ; GB0-A-2564
(ucs-set-char #x30E4 ?$B%d(B) ; J83-B-2564

(ucs-set-char #x30E5 ?$(C+e(B) ; KS0-C-2B65
(ucs-set-char #x30E5 ?$@%e(B) ; J78-@-2565
(ucs-set-char #x30E5 ?$A%e(B) ; GB0-A-2565
(ucs-set-char #x30E5 ?$B%e(B) ; J83-B-2565

(ucs-set-char #x30E6 ?$(C+f(B) ; KS0-C-2B66
(ucs-set-char #x30E6 ?$@%f(B) ; J78-@-2566
(ucs-set-char #x30E6 ?$A%f(B) ; GB0-A-2566
(ucs-set-char #x30E6 ?$B%f(B) ; J83-B-2566

(ucs-set-char #x30E7 ?$(C+g(B) ; KS0-C-2B67
(ucs-set-char #x30E7 ?$@%g(B) ; J78-@-2567
(ucs-set-char #x30E7 ?$A%g(B) ; GB0-A-2567
(ucs-set-char #x30E7 ?$B%g(B) ; J83-B-2567

(ucs-set-char #x30E8 ?$(C+h(B) ; KS0-C-2B68
(ucs-set-char #x30E8 ?$@%h(B) ; J78-@-2568
(ucs-set-char #x30E8 ?$A%h(B) ; GB0-A-2568
(ucs-set-char #x30E8 ?$B%h(B) ; J83-B-2568

(ucs-set-char #x30E9 ?$(C+i(B) ; KS0-C-2B69
(ucs-set-char #x30E9 ?$@%i(B) ; J78-@-2569
(ucs-set-char #x30E9 ?$A%i(B) ; GB0-A-2569
(ucs-set-char #x30E9 ?$B%i(B) ; J83-B-2569

(ucs-set-char #x30EA ?$(C+j(B) ; KS0-C-2B6A
(ucs-set-char #x30EA ?$@%j(B) ; J78-@-256A
(ucs-set-char #x30EA ?$A%j(B) ; GB0-A-256A
(ucs-set-char #x30EA ?$B%j(B) ; J83-B-256A

(ucs-set-char #x30EB ?$(C+k(B) ; KS0-C-2B6B
(ucs-set-char #x30EB ?$@%k(B) ; J78-@-256B
(ucs-set-char #x30EB ?$A%k(B) ; GB0-A-256B
(ucs-set-char #x30EB ?$B%k(B) ; J83-B-256B

(ucs-set-char #x30EC ?$(C+l(B) ; KS0-C-2B6C
(ucs-set-char #x30EC ?$@%l(B) ; J78-@-256C
(ucs-set-char #x30EC ?$A%l(B) ; GB0-A-256C
(ucs-set-char #x30EC ?$B%l(B) ; J83-B-256C

(ucs-set-char #x30ED ?$(C+m(B) ; KS0-C-2B6D
(ucs-set-char #x30ED ?$@%m(B) ; J78-@-256D
(ucs-set-char #x30ED ?$A%m(B) ; GB0-A-256D
(ucs-set-char #x30ED ?$B%m(B) ; J83-B-256D

(ucs-set-char #x30EE ?$(C+n(B) ; KS0-C-2B6E
(ucs-set-char #x30EE ?$@%n(B) ; J78-@-256E
(ucs-set-char #x30EE ?$A%n(B) ; GB0-A-256E
(ucs-set-char #x30EE ?$B%n(B) ; J83-B-256E

(ucs-set-char #x30EF ?$(C+o(B) ; KS0-C-2B6F
(ucs-set-char #x30EF ?$@%o(B) ; J78-@-256F
(ucs-set-char #x30EF ?$A%o(B) ; GB0-A-256F
(ucs-set-char #x30EF ?$B%o(B) ; J83-B-256F

(ucs-set-char #x30F0 ?$(C+p(B) ; KS0-C-2B70
(ucs-set-char #x30F0 ?$@%p(B) ; J78-@-2570
(ucs-set-char #x30F0 ?$A%p(B) ; GB0-A-2570
(ucs-set-char #x30F0 ?$B%p(B) ; J83-B-2570

(ucs-set-char #x30F1 ?$(C+q(B) ; KS0-C-2B71
(ucs-set-char #x30F1 ?$@%q(B) ; J78-@-2571
(ucs-set-char #x30F1 ?$A%q(B) ; GB0-A-2571
(ucs-set-char #x30F1 ?$B%q(B) ; J83-B-2571

(ucs-set-char #x30F2 ?$(C+r(B) ; KS0-C-2B72
(ucs-set-char #x30F2 ?$@%r(B) ; J78-@-2572
(ucs-set-char #x30F2 ?$A%r(B) ; GB0-A-2572
(ucs-set-char #x30F2 ?$B%r(B) ; J83-B-2572

(ucs-set-char #x30F3 ?$(C+s(B) ; KS0-C-2B73
(ucs-set-char #x30F3 ?$@%s(B) ; J78-@-2573
(ucs-set-char #x30F3 ?$A%s(B) ; GB0-A-2573
(ucs-set-char #x30F3 ?$B%s(B) ; J83-B-2573

(ucs-set-char #x30F4 ?$(C+t(B) ; KS0-C-2B74
(ucs-set-char #x30F4 ?$@%t(B) ; J78-@-2574
(ucs-set-char #x30F4 ?$A%t(B) ; GB0-A-2574
(ucs-set-char #x30F4 ?$B%t(B) ; J83-B-2574

(ucs-set-char #x30F5 ?$(C+u(B) ; KS0-C-2B75
(ucs-set-char #x30F5 ?$@%u(B) ; J78-@-2575
(ucs-set-char #x30F5 ?$A%u(B) ; GB0-A-2575
(ucs-set-char #x30F5 ?$B%u(B) ; J83-B-2575

(ucs-set-char #x30F6 ?$(C+v(B) ; KS0-C-2B76
(ucs-set-char #x30F6 ?$@%v(B) ; J78-@-2576
(ucs-set-char #x30F6 ?$A%v(B) ; GB0-A-2576
(ucs-set-char #x30F6 ?$B%v(B) ; J83-B-2576

(ucs-set-char #x30FB ?$A!$(B) ; GB0-A-2124
(ucs-set-char #x30FB ?$@!&(B) ; J78-@-2126
(ucs-set-char #x30FB ?$B!&(B) ; J83-B-2126

(ucs-set-char #x30FC ?$@!<(B) ; J78-@-213C
(ucs-set-char #x30FC ?$B!<(B) ; J83-B-213C

(ucs-set-char #x30FD ?$@!3(B) ; J78-@-2133
(ucs-set-char #x30FD ?$B!3(B) ; J83-B-2133

(ucs-set-char #x30FE ?$@!4(B) ; J78-@-2134
(ucs-set-char #x30FE ?$B!4(B) ; J83-B-2134

;;; ucs-katakana.el ends here
