/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import java.util.List;
import jde.debugger.Debug;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.Protocol;

public abstract class DebugCommand
extends Thread
implements Protocol,
Cloneable {
    Integer appID;
    Integer cmdID;
    String cmdName;
    List args;

    public DebugCommand() {
        super("JDEbug command");
    }

    public void init(Integer appID, Integer cmdID, String cmdName, List args) throws JDEException {
        this.appID = appID;
        this.cmdID = cmdID;
        this.cmdName = cmdName;
        this.args = args;
        this.setName("JDEbug command(" + appID + " " + cmdID + " " + cmdName + ")");
    }

    protected abstract void doCommand() throws JDEException;

    public void run() {
        if (Jdebug.theDebugger.pendingCmdExists(this.cmdID)) {
            Jdebug.theDebugger.signalCommandError(Jdebug.debuggerID, new Integer(-1), "Duplicate cmd_id '" + this.cmdID + "'");
            return;
        }
        Jdebug.theDebugger.addPendingCommand(this.cmdID);
        try {
            try {
                this.doCommand();
            }
            catch (JDEException ex) {
                Debug.printIf(ex);
                Jdebug.theDebugger.signalCommandError(Jdebug.debuggerID, this.cmdID, ex.getMessage());
                Object var4_2 = null;
                Jdebug.theDebugger.removePendingCommand(this.cmdID);
                return;
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                Jdebug.theDebugger.signalCommandError(Jdebug.debuggerID, this.cmdID, "Unspecified error: " + ex.toString());
                Object var4_3 = null;
                Jdebug.theDebugger.removePendingCommand(this.cmdID);
                return;
            }
            Object var4_1 = null;
            Jdebug.theDebugger.removePendingCommand(this.cmdID);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Jdebug.theDebugger.removePendingCommand(this.cmdID);
            throw throwable;
        }
    }

    public abstract Object clone();
}

