/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLE_PTREE_H__
#define __GLE_PTREE_H__


#include	<gle/glegwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* --- type macros --- */
#define GLE_TYPE_PTREE			(gle_ptree_get_type ())
#define GLE_PTREE(obj)			(GTK_CHECK_CAST ((obj), GLE_TYPE_PTREE, GlePTree))
#define GLE_PTREE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GLE_TYPE_PTREE, GlePTreeClass))
#define GLE_IS_PTREE(obj)		(GTK_CHECK_TYPE ((obj), GLE_TYPE_PTREE))
#define GLE_IS_PTREE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GLE_TYPE_PTREE))


/* --- PTree columns --- */
enum
{
  GLE_PTREE_COL_OTYPE,
  GLE_PTREE_COL_STATE,
  GLE_PTREE_COL_GNAME,
  GLE_PTREE_COL_NAME,
  GLE_PTREE_N_COLS
} GlePTreeColumnType;


/* --- typedefs --- */
typedef struct	_GlePTree		GlePTree;
typedef	struct	_GlePTreeClass		GlePTreeClass;
typedef	struct	_GlePTreeRowData	GlePTreeRowData;


/* --- structures --- */
struct	_GlePTree
{
  GtkCTree	ctree;
  
  GleGWidget	*gwidget;
  
  GlePTreeRowData *shown_row_data;
};
struct	_GlePTreeClass
{
  GtkCTreeClass		parent_class;
  
  guint			 row_data_mem_chunk_ref;
  GMemChunk		*row_data_mem_chunk;
  
  gboolean		(*button_click)	(GlePTree   *ptree,
					 GleGWidget *gwidget,
					 guint	     root_x,
					 guint	     root_y,
					 guint	     button,
					 guint	     time);
};
struct _GlePTreeRowData
{
  GlePTree	*ptree;
  GleGWidget	*gwidget;
  guint		 is_connected : 1;
  GtkCTreeNode	*ct_node;
};


/* --- prototypes --- */
GtkType		gle_ptree_get_type		(void);
GtkWidget*	gle_ptree_new			(void);
void		gle_ptree_set_gwidget		(GlePTree	*ptree,
						 GleGWidget	*gwidget);
void		gle_ptree_update		(GlePTree	*ptree);
void		gle_ptree_rebuild		(GlePTree	*ptree);
gboolean	gle_ptree_mark_gwidget		(GlePTree	*ptree,
						 GleGWidget	*gwidget);
GleGWidget*	gle_ptree_gwidget_from_node	(GlePTree	*ptree,
						 GtkCTreeNode	*ct_node);
GSList*		gle_ptree_selected_gwidgets	(GlePTree	*ptree);
GlePTreeRowData*gle_ptree_row_data_from_gwidget	(GlePTree	*ptree,
						 GleGWidget	*gwidget);
void		gle_ptree_insert_gwidget	(GlePTree	*ptree,
						 GleGWidget	*gwidget);





#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __GLE_PTREE_H__ */
