/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"glemessagebox.h"
#include        <stdarg.h>

/* --- prototypes --- */
static void     gle_message_box_init		(GleMessageBox	*mb);


/* --- functions --- */
GtkType
gle_message_box_get_type (void)
{
  static GtkType mb_type = 0;

  if (!mb_type)
    {
      GtkTypeInfo mb_info =
      {
	"GleMessageBox",
	sizeof (GleMessageBox),
	sizeof (GleMessageBoxClass),
	(GtkClassInitFunc) NULL,
	(GtkObjectInitFunc) gle_message_box_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };

      mb_type = gtk_type_unique (gtk_window_get_type (), &mb_info);
    }

  return mb_type;
}

static void
gle_message_box_init (GleMessageBox  *mb)
{
  GtkWidget *main_vbox;
  GtkWidget *vbox;
  GtkWidget *any;
  GtkWidget *button;

  gtk_widget_set (GTK_WIDGET (mb),
		  "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
		  "GtkWindow::title", "BEAST Message",
		  "GtkWindow::window_position", GTK_WIN_POS_MOUSE,
		  "GtkWindow::allow_shrink", FALSE,
		  "GtkWindow::allow_grow", FALSE,
		  "GtkWindow::auto_shrink", TRUE,
		  NULL);
  main_vbox =
    gtk_widget_new (gtk_vbox_get_type (),
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 0,
		    "GtkWidget::parent", mb,
		    "GtkWidget::visible", TRUE,
		    NULL);
  vbox =
    gtk_widget_new (gtk_vbox_get_type (),
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 5,
		    "GtkWidget::parent", main_vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  mb->text_label =
    gtk_widget_new (gtk_label_get_type (),
		    "GtkLabel::label", "A Message",
		    "GtkWidget::parent", vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  gtk_label_set_justify (GTK_LABEL (mb->text_label), GTK_JUSTIFY_LEFT);
  any =
    gtk_widget_new (gtk_hseparator_get_type (),
		    "GtkWidget::parent", main_vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  vbox =
    gtk_widget_new (gtk_vbox_get_type (),
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 5,
		    "GtkWidget::parent", main_vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  button =
    gtk_widget_new (gtk_button_get_type (),
		    "GtkButton::label", "Close",
		    "GtkWidget::parent", vbox,
		    "GtkWidget::visible", TRUE,
		    "GtkWidget::can_default", TRUE,
		    "GtkWidget::has_default", TRUE,
		    "GtkObject::object_signal::clicked", gtk_widget_destroy, mb,
		    NULL);
}

GtkWidget*
gle_message_box_new (const gchar    *message)
{
  GtkWidget *widget;

  g_return_val_if_fail (message != NULL, NULL);

  widget = gtk_type_new (gle_message_box_get_type ());

  gle_message_box_set_text (GLE_MESSAGE_BOX (widget),
			    message);

  return widget;
}

void
gle_message_box_set_text (GleMessageBox  *mb,
			  const gchar    *message)
{
  g_return_if_fail (mb != NULL);
  g_return_if_fail (GLE_IS_MESSAGE_BOX (mb));
  g_return_if_fail (message != NULL);

  gtk_label_set_text (GTK_LABEL (mb->text_label), message);
}

void
gle_message_box_set_textf (GleMessageBox  *mb,
			   const gchar    *message_format,
			   ...)
{
  gchar *buffer;
  va_list    args;

  g_return_if_fail (mb != NULL);
  g_return_if_fail (GLE_IS_MESSAGE_BOX (mb));
  g_return_if_fail (message_format != NULL);

  va_start (args, message_format);
  buffer = g_strdup_vprintf (message_format, args);
  va_end (args);

  gle_message_box_set_text (mb, buffer);

  g_free (buffer);
}

GtkWidget*
gle_message_box_popup (GtkObject      *alive_object,
		       const gchar    *message_format,
		       ...)
{
  GtkWidget *mb;
  va_list    args;
  gchar *buffer;

  g_return_val_if_fail (message_format != NULL, NULL);

  va_start (args, message_format);
  buffer = g_strdup_vprintf (message_format, args);
  va_end (args);

  mb = gle_message_box_new (buffer);

  g_free (buffer);
  
  if (alive_object)
    gtk_signal_connect_object_while_alive (GTK_OBJECT (alive_object),
					   "destroy",
					   GTK_SIGNAL_FUNC (gtk_widget_destroy),
					   GTK_OBJECT (mb));
  else
    gtk_quit_add_destroy (1, GTK_OBJECT (mb));

  gtk_widget_show (mb);

  return mb;
}
