/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLE_GWIDGET_H__
#define __GLE_GWIDGET_H__


#include	<gle/glegobject.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* --- GleGWidget flags --- */
typedef enum
{
  GLE_GWIDGET_INTERNAL	 = 1 << (GLE_GOBJECT_FLAGS_NEXT_SHIFT),
  GLE_GWIDGET_COMPOSITE	 = 2 << (GLE_GOBJECT_FLAGS_NEXT_SHIFT)
#define GLE_GWIDGET_FLAGS_NEXT_SHIFT	(GLE_GOBJECT_FLAGS_NEXT_SHIFT + 1)
} GleGWidgetFlags;


/* --- GWidget macros --- */
#define GLE_TYPE_GWIDGET		(gle_gwidget_get_type ())
#define GLE_GWIDGET(gw)			(GTK_CHECK_CAST ((gw), GLE_TYPE_GWIDGET, GleGWidget))
#define GLE_GWIDGET_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), GLE_TYPE_GWIDGET, GleGWidgetClass))
#define GLE_IS_GWIDGET(gw)		(GTK_CHECK_TYPE ((gw), GLE_TYPE_GWIDGET))
#define GLE_IS_GWIDGET_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GLE_TYPE_GWIDGET))
#define GLE_GWIDGET_GET_CLASS(gw)	(GLE_GWIDGET_CLASS (GLE_GOBJECT (gw)->type_object.klass))

#define GLE_GWIDGET_INTERNAL(gw)	((GLE_GOBJECT_FLAGS (gw) & GLE_GWIDGET_INTERNAL) > 0)
#define GLE_GWIDGET_COMPOSITE(gw)	((GLE_GOBJECT_FLAGS (gw) & GLE_GWIDGET_COMPOSITE) > 0)
#define	GLE_GWIDGET_WIDGET(gw)		((GtkWidget*) GLE_GOBJECT (gw)->object)
#define	GLE_GWIDGET_OBJECT(gw)		(GLE_GOBJECT (gw)->object)


/* --- typedefs --- */
typedef struct	_GleGWidget		GleGWidget;
typedef struct	_GleGWidgetClass	GleGWidgetClass;


/* --- structures --- */
struct _GleGWidget
{
  GleGObject	gobject;
  
  GleGWidget	*parent;
};
struct _GleGWidgetClass
{
  GleGObjectClass	gobject_class;

  /* notify methods
   */
  void	(*set_parent)	(GleGWidget	*gwidget,
			 GleGWidget	*gcontainer);
};


/* --- GleGWidget methods --- */
GtkType		gle_gwidget_get_type		(void) G_GNUC_CONST;
GleGWidget*	gle_gwidget_new			(GtkType	 gtk_type);
void		gle_gwidget_destroy		(GleGWidget	*gwidget);
void		gle_gwidget_apply_style_args	(GleGWidget	*gwidget);
void		gle_gwidget_reset_style_args	(GleGWidget	*gwidget);
void		gle_gwidget_restore_style_args	(GleGWidget	*gwidget);
void		gle_gwidget_save_style_args	(GleGWidget	*gwidget);
void		gle_gwidget_update_style_args	(GleGWidget	*gwidget);
void		gle_gwidget_apply_child_args	(GleGWidget	*gwidget);
void		gle_gwidget_reset_child_args	(GleGWidget	*gwidget);
void		gle_gwidget_restore_child_args	(GleGWidget	*gwidget);
void		gle_gwidget_save_child_args	(GleGWidget	*gwidget);
void		gle_gwidget_update_child_args	(GleGWidget	*gwidget);
gboolean	gle_gwidget_is_shell_owned	(GleGWidget	*gwidget);
GleGArg*	gle_gwidget_get_style_garg	(GleGWidget	*gwidget,
						 const gchar	*arg_name);
GleGArg*	gle_gwidget_get_child_garg	(GleGWidget	*gwidget,
						 const gchar	*arg_name);
gchar*		gle_gwidget_get_composite_name	(GleGWidget	*gwidget);
gboolean	gle_gwidget_set_visible		(GleGWidget	*gwidget,
						 gboolean	 visible);


/* --- GtkWidget prototypes --- */
GleGWidget*	gle_widget_force_gwidget	(GtkWidget	*widget);
GleGWidget*	gle_widget_get_gwidget		(GtkWidget	*widget);
GtkWidget*      gle_widget_from_gname           (const gchar    *gname);


/* --- internal prototypes --- */
void		gle_gwidget_ref			(GleGWidget	*gwidget);
void		gle_gwidget_unref		(GleGWidget	*gwidget);
GSList*		gle_gwidgets_list		(void);
void		gle_gwidget_rebuild_child_args	(GleGWidget	*gwidget);
void		gle_gwidget_rebuild_style_args	(GleGWidget	*gwidget);
void		gle_gwidget_set_parent		(GleGWidget	*gwidget,
						 GleGWidget	*gcontainer);






#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLE_GWIDGET_H__ */
