/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLEGARG_H__
#define __GLEGARG_H__


#include	<gle/glemisc.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* --- type macros --- */
#define	GLE_GARG_CLASS_TYPE(garg)	 (((GleGArg*)(garg))->info->class_type)
#define	GLE_GARG_ARG_TYPE(garg)		 (((GleGArg*)(garg))->info->arg->type)
#define	GLE_GARG_FLAGS(garg)		 (((GleGArg*)(garg))->info->arg_flags)
#define	GLE_GARG_IS_READABLE(garg)	 ((GLE_GARG_FLAGS (garg) & GTK_ARG_READABLE) != 0)
#define	GLE_GARG_IS_WRITABLE(garg)	 ((GLE_GARG_FLAGS (garg) & GTK_ARG_WRITABLE) != 0)
#define	GLE_GARG_IS_READWRITE(garg)	 (GLE_GARG_IS_READABLE (garg) && GLE_GARG_IS_WRITABLE (garg))
#define	GLE_GARG_IS_CONSTRUCT(garg)	 ((GLE_GARG_FLAGS (garg) & (GTK_ARG_CONSTRUCT_ONLY | GTK_ARG_CONSTRUCT)) != 0)
#define	GLE_GARG_IS_CONSTRUCT_ONLY(garg) ((GLE_GARG_FLAGS (garg) & GTK_ARG_CONSTRUCT_ONLY) != 0)
#define	GLE_GARG_IS_CHILD_ARG(garg)	 ((GLE_GARG_FLAGS (garg) & GTK_ARG_CHILD_ARG) != 0)
#define	GLE_GARG_SETTING_FAILED(garg)	 (((GleGArg*)(garg))->setting_failed)
#define	GLE_GARG_NEEDS_SET(garg)	 (((GleGArg*)(garg))->needs_set)


/* --- typedefs --- */
typedef	struct _GleGArg		GleGArg;
typedef	struct _GleArgInfo	GleArgInfo;

struct _GleGArg
{
  const gchar		*arg_name;
  const GleArgInfo	*info;

  GtkWidget		*widget;

  guint			 setting_failed : 1;
  guint			 needs_set : 1;
  GtkArg		 saved_arg;
  GtkArg		 object_arg;
};
struct	_GleArgInfo
{
  GtkType	class_type;
  guint		arg_flags;
  guint 	seq_num;
  const GtkArg	*arg;
};

typedef enum
{
  GLE_GARG_CB_ARG_RESET		= 1,
  GLE_GARG_CB_ARG_SAVE,
  GLE_GARG_CB_ARG_RESTORE,
  GLE_GARG_CB_ARG_GET,
  GLE_GARG_CB_ARG_SET
} GleGArgCbType;
typedef	void	(*GleGArgCbFunc)	(GleGArg	*garg,
					 GleGArgCbType	 cb_type);


/* --- GleGArg prototypes --- */
GleGArg*	gle_garg_new		(const GleArgInfo	*info);
gboolean	gle_garg_defaults	(GleGArg		*garg);
void		gle_garg_reset		(GleGArg		*garg);
void		gle_garg_save		(GleGArg		*garg);
void		gle_garg_restore	(GleGArg		*garg);
void		gle_garg_free		(GleGArg		*garg);
void		gle_garg_get		(GleGArg		*garg,
					 GtkObject		*object,
					 GtkWidget		*child);
void		gle_garg_set		(GleGArg		*garg,
					 GtkObject		*object,
					 GtkWidget		*child);
void		gle_garg_widget_set_cb	(GtkWidget		*widget,
					 GleGArgCbFunc		 cb_func);


/* --- GtkArg prototypes --- */
gint			gle_arg_values_equal	(const GtkArg	*arg1,
						 const GtkArg	*arg2);
gint			gle_arg_copy_value	(const GtkArg	*src_arg,
						 GtkArg		*dest_arg);
void			gle_arg_reset		(GtkArg		*arg);
const GleArgInfo*	gle_arg_get_info	(const gchar	*arg_name,
						 gboolean	 is_child_arg);
void			gle_arg_set_from_string (GtkArg		*arg,
						 const gchar	*value_string);






#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLEGARG_H__ */
