/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	<gle/gleconfig.h>

#include	"gleetils.h"
#include	"gleprivate.h"
#include	<gtk/gtkprivate.h>



/* --- variables --- */
static const gchar	*key_flag_list = GLE_PRIVATE_KEY (gle-flag-list);

/* --- functions --- */
static GtkWidget*
flag_list_build (GtkObject   *object,
		 GtkBox	     *parent,
		 const gchar *flags_name,
		 guint	      flags)
{
  GtkFlagValue *fv;
  GtkWidget *frame;
  GtkWidget *hbox;
  GtkWidget *vbox2;

  fv = gtk_type_flags_get_values (gtk_type_from_name (flags_name));

  frame =
    gtk_widget_new (GTK_TYPE_FRAME,
		    "GtkFrame::label", flags_name,
		    "GtkWidget::visible", TRUE,
		    "GtkWidget::parent", parent,
		    NULL);
  hbox =
    gtk_widget_new (GTK_TYPE_HBOX,
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 5,
		    "GtkContainer::border_width", 5,
		    "GtkWidget::parent", frame,
		    "GtkWidget::visible", TRUE,
		    NULL);
  vbox2 =
    gtk_widget_new (GTK_TYPE_VBOX,
		    "GtkBox::homogeneous", TRUE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 0,
		    "GtkWidget::parent", hbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  while (fv->value_nick)
    {
      GtkWidget *tb;

      tb =
	gtk_widget_new (GTK_TYPE_CHECK_BUTTON,
			"GtkWidget::visible", TRUE,
			"GtkWidget::sensitive", FALSE,
			"GtkWidget::parent", vbox2,
			"GtkButton::label", fv->value_nick,
			"GtkToggleButton::active", (flags & fv->value) != 0,
			NULL);
      fv++;
    }

  return frame;
}

GtkWindow*
gle_object_popup_flag_list (GtkObject      *object)
{
  GtkWidget *window;
  GtkWidget *main_vbox;
  GtkWidget *vbox;
  GtkWidget *frame;

  g_return_val_if_fail (object != NULL, NULL);
  g_return_val_if_fail (GTK_IS_OBJECT (object), NULL);

  window =
    gtk_widget_new (GTK_TYPE_WINDOW,
		    "GtkWidget::name", "GLE-Flag-List",
		    "GtkWindow::title", "GLE-Flag-List",
		    "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
		    "GtkWindow::allow_shrink", TRUE,
		    "GtkWindow::allow_grow", TRUE,
		    "GtkWindow::auto_shrink", FALSE,
		    NULL);
  main_vbox =
    gtk_widget_new (GTK_TYPE_VBOX,
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 0,
		    "GtkWidget::parent", window,
		    "GtkWidget::visible", TRUE,
		    NULL);
  vbox =
    gtk_widget_new (GTK_TYPE_VBOX,
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 5,
		    "GtkContainer::border_width", 5,
		    "GtkWidget::parent", main_vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  if (GTK_IS_OBJECT (object))
    {
      frame = flag_list_build (object, GTK_BOX (vbox), "GtkObjectFlags", GTK_OBJECT_FLAGS (object));
    }
  if (GTK_IS_WIDGET (object))
    {
      frame = flag_list_build (object, GTK_BOX (vbox), "GtkWidgetFlags", GTK_OBJECT_FLAGS (object));
    }
  if (GTK_IS_WIDGET (object))
    {
      frame = flag_list_build (object, GTK_BOX (vbox), "GtkPrivateFlags", GTK_PRIVATE_FLAGS (object));
    }

  gtk_widget_show (window);

  return GTK_WINDOW (window);
}
