/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEGWIDGET_H__
#define __GLEGWIDGET_H__


#include	"glegobject.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- type macros --- */
#define GLE_GWIDGET(gwidget)	((GleGWidget*)(gwidget))
#define	GLE_IS_GWIDGET(gwidget)	(gtk_type_is_a(GLE_GWIDGET(gwidget)->gobject.type,GTK_TYPE_WIDGET))


/* --- GLE macros --- */
#define	GLE_GWIDGET_WIDGET(gwidget) ((GtkWidget*)GLE_GOBJECT((gwidget))->object)


/* --- typedefs --- */
typedef struct	_GleGWidget	GleGWidget;


/* --- structures --- */
struct _GleGWidget
{
  GleGObject	gobject;

  GleGWidget	*parent;

  GList		*children;

  guint         destroyed_handler;
  guint		parent_set_handler;
};



/* --- GleGWidget prototypes --- */
GleGWidget*	gle_gwidget_new			(GtkType	 type,
						 const gchar	*gle_name,
						 gboolean	 generic_name);
gchar*		gle_gwidget_create_gle_name	(GleGWidget	*parent,
						 GtkType	 child_type);
void            gle_gwidget_associate           (GleGWidget     *gwidget,
						 GtkWidget      *widget);
GtkWidget*      gle_gwidget_instantiate         (GleGWidget     *gwidget);
void            gle_gwidget_disassociate        (GleGWidget     *gwidget);


/* --- GtkWidget prototypes --- */
gchar*		gle_widget_create_gle_name	(GtkWidget	*widget);
GleGWidget*     gle_widget_force_gwidget        (GtkWidget      *widget);
GleGWidget*	gle_widget_get_gwidget          (GtkWidget      *widget);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEGWIDGET_H__ */
