/* GtkWidgetTree
 * Copyright (C) 1998 Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	<gtk/gtk.h>

typedef struct _GtkTreeNode	GtkTreeNode;
struct _GtkTreeNode
{
  GtkType type;
  GList   *children;
};

static gchar *indent = NULL;

static void
node_foreach (GtkTreeNode *node)
{
  GList *list;
  gchar *old_indent = indent;
  gchar *cont;

  printf ("%s%s\n", indent + 1, gtk_type_name (node->type));
  if (indent[strlen (indent) - 1] == '`')
    indent[strlen (indent) - 1] = ' ';

  indent = g_strconcat (old_indent, " +", NULL);
  cont = indent + strlen (old_indent) - 1;
  if (*cont == '+')
    *cont = '|';
  list = node->children;
  while (list)
    {
      node = list->data;
      list = list->next;
      if (!list)
	indent[strlen (indent) - 1] = '`';
      node_foreach (node);
    }
  g_free (indent);
  indent = old_indent;
}

int
main (void)
{
  GList *nodes, *list;
  GtkTreeNode *n, *object_node;

  nodes = NULL;
# define GLE_TYPE_CALL(type_func) n = g_new (GtkTreeNode, 1); n->type = type_func (); n->children = NULL; nodes = g_list_prepend (nodes, n);
#   include "gletypecalls.c"
# undef  GLE_TYPE_CALL

  object_node = NULL;
  list = nodes;
  while (list)
    {
      GList *tmp_list;
      GtkTreeNode *node;
      GtkType parent;

      node = list->data;
      list = list->next;

      parent = gtk_type_parent (node->type);
      if (node->type == gtk_object_get_type ())
	object_node = node;

      tmp_list = nodes;
      while (tmp_list)
	{
	  n = tmp_list->data;
	  if (n->type == parent)
	    {
	      n->children = g_list_prepend (n->children, node);
	      break;
	    }
	  tmp_list = tmp_list->next;
	}
    }

  indent = g_strdup (" ");
  node_foreach (object_node);

  return 0;
}
