/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include        "config.h"

#include        "gleprivate.h"


/* --- enums --- */
enum
{
  SIGNAL_SHUTDOWN,
  SIGNAL_LAST
};


/* -- global variables --- */
const gchar	*gle_key_gle_tag = GLE_PRIVATE_KEY (gle-internal-object-tag);
const gchar	*gle_key_shell = "gle-shell";


/* --- prototypes --- */
typedef void		(*GleRootObjectSignalShutdown)	(GtkObject      *object,
							 gpointer	func_data);
extern void		_gle_root_object_setup		(void);
extern void		_gle_root_object_finish		(void);


/* --- variables --- */
static GtkObject	*the_root_object = NULL;
static GtkType		the_root_object_type = 0;
static gint		the_root_object_signals[SIGNAL_LAST] = { 0 };


/* --- functions --- */
static void
gle_root_object_init_type (void)
{
  GtkTypeInfo root_object_info =
  {
    "GleRootObject",
    sizeof (GtkObject),
    sizeof (GtkObjectClass),
    (GtkClassInitFunc) NULL,
    (GtkObjectInitFunc) NULL,
    (GtkArgSetFunc) NULL,
    (GtkArgGetFunc) NULL,
  };

  the_root_object_type = gtk_type_unique (GTK_TYPE_OBJECT, &root_object_info);
  g_assert (the_root_object_type != 0);
}

static void
gle_root_object_finalize (GtkObject **gle_the_root_object_p)
{
  g_assert (gle_the_root_object_p == &the_root_object);

  *gle_the_root_object_p = NULL;
}

static void
gle_marshaller_shutdown (GtkObject     *object,
			 GtkSignalFunc func,
			 gpointer      func_data,
			 GtkArg        *args)
{
  GleRootObjectSignalShutdown rfunc = (GleRootObjectSignalShutdown) func;
  (* rfunc) (object, func_data);
}

void
_gle_root_object_setup (void)
{
  guint i;

  g_assert (the_root_object_type == 0);
  g_assert (the_root_object == NULL);

  gle_root_object_init_type ();
  the_root_object = gtk_object_new (the_root_object_type, NULL);
  the_root_object_signals[SIGNAL_SHUTDOWN] =
    gtk_object_class_add_user_signal (the_root_object->klass,
				      "shutdown",
				      gle_marshaller_shutdown,
				      GTK_TYPE_NONE, 0);
  gtk_signal_connect (the_root_object,
		      "destroy",
		      GTK_SIGNAL_FUNC (gle_root_shutdown),
		      NULL);
  gtk_object_weakref (the_root_object,
		      (GtkDestroyNotify) gle_root_object_finalize,
		      &the_root_object);
  for (i = 1; i < 42; i++)
    gtk_object_ref (the_root_object);
}

void
_gle_root_object_finish (void)
{
  g_assert (the_root_object_type != 0);
  g_assert (the_root_object != NULL);

  if (the_root_object->ref_count < 42)
    g_warning ("GLE: root-object reference count decremented by %d",
	       42 - the_root_object->ref_count);
  else
    g_warning ("GLE: root-object reference count increased by %d",
	       the_root_object->ref_count - 42);
  while (the_root_object->ref_count > 1)
    gtk_object_unref (the_root_object);
  gtk_object_sink (the_root_object);
  g_assert (the_root_object == NULL); /* FIXME: remove */
}

GtkObject*
gle_root_object (void)
{
  g_assert (the_root_object_type != 0);
  g_assert (the_root_object != NULL);

  return the_root_object;
}

void
gle_root_shutdown (void)
{
  gtk_signal_emit (gle_root_object (), the_root_object_signals[SIGNAL_SHUTDOWN]);
}

void
gle_root_connect_object_life (GtkObject      *object)
{
  GtkObject *root;
  GtkSignalFunc destructor;

  g_return_if_fail (object != NULL);
  g_return_if_fail (GTK_IS_OBJECT (object));
  root = gle_root_object ();
  g_return_if_fail (object != root);

  if (GTK_IS_WIDGET (object))
    destructor = GTK_SIGNAL_FUNC (gtk_widget_destroy);
  else
    destructor = GTK_SIGNAL_FUNC (gtk_object_destroy);
  
  gtk_signal_connect_object_while_alive (root,
					 "shutdown",
					 destructor,
					 object);
}

GtkWidget*
gle_root_get_shell (void)
{
  return gtk_object_get_data (gle_root_object (), gle_key_shell);
}
