/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"glegobject.h"


/* --- prototypes --- */
static void	gle_object_destroyed	(GtkObject	*object,
					 GleGObject	*gobject);


/* --- functions --- */
static void
gle_object_destroyed (GtkObject      *object,
		      GleGObject     *gobject)
{
  g_return_if_fail (object != NULL);
  g_return_if_fail (gobject != NULL);
  g_return_if_fail (GLE_IS_GOBJECT (gobject));
  g_return_if_fail (gobject->object == object);

  gobject->object = NULL;
}

const gchar*
gle_object_get_glename (GtkObject      *object)
{
  return NULL;
}

GleGObject*
gle_gobject_new (const gchar    *gle_name,
		 GtkType         type)
{
  return NULL;
}

GtkObject*
gle_gobject_instantiate (GleGObject     *gobject)
{
  return NULL;
}
