static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Massimo Valentini <mvalentini@src.gnome.org>                \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_gaussian_blur_filter2)                                       \n"
"   enum_value (GEGL_GAUSSIAN_BLUR_FILTER2_AUTO, \"auto\", N_(\"Auto\"))       \n"
"   enum_value (GEGL_GAUSSIAN_BLUR_FILTER2_FIR,  \"fir\",  N_(\"FIR\"))        \n"
"   enum_value (GEGL_GAUSSIAN_BLUR_FILTER2_IIR,  \"iir\",  N_(\"IIR\"))        \n"
"enum_end (GeglGaussianBlurFilter2)                                            \n"
"                                                                              \n"
"enum_start (gegl_gaussian_blur_policy)                                        \n"
"   enum_value (GEGL_GAUSSIAN_BLUR_ABYSS_NONE,  \"none\",   N_(\"None\"))      \n"
"   enum_value (GEGL_GAUSSIAN_BLUR_ABYSS_CLAMP, \"clamp\",  N_(\"Clamp\"))     \n"
"   enum_value (GEGL_GAUSSIAN_BLUR_ABYSS_BLACK, \"black\",  N_(\"Black\"))     \n"
"   enum_value (GEGL_GAUSSIAN_BLUR_ABYSS_WHITE, \"white\",  N_(\"White\"))     \n"
"enum_end (GeglGaussianBlurPolicy)                                             \n"
"                                                                              \n"
"property_double (std_dev_x, _(\"Size X\"), 1.5)                               \n"
"   description (_(\"Standard deviation for the horizontal axis\"))            \n"
"   value_range (0.0, 1500.0)                                                  \n"
"   ui_range    (0.24, 100.0)                                                  \n"
"   ui_gamma    (3.0)                                                          \n"
"   ui_meta     (\"unit\", \"pixel-distance\")                                 \n"
"   ui_meta     (\"axis\", \"x\")                                              \n"
"                                                                              \n"
"property_double (std_dev_y, _(\"Size Y\"), 1.5)                               \n"
"   description (_(\"Standard deviation (spatial scale factor)\"))             \n"
"   value_range (0.0, 1500.0)                                                  \n"
"   ui_range    (0.24, 100.0)                                                  \n"
"   ui_gamma    (3.0)                                                          \n"
"   ui_meta     (\"unit\", \"pixel-distance\")                                 \n"
"   ui_meta     (\"axis\", \"y\")                                              \n"
"                                                                              \n"
"property_enum (filter, _(\"Filter\"),                                         \n"
"               GeglGaussianBlurFilter2, gegl_gaussian_blur_filter2,           \n"
"               GEGL_GAUSSIAN_BLUR_FILTER2_AUTO)                               \n"
"   description (_(\"How the gaussian kernel is discretized\"))                \n"
"                                                                              \n"
"property_enum (abyss_policy, _(\"Abyss policy\"), GeglGaussianBlurPolicy,     \n"
"               gegl_gaussian_blur_policy, GEGL_GAUSSIAN_BLUR_ABYSS_CLAMP)     \n"
"   description (_(\"How image edges are handled\"))                           \n"
"                                                                              \n"
"property_boolean (clip_extent, _(\"Clip to the input extent\"), TRUE)         \n"
"   description (_(\"Should the output extent be clipped to the input extent\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_NAME     gaussian_blur                                        \n"
"#define GEGL_OP_C_SOURCE gaussian-blur.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglNode *gegl   = operation->node;                                         \n"
"  GeglNode *output = gegl_node_get_output_proxy (gegl, \"output\");           \n"
"                                                                              \n"
"  GeglNode *vblur  = gegl_node_new_child (gegl,                               \n"
"                                          \"operation\", \"gegl:gblur-1d\",   \n"
"                                          \"orientation\", 1,                 \n"
"                                          NULL);                              \n"
"                                                                              \n"
"  GeglNode *hblur  = gegl_node_new_child (gegl,                               \n"
"                                          \"operation\", \"gegl:gblur-1d\",   \n"
"                                          \"orientation\", 0,                 \n"
"                                          NULL);                              \n"
"                                                                              \n"
"  GeglNode *input  = gegl_node_get_input_proxy (gegl, \"input\");             \n"
"                                                                              \n"
"  gegl_node_link_many (input, hblur, vblur, output, NULL);                    \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"std-dev-x\",    hblur, \"std-dev\");\n"
"  gegl_operation_meta_redirect (operation, \"abyss-policy\", hblur, \"abyss-policy\");\n"
"  gegl_operation_meta_redirect (operation, \"filter\",       hblur, \"filter\");\n"
"  gegl_operation_meta_redirect (operation, \"clip-extent\",  hblur, \"clip-extent\");\n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"std-dev-y\",    vblur, \"std-dev\");\n"
"  gegl_operation_meta_redirect (operation, \"abyss-policy\", vblur, \"abyss-policy\");\n"
"  gegl_operation_meta_redirect (operation, \"filter\",       vblur, \"filter\");\n"
"  gegl_operation_meta_redirect (operation, \"clip-extent\",  vblur, \"clip-extent\");\n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation, hblur, vblur, NULL);            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"  operation_class->threaded = FALSE;                                          \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:gaussian-blur\",                                  \n"
"    \"categories\",  \"blur\",                                                \n"
"    \"description\", _(\"Performs an averaging of neighboring pixels with the \"\n"
"                     \"normal distribution as weighting\"),                   \n"
"                                 NULL);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
