static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * This plugin is used for removing the red-eye effect                        \n"
" * that occurs in flash photos.                                               \n"
" *                                                                            \n"
" * Based on a GIMP 1.2 Perl plugin by Geoff Kuenning                          \n"
" *                                                                            \n"
" * Copyright (C) 2004 Robert Merkel <robert.merkel@benambra.org>              \n"
" * Copyright (C) 2006 Andreas Røsdal <andrearo@stud.ntnu.no>                 \n"
" * Copyright (C) 2011 Robert Sasu <sasu.robert@gmail.com>                     \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (threshold, _(\"Threshold\"), 0.4)                            \n"
"    description (_(\"Red eye threshold\"))                                    \n"
"    value_range (0, 0.8)                                                      \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     red_eye_removal                                      \n"
"#define GEGL_OP_C_SOURCE red-eye-removal.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define RED_FACTOR    0.5133333                                               \n"
"#define GREEN_FACTOR  1                                                       \n"
"#define BLUE_FACTOR   0.1933333                                               \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"red_eye_reduction (gfloat *buf,                                               \n"
"                   gfloat  threshold)                                         \n"
"{                                                                             \n"
"  gfloat adjusted_red       = buf[0] * RED_FACTOR;                            \n"
"  gfloat adjusted_green     = buf[1] * GREEN_FACTOR;                          \n"
"  gfloat adjusted_blue      = buf[2] * BLUE_FACTOR;                           \n"
"  gfloat adjusted_threshold = (threshold - 0.4) * 2;                          \n"
"  gfloat tmp;                                                                 \n"
"                                                                              \n"
"  if (adjusted_red >= adjusted_green - adjusted_threshold &&                  \n"
"      adjusted_red >= adjusted_blue  - adjusted_threshold)                    \n"
"    {                                                                         \n"
"      tmp = (gdouble) (adjusted_green + adjusted_blue) / (2.0 * RED_FACTOR);  \n"
"      buf[0] = CLAMP (tmp, 0.0, 1.0);                                         \n"
"    }                                                                         \n"
"  /* Otherwise, leave the red channel alone */                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gfloat *dest = out_buf;                                                     \n"
"  glong   i;                                                                  \n"
"                                                                              \n"
"  /*                                                                          \n"
"   * Initialize the dest buffer to the input buffer                           \n"
"   * (we only want to change the red component)                               \n"
"   */                                                                         \n"
"  memcpy (out_buf, in_buf, sizeof (gfloat) * 4 * n_pixels);                   \n"
"                                                                              \n"
"  for (i = n_pixels; i > 0; i--)                                              \n"
"    {                                                                         \n"
"      red_eye_reduction (dest, o->threshold);                                 \n"
"      dest += 4;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/red-eye-removal.cl.h\"                                      \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem              in,                                           \n"
"            cl_mem              out,                                          \n"
"            size_t              global_worksize,                              \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                level)                                        \n"
"{                                                                             \n"
"  GeglProperties *o           = GEGL_PROPERTIES (operation);                  \n"
"  cl_float   threshold    = o->threshold;                                     \n"
"                                                                              \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"cl_red_eye_removal\", NULL};             \n"
"      cl_data = gegl_cl_compile_and_build(red_eye_removal_cl_source, kernel_name);\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  {                                                                           \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  gegl_cl_set_kernel_args (cl_data->kernel[0],                                \n"
"                           sizeof(cl_mem),   &in,                             \n"
"                           sizeof(cl_mem),   &out,                            \n"
"                           sizeof(cl_float), &threshold,                      \n"
"                           NULL);                                             \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 1,                \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  return  FALSE;                                                              \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare    = prepare;                                      \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"  point_filter_class->process = process;                                      \n"
"  point_filter_class->cl_process  = cl_process;                               \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:red-eye-removal\",                                \n"
"    \"title\",       _(\"Red Eye Removal\"),                                  \n"
"    \"categories\",  \"enhance\",                                             \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Remove the red eye effect caused by camera flashes\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
