static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006-2009 Øyvind Kolås <pippin@gimp.org>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_boolean (srgb, _(\"sRGB\"), FALSE)                                   \n"
"    description (_(\"Use sRGB gamma instead of linear\"))                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_COMPOSER                                                \n"
"#define GEGL_OP_NAME     over                                                 \n"
"#define GEGL_OP_C_SOURCE over.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  if (o->srgb)                                                                \n"
"    format = babl_format (\"R'aG'aB'aA float\");                              \n"
"  else                                                                        \n"
"    format = babl_format (\"RaGaBaA float\");                                 \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"aux\", format);                     \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *aux_buf,                                        \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gfloat * GEGL_ALIGNED in = in_buf;                                          \n"
"  gfloat * GEGL_ALIGNED aux = aux_buf;                                        \n"
"  gfloat * GEGL_ALIGNED out = out_buf;                                        \n"
"                                                                              \n"
"  if (aux==NULL)                                                              \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      out[0] = aux[0] + in[0] * (1.0f - aux[3]);                              \n"
"      out[1] = aux[1] + in[1] * (1.0f - aux[3]);                              \n"
"      out[2] = aux[2] + in[2] * (1.0f - aux[3]);                              \n"
"      out[3] = aux[3] + in[3] - aux[3] * in[3];                               \n"
"                                                                              \n"
"      in  += 4;                                                               \n"
"      aux += 4;                                                               \n"
"      out += 4;                                                               \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/svg-src-over.cl.h\"                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               aux_tex,                                     \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_GET_CLASS (operation); \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  /* The kernel will have been compiled by our parent class */                \n"
"  if (!operation_class->cl_data)                                              \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (operation_class->cl_data->kernel[0],      \n"
"                                    sizeof(cl_mem), &in_tex,                  \n"
"                                    sizeof(cl_mem), &aux_tex,                 \n"
"                                    sizeof(cl_mem), &out_tex,                 \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        operation_class->cl_data->kernel[0], 1,\n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"/* Fast paths */                                                              \n"
"static gboolean operation_process (GeglOperation        *operation,           \n"
"                                   GeglOperationContext *context,             \n"
"                                   const gchar          *output_prop,         \n"
"                                   const GeglRectangle  *result,              \n"
"                                   gint                  level)               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"  gpointer input, aux;                                                        \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  /* get the raw values this does not increase the reference count */         \n"
"  input = gegl_operation_context_get_object (context, \"input\");             \n"
"  aux = gegl_operation_context_get_object (context, \"aux\");                 \n"
"                                                                              \n"
"  /* pass the input/aux buffers directly through if they are alone*/          \n"
"  {                                                                           \n"
"    const GeglRectangle *in_extent = NULL;                                    \n"
"    const GeglRectangle *aux_extent = NULL;                                   \n"
"                                                                              \n"
"    if (input)                                                                \n"
"      in_extent = gegl_buffer_get_abyss (input);                              \n"
"                                                                              \n"
"    if ((!input ||                                                            \n"
"        (aux && !gegl_rectangle_intersect (NULL, in_extent, result))))        \n"
"      {                                                                       \n"
"         gegl_operation_context_take_object (context, \"output\",             \n"
"                                             g_object_ref (aux));             \n"
"         return TRUE;                                                         \n"
"      }                                                                       \n"
"    if (aux)                                                                  \n"
"      aux_extent = gegl_buffer_get_abyss (aux);                               \n"
"                                                                              \n"
"    if (!aux ||                                                               \n"
"        (input && !gegl_rectangle_intersect (NULL, aux_extent, result)))      \n"
"      {                                                                       \n"
"        gegl_operation_context_take_object (context, \"output\",              \n"
"                                            g_object_ref (input));            \n"
"        return TRUE;                                                          \n"
"      }                                                                       \n"
"  }                                                                           \n"
"  /* chain up, which will create the needed buffers for our actual            \n"
"   * process function                                                         \n"
"   */                                                                         \n"
"  return operation_class->process (operation, context, output_prop, result, level);\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass              *operation_class;                           \n"
"  GeglOperationPointComposerClass *point_composer_class;                      \n"
"                                                                              \n"
"  operation_class      = GEGL_OPERATION_CLASS (klass);                        \n"
"  point_composer_class = GEGL_OPERATION_POINT_COMPOSER_CLASS (klass);         \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->process = operation_process;                               \n"
"                                                                              \n"
"  point_composer_class->cl_process = cl_process;                              \n"
"  point_composer_class->process    = process;                                 \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"svg:src-over\",                                        \n"
"    \"title\",       _(\"Normal compositing\"),                               \n"
"    \"compat-name\", \"gegl:over\",                                           \n"
"    \"categories\" , \"compositors:porter-duff\",                             \n"
"    \"description\",                                                          \n"
"          _(\"Porter Duff operation over (also known as normal mode, and src-over) (d = cA + cB * (1 - aA))\"),\n"
"    \"cl-source\"  , svg_src_over_cl_source,                                  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
