static const char* op_c_source =
"/* This file is an image processing operation for GEGL.                       \n"
" *                                                                            \n"
" * This GEGL operation is a port of the main part of the Fractal              \n"
" * Explorer plug-in from GIMP. Fractal Explorer (Version 2) was               \n"
" * originally written by Daniel Cotting (cotting@multimania.com).             \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Kevin Cozens <kcozens@cvs.gnome.org>                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#define MAXNCOLORS 8192                                                       \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_fractal_explorer_type)                                       \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_MANDELBROT, \"mandelbrot\",          \n"
"              N_(\"Mandelbrot\"))                                             \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_JULIA,      \"julia\",               \n"
"              N_(\"Julia\"))                                                  \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_BARNSLEY_1, \"barnsley-1\",          \n"
"              N_(\"Barnsley 1\"))                                             \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_BARNSLEY_2, \"barnsley-2\",          \n"
"              N_(\"Barnsley 2\"))                                             \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_BARNSLEY_3, \"barnsley-3\",          \n"
"              N_(\"Barnsley 3\"))                                             \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_SPIDER,     \"spider\",              \n"
"              N_(\"Spider\"))                                                 \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_MAN_O_WAR,  \"man-o-war\",           \n"
"              N_(\"Man O War\"))                                              \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_LAMBDA,     \"lambda\",              \n"
"              N_(\"Lambda\"))                                                 \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_TYPE_SIERPINSKI, \"sierpinski\",          \n"
"              N_(\"Sierpinski\"))                                             \n"
"enum_end (GeglFractalExplorerType)                                            \n"
"                                                                              \n"
"property_enum (fractaltype, _(\"Fractal type\"),                              \n"
"    GeglFractalExplorerType, gegl_fractal_explorer_type,                      \n"
"    GEGL_FRACTAL_EXPLORER_TYPE_MANDELBROT)                                    \n"
"    description (_(\"Type of a fractal\"))                                    \n"
"                                                                              \n"
"property_int (iter, _(\"Iterations\"), 50)                                    \n"
"    value_range (1, 1000)                                                     \n"
"                                                                              \n"
"property_double (zoom, _(\"Zoom\"), 300.0)                                    \n"
"    description (_(\"Zoom in the fractal space\"))                            \n"
"    value_range (0.0000001, 10000000.0)                                       \n"
"    ui_range    (0.0000001, 10000.0)                                          \n"
"    ui_gamma    (1.5)                                                         \n"
"                                                                              \n"
"property_double (shiftx, _(\"Shift X\"), 0.0)                                 \n"
"    description (_(\"X shift in the fractal space\"))                         \n"
"    ui_range    (-1000.0, 1000.0)                                             \n"
"                                                                              \n"
"property_double (shifty, _(\"Shift Y\"), 0.0)                                 \n"
"    description (_(\"Y shift in the fractal space\"))                         \n"
"    ui_range    (-1000.0, 1000.0)                                             \n"
"                                                                              \n"
"property_double (cx, _(\"CX\"), -0.75)                                        \n"
"    description (_(\"CX (No effect in Mandelbrot and Sierpinski)\"))          \n"
"    value_range (-2.5, 2.5)                                                   \n"
"                                                                              \n"
"property_double (cy, _(\"CY\"), -0.2)                                         \n"
"    description (_(\"CY (No effect in Mandelbrot and Sierpinski)\"))          \n"
"    value_range (-2.5, 2.5)                                                   \n"
"                                                                              \n"
"property_double (redstretch, _(\"Red stretching factor\"), 1.0)               \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (greenstretch, _(\"Green stretching factor\"), 1.0)           \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (bluestretch, _(\"Blue stretching factor\"), 1.0)             \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"enum_start (gegl_fractal_explorer_mode)                                       \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_MODE_SIN , \"sine\",   N_(\"Sine\"))      \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_MODE_COS , \"cosine\", N_(\"Cosine\"))    \n"
"  enum_value (GEGL_FRACTAL_EXPLORER_MODE_NONE, \"none\",   N_(\"None\"))      \n"
"enum_end (GeglFractalExplorerMode)                                            \n"
"                                                                              \n"
"property_enum (redmode, _(\"Red application mode\"),                          \n"
"    GeglFractalExplorerMode, gegl_fractal_explorer_mode,                      \n"
"    GEGL_FRACTAL_EXPLORER_MODE_COS)                                           \n"
"                                                                              \n"
"property_enum (greenmode, _(\"Green application mode\"),                      \n"
"    GeglFractalExplorerMode, gegl_fractal_explorer_mode,                      \n"
"    GEGL_FRACTAL_EXPLORER_MODE_COS)                                           \n"
"                                                                              \n"
"property_enum (bluemode, _(\"Blue application mode\"),                        \n"
"    GeglFractalExplorerMode, gegl_fractal_explorer_mode,                      \n"
"    GEGL_FRACTAL_EXPLORER_MODE_SIN)                                           \n"
"                                                                              \n"
"property_boolean (redinvert  , _(\"Red inversion\")  , FALSE)                 \n"
"property_boolean (greeninvert, _(\"Green inversion\"), FALSE)                 \n"
"property_boolean (blueinvert , _(\"Blue inversion\") , FALSE)                 \n"
"                                                                              \n"
"property_int    (ncolors, _(\"Number of colors\"), 256)                       \n"
"    value_range (2, MAXNCOLORS)                                               \n"
"                                                                              \n"
"property_boolean (useloglog, _(\"Loglog smoothing\"), FALSE)                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     fractal_explorer                                     \n"
"#define GEGL_OP_C_SOURCE fractal-explorer.c                                   \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gfloat r, g, b;                                                             \n"
"} gfloatRGB;                                                                  \n"
"                                                                              \n"
"typedef gfloatRGB  clrmap[MAXNCOLORS];                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"make_color_map (GeglProperties *o, clrmap colormap)                           \n"
"{                                                                             \n"
"  gint     i;                                                                 \n"
"  gfloat   r;                                                                 \n"
"  gfloat   gr;                                                                \n"
"  gfloat   bl;                                                                \n"
"                                                                              \n"
"  for (i = 0; i < o->ncolors; i++)                                            \n"
"    {                                                                         \n"
"      double x = (i*2.0) / o->ncolors;                                        \n"
"      r = gr = bl = 0;                                                        \n"
"                                                                              \n"
"      switch (o->redmode)                                                     \n"
"        {                                                                     \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_SIN:                                  \n"
"          r = 0.5 * o->redstretch *(1.0 + sin((x - 1) * G_PI));               \n"
"          break;                                                              \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_COS:                                  \n"
"          r = 0.5 * o->redstretch *(1.0 + cos((x - 1) * G_PI));               \n"
"          break;                                                              \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_NONE:                                 \n"
"          r = 0.5 * o->redstretch * x;                                        \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      switch (o->greenmode)                                                   \n"
"        {                                                                     \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_SIN:                                  \n"
"          gr = 0.5 * o->greenstretch *(1.0 + sin((x - 1) * G_PI));            \n"
"          break;                                                              \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_COS:                                  \n"
"          gr = 0.5 * o->greenstretch *(1.0 + cos((x - 1) * G_PI));            \n"
"          break;                                                              \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_NONE:                                 \n"
"          gr = 0.5 * o->greenstretch * x;                                     \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      switch (o->bluemode)                                                    \n"
"        {                                                                     \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_SIN:                                  \n"
"          bl = 0.5 * o->bluestretch * (1.0 + sin ((x - 1) * G_PI));           \n"
"          break;                                                              \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_COS:                                  \n"
"          bl = 0.5 * o->bluestretch * (1.0 + cos ((x - 1) * G_PI));           \n"
"          break;                                                              \n"
"        case GEGL_FRACTAL_EXPLORER_MODE_NONE:                                 \n"
"          bl = 0.5 * o->bluestretch * x;                                      \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (o->redinvert)                                                       \n"
"        r = 1.0 - r;                                                          \n"
"                                                                              \n"
"      if (o->greeninvert)                                                     \n"
"        gr = 1.0 - gr;                                                        \n"
"                                                                              \n"
"      if (o->blueinvert)                                                      \n"
"        bl = 1.0 - bl;                                                        \n"
"                                                                              \n"
"      colormap[i].r = r;                                                      \n"
"      colormap[i].g = gr;                                                     \n"
"      colormap[i].b = bl;                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *out_pixel = out_buf;                                            \n"
"  gint        pixelx = roi->x; /* initial x                   */              \n"
"  gint        pixely = roi->y; /*           and y coordinates */              \n"
"  gdouble     x,y;             /* coordinate in fractal space */              \n"
"  gdouble     a,b;             /* main fractal variable in iteration loop */  \n"
"  gdouble     nexta;                                                          \n"
"  gdouble     tmpx, tmpy;                                                     \n"
"  gdouble     foldxinitx;                                                     \n"
"  gdouble     foldxinity;                                                     \n"
"  gdouble     foldyinitx;                                                     \n"
"  gdouble     foldyinity;                                                     \n"
"  gdouble     tempsqrx;                                                       \n"
"  gdouble     tempsqry;                                                       \n"
"  gdouble     olda,oldb;                                                      \n"
"  gdouble     adjust = 0.0;                                                   \n"
"  gint        counter;         /* iteration counter */                        \n"
"  gdouble     log2 = log (2.0);                                               \n"
"  gint        color;                                                          \n"
"                                                                              \n"
"  clrmap  colormap;                                                           \n"
"                                                                              \n"
"  make_color_map (o, colormap);                                               \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      x = (pixelx + o->shiftx) / o->zoom;                                     \n"
"      y = (pixely + o->shifty) / o->zoom;                                     \n"
"                                                                              \n"
"      switch (o->fractaltype)                                                 \n"
"        {                                                                     \n"
"        case GEGL_FRACTAL_EXPLORER_TYPE_MANDELBROT:                           \n"
"          a = b = 0;                                                          \n"
"          tmpx = tmpy = 0;                                                    \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          tmpx = a = x;                                                       \n"
"          tmpy = b = y;                                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      for (counter = 0; counter < o->iter; counter++)                         \n"
"        {                                                                     \n"
"          olda = a;                                                           \n"
"          oldb = b;                                                           \n"
"                                                                              \n"
"          switch (o->fractaltype)                                             \n"
"            {                                                                 \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_MANDELBROT:                       \n"
"              nexta = a * a - b * b + x;                                      \n"
"              b = 2.0 * a * b + y;                                            \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_JULIA:                            \n"
"              nexta = a * a - b * b + o->cx;                                  \n"
"              b = 2.0 * a * b + o->cy;                                        \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_BARNSLEY_1:                       \n"
"              foldxinitx = olda * o->cx;                                      \n"
"              foldyinity = oldb * o->cy;                                      \n"
"              foldxinity = olda * o->cy;                                      \n"
"              foldyinitx = oldb * o->cx;                                      \n"
"              /* orbit calculation */                                         \n"
"              if (olda >= 0)                                                  \n"
"                {                                                             \n"
"                  nexta = (foldxinitx - o->cx - foldyinity);                  \n"
"                  b  = (foldyinitx - o->cy + foldxinity);                     \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  nexta = (foldxinitx + o->cx - foldyinity);                  \n"
"                  b  = (foldyinitx + o->cy + foldxinity);                     \n"
"                }                                                             \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_BARNSLEY_2:                       \n"
"              foldxinitx = olda * o->cx;                                      \n"
"              foldyinity = oldb * o->cy;                                      \n"
"              foldxinity = olda * o->cy;                                      \n"
"              foldyinitx = oldb * o->cx;                                      \n"
"              /* orbit calculation */                                         \n"
"              if (foldxinity + foldyinitx >= 0)                               \n"
"                {                                                             \n"
"                  nexta = foldxinitx - o->cx - foldyinity;                    \n"
"                  b  = foldyinitx - o->cy + foldxinity;                       \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  nexta = foldxinitx + o->cx - foldyinity;                    \n"
"                  b  = foldyinitx + o->cy + foldxinity;                       \n"
"                }                                                             \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_BARNSLEY_3:                       \n"
"              foldxinitx  = olda * olda;                                      \n"
"              foldyinity  = oldb * oldb;                                      \n"
"              foldxinity  = olda * oldb;                                      \n"
"              /* orbit calculation */                                         \n"
"              if (olda > 0)                                                   \n"
"                {                                                             \n"
"                  nexta = foldxinitx - foldyinity - 1.0;                      \n"
"                  b  = foldxinity * 2;                                        \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  nexta = foldxinitx - foldyinity -1.0 + o->cx * olda;        \n"
"                  b  = foldxinity * 2;                                        \n"
"                  b += o->cy * olda;                                          \n"
"                }                                                             \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_SPIDER:                           \n"
"              /* { c=z=pixel: z=z*z+c; c=c/2+z, |z|<=4 } */                   \n"
"              nexta = a*a - b*b + tmpx + o->cx;                               \n"
"              b = 2 * olda * oldb + tmpy + o->cy;                             \n"
"              tmpx = tmpx/2 + nexta;                                          \n"
"              tmpy = tmpy/2 + b;                                              \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_MAN_O_WAR:                        \n"
"              nexta = a*a - b*b + tmpx + o->cx;                               \n"
"              b = 2.0 * a * b + tmpy + o->cy;                                 \n"
"              tmpx = olda;                                                    \n"
"              tmpy = oldb;                                                    \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_LAMBDA:                           \n"
"              tempsqrx = a * a;                                               \n"
"              tempsqry = b * b;                                               \n"
"              tempsqrx = olda - tempsqrx + tempsqry;                          \n"
"              tempsqry = -(oldb * olda);                                      \n"
"              tempsqry += tempsqry + oldb;                                    \n"
"              nexta = o->cx * tempsqrx - o->cy * tempsqry;                    \n"
"              b = o->cx * tempsqry + o->cy * tempsqrx;                        \n"
"              break;                                                          \n"
"                                                                              \n"
"            case GEGL_FRACTAL_EXPLORER_TYPE_SIERPINSKI:                       \n"
"              nexta = olda + olda;                                            \n"
"              b = oldb + oldb;                                                \n"
"              if (oldb > .5)                                                  \n"
"                b = b - 1;                                                    \n"
"              else if (olda > .5)                                             \n"
"                nexta = nexta - 1;                                            \n"
"              break;                                                          \n"
"                                                                              \n"
"            default:                                                          \n"
"              g_warning (_(\"Unsupported fractal type: %d\"), o->fractaltype);\n"
"              return FALSE;                                                   \n"
"            }                                                                 \n"
"                                                                              \n"
"          a = nexta;                                                          \n"
"                                                                              \n"
"          if (((a * a) + (b * b)) >= 4.0)                                     \n"
"            break;                                                            \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (o->useloglog)                                                       \n"
"        {                                                                     \n"
"          gdouble modulus_square = (a * a) + (b * b);                         \n"
"                                                                              \n"
"          if (modulus_square > (G_E * G_E))                                   \n"
"              adjust = log (log (modulus_square) / 2.0) / log2;               \n"
"          else                                                                \n"
"              adjust = 0.0;                                                   \n"
"        }                                                                     \n"
"                                                                              \n"
"      color = (gint) (((counter - adjust) * (o->ncolors - 1)) / o->iter);     \n"
"                                                                              \n"
"      out_pixel[0] = colormap[color].r;                                       \n"
"      out_pixel[1] = colormap[color].g;                                       \n"
"      out_pixel[2] = colormap[color].b;                                       \n"
"      out_pixel[3] = 1.0;                                                     \n"
"                                                                              \n"
"      out_pixel += 4;                                                         \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      pixelx++;                                                               \n"
"      if (pixelx>=roi->x + roi->width)                                        \n"
"        {                                                                     \n"
"          pixelx=roi->x;                                                      \n"
"          pixely++;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:fractal-explorer\",                        \n"
"    \"title\",              _(\"Fractal Explorer\"),                          \n"
"    \"categories\",         \"render:fractal\",                               \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\",        _(\"Rendering of multiple different fractal systems, with configurable coloring options.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
