/*
 * Copyright (c) 1995 Danny Gasparovski.
 * 
 * Please read the file COPYRIGHT for the
 * terms and conditions of the copyright.
 */

#define WANT_SYS_IOCTL_H
#include <slirp.h>

u_int curtime, time_fasttimo, last_slowtimo, detach_time;
u_int detach_wait = 600000;	/* 10 minutes */

int x_port = -1;
int x_display = 0;
int x_screen = 0;

int
show_x(buff, inso)
	char *buff;
	struct socket *inso;
{
	if (x_port < 0) {
		lprint("X Redir: X not being redirected.\r\n");
	} else {
		lprint("X Redir: In sh/bash/zsh/etc. type: DISPLAY=%s:%d.%d; export DISPLAY\r\n",
		      inet_ntoa(our_addr), x_port, x_screen);
		lprint("X Redir: In csh/tcsh/etc. type:    setenv DISPLAY %s:%d.%d\r\n",
		      inet_ntoa(our_addr), x_port, x_screen);
		if (x_display)
		   lprint("X Redir: Redirecting to display %d\r\n", x_display);
	}
	
	return CFG_OK;
}


/*
 * XXX Allow more than one X redirection?
 */
void
redir_x(inaddr, start_port, display, screen)
	u_int32_t inaddr;
	int start_port;
	int display;
	int screen;
{
	int i;
	
	if (x_port >= 0) {
		lprint("X Redir: X already being redirected.\r\n");
		show_x(0, 0);
	} else {
		for (i = 6000 + start_port; i <= 6100; i++) {
			if (solisten(htons(i), inaddr, htons(6000 + display), 0)) {
				/* Success */
				x_port = i - 6000;
				x_display = display;
				x_screen = screen;
				show_x(0, 0);
				return;
			}
		}
		lprint("X Redir: Error: Couldn't redirect a port for X. Weird.\r\n");
	}
}

#ifndef HAVE_INET_ATON
int
inet_aton(cp, ia)
	const char *cp;
	struct in_addr *ia;
{
	u_int32_t addr = inet_addr(cp);
	if (addr == 0xffffffff)
		return 0;
	ia->s_addr = addr;
	return 1;
}
#endif

/*
 * Get our IP address and put it in our_addr
 */
void
getouraddr()
{
	char buff[256];
	struct hostent *he;
	
	if (gethostname(buff,256) < 0)
	   return;
	
	if ((he = gethostbyname(buff)) == NULL)
	   return;
	
	our_addr = *(struct in_addr *)he->h_addr;
}

#if SIZEOF_CHAR_P == 8

struct quehead_32 {
	u_int32_t qh_link;
	u_int32_t qh_rlink;
};

inline void
insque_32(a, b)
	void *a;
	void *b;
{
	register struct quehead_32 *element = (struct quehead_32 *) a;
	register struct quehead_32 *head = (struct quehead_32 *) b;
	element->qh_link = head->qh_link;
	head->qh_link = (u_int32_t)element;
	element->qh_rlink = (u_int32_t)head;
	((struct quehead_32 *)(element->qh_link))->qh_rlink
	= (u_int32_t)element;
}

inline void
remque_32(a)
	void *a;
{
	register struct quehead_32 *element = (struct quehead_32 *) a;
	((struct quehead_32 *)(element->qh_link))->qh_rlink = element->qh_rlink;
	((struct quehead_32 *)(element->qh_rlink))->qh_link = element->qh_link;
	element->qh_rlink = 0;
}

#endif /* SIZEOF_CHAR_P == 8 */

struct quehead {
	struct quehead *qh_link;
	struct quehead *qh_rlink;
};

inline void
insque(a, b)
	void *a, *b;
{
	register struct quehead *element = (struct quehead *) a;
	register struct quehead *head = (struct quehead *) b;
	element->qh_link = head->qh_link;
	head->qh_link = (struct quehead *)element;
	element->qh_rlink = (struct quehead *)head;
	((struct quehead *)(element->qh_link))->qh_rlink
	= (struct quehead *)element;
}

inline void
remque(a)
	void *a;
{
	register struct quehead *element = (struct quehead *) a;
	((struct quehead *)(element->qh_link))->qh_rlink = element->qh_rlink;
	((struct quehead *)(element->qh_rlink))->qh_link = element->qh_link;
	element->qh_rlink = 0;
}

/* #endif */


int
add_exec(ex_ptr, do_pty, exec, addr, port)
	struct ex_list **ex_ptr;
	int do_pty;
	char *exec;
	int addr;
	int port;
{
	struct ex_list *tmp_ptr;
	
	/* First, check if the port is "bound" */
	for (tmp_ptr = *ex_ptr; tmp_ptr; tmp_ptr = tmp_ptr->ex_next) {
		if (port == tmp_ptr->ex_fport && addr == tmp_ptr->ex_addr)
		   return -1;
	}
	
	tmp_ptr = *ex_ptr;
	*ex_ptr = (struct ex_list *)malloc(sizeof(struct ex_list));
	(*ex_ptr)->ex_fport = port;
	(*ex_ptr)->ex_addr = addr;
	(*ex_ptr)->ex_pty = do_pty;
	(*ex_ptr)->ex_exec = strdup(exec);
	(*ex_ptr)->ex_next = tmp_ptr;
	return 0;
}

#ifndef HAVE_STRERROR

/*
 * For systems with no strerror
 */

extern int sys_nerr;
extern char *sys_errlist[];

char *
strerror(error)
	int error;
{
	if (error < sys_nerr)
	   return sys_errlist[error];
	else
	   return "Unknown error.";
}

#endif


/*
 * XXX This is ugly
 * We create and bind a socket, then fork off to another
 * process, which connects to this socket, after which we
 * exec the wanted program.  If something (strange) happens,
 * the accept() call could block us forever.
 */
int
fork_exec(so, ex, do_pty)
	struct socket *so;
	char *ex;
	int do_pty;
{
	int s;
	struct sockaddr_in addr;
	int addrlen = sizeof(addr);
	int opt = 1;
	int x;

	DEBUG_CALL("fork_exec");
	DEBUG_ARG("so = %lx", (long)so);
	DEBUG_ARG("ex = %lx", (long)ex);
	DEBUG_ARG("do_pty = %lx", (long)do_pty);

	addr.sin_family = AF_INET;
	addr.sin_port = 0;
	addr.sin_addr.s_addr = INADDR_ANY;
	
	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0 ||
	    bind(s, (struct sockaddr *)&addr, addrlen) < 0 ||
	    listen(s, 1) < 0) {
		lprint("Error: inet socket: %s\n", strerror(errno));
		close(s);
		
		return 0;
	}
	
	x = fork();
	if (x < 0) {
		lprint("Error: fork failed: %s\n", strerror(errno));
		close(s);
		
		return 0;
	
	} else if (x == 0) {
		char *argv[256];
		char buff[256];
		int i = 0;
		/* don't want to clobber the original */
		char *bptr = strdup(ex); /* No need to free() this */
		char *curarg;
		int c;
		
		getsockname(s, (struct sockaddr *)&addr, &addrlen);
		close(s);
		/*
		 * Connect to the socket
		 * XXX If any of these fail, we're in trouble!
		 */
		s = socket(AF_INET, SOCK_STREAM, 0);
		addr.sin_addr = loopback_addr;
		connect(s, (struct sockaddr *)&addr, addrlen);
		
		dup2(s, 0);
		dup2(s, 1);
		dup2(s, 2);
		for (s = 3; s < 256; s++)
		   close(s);
		
		/* Set the DISPLAY */
		if (x_port >= 0) {
#ifdef HAVE_SETENV
			sprintf(buff, "%s:%d.%d", inet_ntoa(our_addr), x_port, x_screen);
			setenv("DISPLAY", buff, 1);
#else
			sprintf(buff, "DISPLAY=%s:%d.%d", inet_ntoa(our_addr), x_port, x_screen);
			putenv(buff);
#endif
		}
		
		if (do_pty) {
			/* Setup "slirp.telnetd -x" */
			argv[i++] = "slirp.telnetd";
			argv[i++] = "-x";
			argv[i++] = strdup(bptr);
		} else
		   do {
			/* Change the string into argv[] */
			curarg = bptr;
			while (*bptr != ' ' && *bptr != (char)0)
			   bptr++;
			c = *bptr;
			*bptr++ = (char)0;
			argv[i++] = strdup(curarg);
		} while (c);
		
		argv[i] = 0;
		execvp(*argv, argv);
		/* Ooops, failed, let's tell the user why */
		{
			char buff[256];
			
			sprintf(buff, "Error: execvp failed: %s\n", strerror(errno));
			write(2, buff, strlen(buff));
		}
		close(0); close(1); close(2); /* XXX */
		exit(1);
	} else {
		/*
		 * XXX this could block us...
		 * XXX Should set a timer here, and if accept() doesn't
		 * return after X seconds, declare it a failure
		 * The only reason this will block forever is if socket()
		 * of connect() fail in the child process
		 */
		so->s = accept(s, (struct sockaddr *)&addr, &addrlen);
		close(s);
		ioctl(so->s, FIONREAD, &opt);
		setsockopt(so->s,SOL_SOCKET,SO_REUSEADDR,(char *)&opt,sizeof(int));
		setsockopt(so->s,SOL_SOCKET,SO_OOBINLINE,(char *)&opt,sizeof(int));
		
		/* Append the telnet options now */
		if (so->so_m != 0 && do_pty) {
			sbappend(so, so->so_m);
			so->so_m = 0;
		}
		
		return 1;
	}
}

#ifndef HAVE_STRDUP
char *
strdup(str)
	const char *str;
{
	char *bptr;
	
	bptr = (char *)malloc(strlen(str)+1);
	strcpy(bptr, str);
	
	return bptr;
}
#endif

void
do_exit(x)
	int x;
{
	exit(0);
}

void
snooze()
{
	sigset_t s;
	
	/* Don't need our data anymore */
	brk(0);
	
	signal (SIGQUIT, do_exit);
	sigfillset(&s);
	sigdelset(&s, SIGQUIT);
	
	/* Wait for a SIGQUIT */
	sigsuspend(&s);
	
	/* Just in case ... */
	exit(255);
}

int (*lprint_print) _P((void *, const char *, va_list));
char *lprint_ptr, *lprint_ptr2, **lprint_arg;

void
#ifdef __STDC__
lprint(const char *format, ...)
#else
lprint(va_alist) va_dcl
#endif
{
	va_list args;
        
#ifdef __STDC__
        va_start(args, format);
#else
        char *format;
        va_start(args);
        format = va_arg(args, char *);
#endif
	/* If we're printing to an sbuf, make sure there's enough room */
	/* XXX +100? */
	if (lprint_sb) {
		if ((lprint_ptr - lprint_sb->sb_wptr) >=
		    (lprint_sb->sb_datalen - (strlen(format) + 100))) {
			int deltaw = lprint_sb->sb_wptr - lprint_sb->sb_data;
			int deltar = lprint_sb->sb_rptr - lprint_sb->sb_data;
			int deltap = lprint_ptr -         lprint_sb->sb_data;
			                        
			lprint_sb->sb_data = (char *)realloc(lprint_sb->sb_data,
							     lprint_sb->sb_datalen + TCP_SNDSPACE);
			
			/* Adjust all values */
			lprint_sb->sb_wptr = lprint_sb->sb_data + deltaw;
			lprint_sb->sb_rptr = lprint_sb->sb_data + deltar;
			lprint_ptr =         lprint_sb->sb_data + deltap;
			
			lprint_sb->sb_datalen += TCP_SNDSPACE;
		}
	}
	
	if (lprint_print)
	   lprint_ptr += (*lprint_print)(*lprint_arg, format, args);
	
	/* Check if they want output to be logged to file as well */
	if (lfd) {
		/* 
		 * Remove \r's
		 * otherwise you'll get ^M all over the file
		 */
		int len = strlen(format);
		char *bptr1, *bptr2;
		
		bptr1 = bptr2 = strdup(format);
		
		while (len--) {
			if (*bptr1 == '\r')
			   memcpy(bptr1, bptr1+1, len+1);
			else
			   bptr1++;
		}
		vfprintf(lfd, bptr2, args);
		free(bptr2);
	}
	va_end(args);
}

void
add_emu(buff)
	char *buff;
{
	u_int lport, fport;
	u_int8_t tos = 0, emu = 0;
	char buff1[256], buff2[256], buff4[128];
	char *buff3 = buff4;
	struct emu_t *emup;
	
	if (sscanf(buff, "%256s %256s", buff2, buff1) != 2) {
		lprint("Error: Bad arguments\r\n");
		return;
	}
	
	if (sscanf(buff1, "%d:%d", &lport, &fport) != 2) {
		lport = 0;
		if (sscanf(buff1, "%d", &fport) != 1) {
			lprint("Error: Bad first argument\r\n");
			return;
		}
	}
	
	if (sscanf(buff2, "%128s:%128s", buff1, buff3) != 2) {
		buff3 = 0;
		if (sscanf(buff2, "%256s", buff1) != 1) {
			lprint("Error: Bad second argument\r\n");
			return;
		}
	}
	
	if (buff3) {
		if (strcmp(buff3, "lowdelay") == 0)
		   tos = IPTOS_LOWDELAY;
		else if (strcmp(buff3, "throughput") == 0)
		   tos = IPTOS_THROUGHPUT;
		else {
			lprint("Error: Expecting \"lowdelay\"/\"throughput\"\r\n");
			return;
		}
	}
	
	if (strcmp(buff1, "ftp") == 0)
	   emu = EMU_FTP;
	else if (strcmp(buff1, "irc") == 0)
	   emu = EMU_IRC;
	else if (strcmp(buff1, "none") == 0)
	   emu = EMU_NONE; /* ie: no emulation */
	else {
		lprint("Error: Unknown service\r\n");
		return;
	}
	
	/* First, check that it isn't already emulated */
	for (emup = tcpemu; emup; emup = emup->next) {
		if (emup->lport == lport && emup->fport == fport) {
			lprint("Error: port already emulated\r\n");
			return;
		}
	}
	
	/* And finally, link it */
	emup = (struct emu_t *)malloc(sizeof (struct emu_t));
	emup->lport = (u_int16_t)lport;
	emup->fport = (u_int16_t)fport;
	emup->tos = tos;
	emup->emu = emu;
	emup->next = tcpemu;
	tcpemu = emup;
	
	lprint("Adding emulation for %s to port %d/%d\r\n", buff1, emup->lport, emup->fport);
}

#ifdef BAD_SPRINTF

#undef vsprintf
#undef sprintf

/*
 * Some BSD-derived systems have a sprintf which returns char *
 */

int
vsprintf_len(string, format, args)
	char *string;
	const char *format;
	va_list args;
{
	vsprintf(string, format, args);
	return strlen(string);
}

int
#ifdef __STDC__
sprintf_len(char *string, const char *format, ...)
#else
sprintf_len(va_alist) va_dcl
#endif
{
	va_list args;
#ifdef __STDC__
	va_start(args, format);
#else
	char *string;
	char *format;
	va_start(args);
	string = va_arg(args, char *);
	format = va_arg(args, char *);
#endif
	vsprintf(string, format, args);
	return strlen(string);
}

#endif
