/***************************************
  $Revision: 1.10 $

  Authentication utilities 

  Status: NOT REVIEWED, TESTED

  Author(s):      Engin Gunduz 

  ******************/ /******************
  Modification History:
        engin (05/04/2000) Created.
  ******************/ /******************
  Copyright (c) 2000,2001,2002                    RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/

#ifndef AU_UTIL_H
#define AU_UTIL_H 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <regex.h>
#include <glib.h>
//#include "er_UP_errors.h"
//#include "erroutines.h"

#define AU_MAIL_FROM 1
#define AU_CRYPT_PW 2
#define AU_PGP 3
#define AU_NONE 4
#define AU_MD5_PW 5

#ifdef __cplusplus
extern "C" {
#endif


typedef struct _credentials_struct{
   GSList * password_list;
   char * from;       /* this is the whole "From:" field of the incoming message */
   char * from_email; /* this is only the e-mail address */
   /*char pgp_struct[10];*/
   GSList * pgp_key_list;
} credentials_struct;


typedef struct _auth_struct{
  int type;
  char * auth;
  char * mntner_name;
  int index;
  char * pgp_struct;
} auth_struct;

char * AU_crypt(const char *key, const char *setting);
int AU_authorise(GSList * auth_vector, credentials_struct credentials);

#ifdef __cplusplus
 }
#endif

#endif
