# Copyright (c) 2000                    RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


## "Generic" configuration file for RIP.
## There are quite a few variables to configure;
## however, you can leave part of the variables
## if you don't use a part of the software (e.g. dbupdate).
## Please don't forget to also modify your $SOURCEFILE.


######################
###
### GENERIC VARIABLES
###
######################

#
# The directory where all sorts of lockfiles are kept

LOCKDIR /home/dbase/var/lock


#
# The directory where all sorts of temporary files
# are kept.
# 
# make sure that this directory is owned by the 'updating process'
# user and cannot be written by other users

TMPDIR /home/dbase/var/tmp

#
# Where is the RIPADMIN database
# Syntax:
# RIPADMIN MySQL_Host,MySQL_Port,MySQL_User,MySQL_Password,MySQL_RIPADMIN_DB

RIPADMIN sqlhost,3306,dbuser,dbpsw,RIPADMIN

#
# Location of the file containing the SOURCE variables

SOURCEFILE /home/dbase/conf/sources.config.sample.q


######################
###
### LOGFILE DEFINITIONS
###
######################

## These variables indicate base filenames;
## the subdirectories have to be created manually beforehand.

##
## Query log
##

ER_DEF QRYLOG /home/dbase/log/qry/qrylog

##
## Error logs
##

#
# All dbupdate errors (only needed if you use dbupdate)

ER_DEF DBUPERR /home/dbase/log/dbuperr/dbuperrlog

#
# All whois_rip errors

ER_DEF ALLRIPERR /home/dbase/log/riperr/riperrlog

#
# Audit log: security-related messages

ER_DEF RIPAUDIT /home/dbase/log/audit/auditlog

#
# Mirroring log

ER_DEF RIPMIRLOG /home/dbase/log/mirror/mirrorlog

#
# Server log: all administration messages (startup, shutdown, etc)
# and errors

ER_DEF RIPSVRLOG /home/dbase/log/svr/svrlog

#
# SQL errors

ER_DEF SQLOG /home/dbase/log/sql/sqlog

#
# All update transactions are logged here

ER_UD_DEF RIPUPDLOG /home/dbase/log/ripupd/ripupdlog

#
# This is temporarily necessary. Leave it as it is.
# You will eventually be able to create new macros here.

ER_MACRO dummy dummy


##
## Update logs
## You need them only if you use dbupdate
##

#
# The file where all update requests are logged
# It must be rotated externally if needed

UPDLOG /home/dbase/log/upd/updlog

#
# The file where all acknowledgements are logged
# It must be rotated externally if needed

ACKLOG /home/dbase/log/ack/acklog

#
# The file where all notifications are logged
# It must be rotated externally if needed

NOTIFLOG /home/dbase/log/notif/notiflog

#
# The file where all forwardings are logged
# It must be rotated externally if needed

FORWLOG /home/dbase/log/forw/forwlog

#
# The file where all cross-notifications are logged
# It must be rotated externally if needed

CROSSLOG /home/dbase/log/cross/crosslog


######################
###
### WHOISD VARIABLES
###
######################

#
# KEEPOPEN [not implemented yet]
# Keep connection open for at most KEEPOPEN seconds for 
# network updates & whoisd '-k' keep connection open option

KEEPOPEN 180

#
# Port for the whois server

SVWHOIS_PORT 43001

#
# Port for the config interface

SVCONFIG_PORT 43002

#
# Port for the mirroring server

SVMIRROR_PORT 43003


###########
##
## Files
##

#
# Location of the help file printed in response
# to "whois help" queries

PW_HELP_FILE /home/dbase/doc/WHOIS-HELP


###########
##
## Access control
##

##
## In short, access control works in the following way:
## the more you query, the more your "ACL points" grow, 
## until at a certain point you are blocked. 
## First temporarily, then permanently.
## For temporary blocks, your points decay in time.
## These variables configure the decay time.

## (You probably don't want to change these variables).

#
# Interval of the decay (in seconds)

AC_DECAY_INTERVAL 600

#
# Halflife of the decay (in seconds)

AC_DECAY_HALFLIFE 43200

#
# Auto save of access tree
# If 1 tree is saved automatically (in AC_SAVE_INTERVAL periods)
# If 0 is not saved automatticaly (can be saved manually through the
#      admin interface)

AC_AUTO_SAVE 1

#
# Startup loading of access tree data stored on persistence
# If 1 access control data is loaded at the beginning from the database
# If 0 it is ignored
# Note that ACL data is always loaded

AC_LOAD 1

#
# Interval of making persistence (in seconds)

AC_SAVE_INTERVAL 1200


###########
##
## Response texts
##

## The only things you need to change here are the
## pointers to your own URLs and specific site-related information.

#
# Banner. This text comes out before the query is answered.

PW_BANNER % This is the MyDB Whois server.

#
# Standard response header

PW_RESP_HEADER % Rights restricted by copyright.
PW_RESP_HEADER % See http://www.mydb.net/db/copyright.html

#
# Access control limit reached

PW_LIMIT_REACHED %ERROR:202: access control limit reached
PW_LIMIT_REACHED %
PW_LIMIT_REACHED % You have reached the limit of returned contact information objects.
PW_LIMIT_REACHED % This connection will be terminated now.
PW_LIMIT_REACHED % Continued attempts to return excessive amounts of contact
PW_LIMIT_REACHED % information will result in permanent denial of service.
PW_LIMIT_REACHED % Please do not try to use CONTACT information in
PW_LIMIT_REACHED % My Database for non-operational purposes.
PW_LIMIT_REACHED % Refer to http://www.mydb.net/db/copyright.html for more information.

#
# Access denied permanently

PW_ACL_PERMDENY %ERROR:201: access denied
PW_ACL_PERMDENY %
PW_ACL_PERMDENY % Sorry, access from your host has been permanently denied
PW_ACL_PERMDENY % because of a repeated abusive behaviour.
PW_ACL_PERMDENY % Please contact <my-dbm@mydb.net> for unblocking.

##
## You don't need to change the following response texts
##

#
# No key supplied in query

PW_ERR_NOKEY %ERROR:106: no search key specified
PW_ERR_NOKEY %
PW_ERR_NOKEY % No search key specified

#
# For data retrieved with the "-K" flag

PW_K_FILTER % Note: this output has been filtered.
PW_K_FILTER % Only primary keys will be visible.
PW_K_FILTER % Contact information will not be shown

#
# User is not authorised to pass IP addresses with "-V" flag

PW_ACL_ADDRPASS %ERROR:203: address passing not allowed
PW_ACL_ADDRPASS %
PW_ACL_ADDRPASS % Sorry, you are not allowed to pass addresses on the query line .
PW_ACL_ADDRPASS % Please contact us for such permission. For the moment, continuing
PW_ACL_ADDRPASS % this will cause permanent denial of access.

#
# No object found

PW_NOTFOUND %ERROR:101: no entries found
PW_NOTFOUND %
PW_NOTFOUND % No entries found in the selected source(s).

#
# The connection is administratively or abnormally closed

PW_CONNCLOSED %ERROR:301: connection has been closed 
PW_CONNCLOSED %
PW_CONNCLOSED % The connection has been closed. 

#
# Unknown attribute in query

QC_BADATTR %ERROR:104: unknown attribute
QC_BADATTR %
QC_BADATTR % Unknown attribute encountered.

#
# The attribute specified is not inverse searchable

QC_FMT_ATTRNOTINV %%ERROR:105: attribute is not searchable
QC_FMT_ATTRNOTINV %%
QC_FMT_ATTRNOTINV %% "\"%s\" is not an inverse searchable attribute.

#
# There is no such source

QC_FMT_BADSOURCE %%ERROR:102: unknown source
QC_FMT_BADSOURCE %%
QC_FMT_BADSOURCE %% Unknown source %s requested.

#
# There is no such object type

QC_BADOBJTYPE %ERROR:103: unknown object type
QC_BADOBJTYPE %
QC_BADOBJTYPE % Unknown object type encountered.

##
## Referral texts
## (You probably don't want to change them)
##

#
# Referral timeout (in seconds)

REFERRALTIMEOUT 15

#
# Referral timeout error

QI_REF_TMOUT %ERROR:302: referral timeout 
QI_REF_TMOUT %
QI_REF_TMOUT % Referral timeout

# 
# Maximum referral lines allowed

REFERRALMAXLINES 250

#
# Maximum referral lines exceeded message

QI_REF_OVERMAXLIN %ERROR:204: maximum referral lines exceeded
QI_REF_OVERMAXLIN %
QI_REF_OVERMAXLIN % Referral reply line limit exceeded

#
# No referral host

QI_REF_BADHOST %ERROR:303: no referral host
QI_REF_BADHOST %
QI_REF_BADHOST % Referral host not found

#
# Host not responding

QI_REF_HOSTNOTTRESP %ERROR:304: referral host not responding 
QI_REF_HOSTNOTTRESP %
QI_REF_HOSTNOTTRESP % Referral host not responding

#
# Referral header

QI_FMT_REFHEADER %% The object shown below is NOT in the %s database.
QI_FMT_REFHEADER %% It has been obtained by querying a remote server:
QI_FMT_REFHEADER %% (%s) at port %d.
QI_FMT_REFHEADER %% To see the object stored in the %s database
QI_FMT_REFHEADER %% use the -R flag in your query
QI_FMT_REFHEADER %%
QI_FMT_REFHEADER %%REFERRAL START 

#
# Referral trailer 

QI_REFTRAILER %%REFERRAL END




######################
###
### DBUPDATE VARIABLES
###
######################

##
## You don't need to change *anything* below this point
## if you are not using dbupdate!
##


###########
##
## Sources
##

#
# The update source. The format is:
#
# (NOTE....this line is split on spaces and commas
#          so make sure the format is matched exactly.)
#
# UPDSOURCE SRCname DB-details  whois_rip-host,QRY-port,UPD-port
#
# where
#
# DB-details = MySQL_Host,MySQL_Port,MySQL_User,MySQL_Password,MySQL_DB

UPDSOURCE SAMPLE sqlhost,3306,dbuser,dbpsw,SAMPLEDB whois.mydb.net,43001,43004


###########
##
## Settings
## 

#
# Run database sw in test mode?  
# If set, the mntner and as-block creation requests are
# automatically processed and not sent to HUMAILBOX

TESTMODE  0

#
# Crypted password to override all security for updates
# 
# Example usage:
#
# object: My Object
# [...]
# source: MYSRC
# override: Reason_for_overriding_all_security Password
#
# [ This sample crypted password correspond to the word "password" ]

OVERRIDECRYPTEDPW   1F.5OTsRVjwLo

#
# ALLOCMNT
# List of maintainers which can create an inetnum object 
# with status ALLOCATED (one per line or space separated list
# or combination of the above)

ALLOCMNT MY-OWN-MNT

#
# WHOISUPDFROM [not implemented yet]
# ACL for hosts authorised to update the DB via networkupdate

WHOISUPDFROM 10\.20\.115\.8

#
# DUPLICATEPERSONCHECK [not implemented yet]
# Enable create/modify check for person with the same name/contact data 
# and different nic handles
# when not defined check is disabled. 
# when defined warning is generated if person with the same name found
# when defined as 'strict' and contact data are also the same then 
# creation/modification is refused, when nostrict only warning is generated

DUPLICATEPERSONCHECK nostrict


###########
##
## Files
## 

#
# UPDATELOCK [not implemented yet]
# Name of the lockfile for stopping updates
# It will be located in LOCKDIR
# Just the existence of this file will block all updates

UPDATELOCK STOPUPDATES

#
# The directory where the GPG process stores 
# the server's public keyring.

PGPPATH /home/dbase/.gnupg

#
# AUTODBMHELP [not implemented yet]
# help file to use for replies to messages to AUTOBOX
# with subject "HELP"

AUTODBMHELP /home/dbase/doc/AUTO-DBM-HELP


###########
##
## Commands
##

#
# GPGCMD
# Full pathname of your gpg executable

GPGCMD /usr/local/bin/gpg

#
# MAILCMD is the command into which a composed e-mail is given as standard
# input, to be send as mail. The message piped into this command has ALL
# the necessary mail header to process the mail:
# From:
# To:
# Subject:
# The mail command should take the recipients from the actual message.
# Using sendmail it will be executed as: /usr/lib/sendmail -t < "messagefile"
# (default: /usr/lib/sendmail -t)
#
# NOTE:
# -fmy-dbm makes my-dbm the trusted user that will appear on the
# envelope. Bounces will go to this address. If you do not specify
# this, sendmail will send bounces straight back to the automatic
# mailbox, where it will bounce again, and again, ....
# User has to be a trusted user, T<name> in sendmail.cf.

MAILCMD /usr/lib/sendmail -fmy-dbm -t


###########
##
## E-mail settings
##

#
# HUMAILBOX is a human mailbox, used for forwarding
# special objects. IT MUST NOT BE THE AUTOMATIC MAILBOX!!!!
# It can be used in mail messages as explained in MAILTXT below.

HUMAILBOX       my-dbm@mydb.net

#
# AUTOBOX is the mailbox used for automatic updates.
# The users must send mail to this address (and not
# HUMAILBOX) to get their updates processed.

AUTOBOX         auto-dbm@mydb.net

# DEFMAIL is the mailbox used when no mail notifications or acknowledgements
# both as to and from address in various places.

DEFMAIL my-dbm@ripe.net

#
# SUPPRESSMESS NOTIFY | ACK [not implemented yet]
# Where a duplicate notification/acknowledgement would be sent
# suppress either the notification (NOTIFY) or the acknowledgement (ACK)
# Neither is suppressed if SUPPRESSMESS is not set.
#
# SUPPRESSMESS NOTIFY
# SUPPRESSMESS ACK


###########
##
## E-mail texts
##

## In these entries you can use the following variables that will be 
## expanded to the real values.
##
## general purpose variables:
##
## $HUMAILBOX
## $AUTOBOX 
## $DATE 
## $TIME 
##
## E-mail variables:
##
## $FROM         = "From:"
## $CC           = "Cc:" 
## $SUBJECT      = "Subject:"                   
## $MDATE        = "Date:"
## $MSGID        = "Msg-Id:"
##
## networkupdate variables:
## 
## $FROMHOST     = from which host did the update come [not implemented yet]

##
## Acknowledgement messages
##

#
# The MAILTXT is the text that comes right after the headers in an email ack
# sent by dbupdate when processing an email update.

MAILTXT
MAILTXT Your e-mail:
MAILTXT
MAILTXT >   From:    $FROM
MAILTXT >   Cc:      $CC
MAILTXT >   Subject: $SUBJECT
MAILTXT >   Date:    $MDATE
MAILTXT >   Msg-Id:  $MSGID
MAILTXT
MAILTXT has been processed by the automatic update procedure at the MyDB NCC.
MAILTXT Diagnostic output follows:
MAILTXT
MAILTXT ------------------------------------------------------------------------

#
# The complete mailheader for the ack mail, you can include any
# mail header field, EXCEPT for the "To:" and "Cc:" field which is added 
# inside the ack sending program.

MHEADER From: My Database Management <$HUMAILBOX>
MHEADER Subject: Re: $SUBJECT
MHEADER Reply-To: $HUMAILBOX

#
# Text for failure acknowledgements. It is also sent
# for partial failures.

FAILURETXT From: My Database Management <$HUMAILBOX>
FAILURETXT Subject: FAILED: $SUBJECT
FAILURETXT Reply-To: $HUMAILBOX
FAILURETXT
FAILURETXT Part of your update FAILED.
FAILURETXT
FAILURETXT >   From:    $FROM
FAILURETXT >   Cc:      $CC
FAILURETXT >   Subject: $SUBJECT
FAILURETXT >   Date:    $MDATE
FAILURETXT >   Msg-Id:  $MSGID
FAILURETXT
FAILURETXT For help see <http://www.mydb.net/db/> or
FAILURETXT send a message to $AUTOBOX with 'help' in the subject line
FAILURETXT
FAILURETXT Objects without errors have been processed.
FAILURETXT

#
# Text for success acknowledgements

SUCCESSTXT From: My Database Management <$HUMAILBOX>
SUCCESSTXT Subject: SUCCEEDED: $SUBJECT
SUCCESSTXT Reply-To: $HUMAILBOX
SUCCESSTXT
SUCCESSTXT Your update was SUCCESSFUL.
SUCCESSTXT
SUCCESSTXT >   From:    $FROM
SUCCESSTXT >   Cc:      $CC
SUCCESSTXT >   Subject: $SUBJECT
SUCCESSTXT >   Date:    $MDATE
SUCCESSTXT >   Msg-Id:  $MSGID
SUCCESSTXT
SUCCESSTXT The following objects were processed.
SUCCESSTXT

#
# Text in reply to requests for "help"

HELPHEADER From: My Database Management <$HUMAILBOX>
HELPHEADER Subject: Re: $SUBJECT
HELPHEADER Reply-To: $HUMAILBOX
HELPHEADER
HELPHEADER Help file requested so body of message ignored.
HELPHEADER
HELPHEADER >   From:    $FROM
HELPHEADER >   Cc:      $CC
HELPHEADER >   Subject: $SUBJECT
HELPHEADER >   Date:    $MDATE
HELPHEADER >   Msg-Id:  $MSGID
HELPHEADER

#
# ACKERR is the message that will be displayed when errors or warnings were
# found in an update.

ACKERR Objects that just generated a WARNING have been updated as shown.
ACKERR
ACKERR Objects that generated an *ERROR* have NOT been updated as requested.
ACKERR Please re-submit corrected objects.

#
# ACKOK is message displayed when no error/warnings were found in an update

ACKOK No errors were found in your database update. Congratulations.

#
# Signature on the acknowledgement

ACKSIG MyDB Database Maintenance Department (Automatic Section)

##
## Notification messages
##

#
# The header used for notification messages

NHEADER From: MyDB Database Notifications <$HUMAILBOX>
NHEADER Subject: Notification of MyDB Database changes
NHEADER Reply-To: $HUMAILBOX
NHEADER Precedence: bulk

#
# Text used in notification messages.

NOTITXT Dear Colleague,
NOTITXT
NOTITXT This is to notify you that some object(s) in MyDB database
NOTITXT which you either maintain or are listed as to-be-notified have
NOTITXT been added, deleted or changed.

#
# This is used if the update was sent via e-mail

NOTIMAILTXT The update causing these changes had the following mail headers:
NOTIMAILTXT
NOTIMAILTXT - From:    $FROM
NOTIMAILTXT - Cc:      $CC
NOTIMAILTXT - Subject: $SUBJECT
NOTIMAILTXT - Date:    $MDATE
NOTIMAILTXT - Msg-Id:  $MSGID
NOTIMAILTXT
NOTIMAILTXT My Database Notification Department

#
# This is used if the update was sent through networkupdate

NOTINETWORKTXT The update causing these changes came from the following host:
NOTINETWORKTXT
NOTINETWORKTXT - From-Host: $FROMHOST
NOTINETWORKTXT - Date:      $DATE
NOTINETWORKTXT - Time:      $TIME
NOTINETWORKTXT
NOTINETWORKTXT My Database Notification Department


## Forwarding mails, sent out to maintainers to inform them that
## someone tried to change some object(s) they protect, but
## failed the authorisation

#
# The header of the forwarding

FWHEADER From: MyDB Database Maintainer Forwarding <$HUMAILBOX>
FWHEADER Subject: Requested MyDB database object changes
FWHEADER Reply-To: $HUMAILBOX

#
# The text of the forwarding

FWTXT
FWTXT  Dear Maintainer,
FWTXT
FWTXT  This is to notify you that some objects in which you are mentioned as
FWTXT  a maintainer were requested to be changed, but *failed* the proper
FWTXT  authorisation for any of the mentioned maintainers.
FWTXT  Please contact the sender of these changes about changes that need
FWTXT  to be made to the following objects.
FWTXT

#
# If the update causing the forwarding was sent via e-mail

FWMAILTXT  The mail message causing these failures had the following mail headers:
FWMAILTXT
FWMAILTXT  - From:    $FROM
FWMAILTXT  - Cc:      $CC
FWMAILTXT  - Subject: $SUBJECT
FWMAILTXT  - Date:    $MDATE
FWMAILTXT  - Msg-Id:  $MSGID
FWMAILTXT
FWMAILTXT  MyDB Database Maintainer Forwarding Department

#
# If the update causing the forwarding was sent through networkupdate

FWNETWORKTXT  The update causing these failures came from the following host:
FWNETWORKTXT
FWNETWORKTXT  - From-Host:       $FROMHOST
FWNETWORKTXT  - Date:            $DATE
FWNETWORKTXT  - Time:            $TIME
FWNETWORKTXT
FWNETWORKTXT  MyDB Database Maintainer Forwarding Department


## Maintainer, as-block and irt
## objects are special handles and cannot be created 
## automatically. They are forwarded to $HUMAILBOX or whatever you
## want to specify. The error sent back to the sender will contain
## $HUMAILBOX as the mailbox it was sent to.

#
# The headers of the forwarded message

MTFWHEADER To: <$HUMAILBOX>
MTFWHEADER From: My Database Maintainer Creation <$HUMAILBOX>
MTFWHEADER Subject: $HEADERTYPE creation request
MTFWHEADER Reply-To: $HUMAILBOX

#
# The text of the forwarded message

MTFWTXT
MTFWTXT A $TEXTTYPE object is requested by:
MTFWTXT
MTFWTXT - From:    $FROM
MTFWTXT - Cc:      $CC
MTFWTXT - Subject: $SUBJECT
MTFWTXT - Date:    $MDATE
MTFWTXT - Msg-Id:  $MSGID
MTFWTXT
MTFWTXT Please process the object below.
MTFWTXT


###########
##
## Cross-Notifications
##


#
# CROSSNOTIFYSOURCES [not implemented yet]
# for each source a list of sources to look in for overlapping
# route objects

CROSSNOTIFYSOURCES      MYSRC    MYSRC


## Various Cross Notification Texts
## used in the outgoing messages
## 
## there are two type of messages
##   1. to the originator prefixed with CN_
##   2. to the others prefixed with CNO_
##
## there are two sets of text for each type of message
##   1. when the updated object was an addition postfixed with _ADD
##   2. when the updated object was a  deletion postfixed with _DEL
##
## You normally don't have to change anything in these texts except
## renaming "MyDB" to your database name

## Messages to the ORIGINATOR of the update

# 
# Subject of the mail
# Lines are concatenated together. Make sure you indent following lines
# with white space (see RFC822)

CN_SUBJECT_ADD Subject: MyDB RR: Addition of overlapping routes
CN_SUBJECT_DEL Subject: MyDB RR: Removal  of overlapping routes

#
# Explanation
# Something like "Your update to the following object..."
# It is used at start of message and followed by the updated route object

CN_EXPLAIN_ADD The addition of your route object ... 
CN_EXPLAIN_DEL The deletion of your route object ... 

#
# Overlap text
# Something like "It overlaps with your routes.."
# used after the updated object and before the list of overlapping routes

CN_OVERLAP_ADD created new overlaps with the following routes ...
CN_OVERLAP_DEL removed the overlaps with the following routes ...

# 
# Subject of the mail
# Lines are concatenated together. Make sure you indent following lines
# with white space (see RFC822)

CNO_SUBJECT_ADD Subject: MyDB RR: Addition of overlapping routes
CNO_SUBJECT_DEL Subject: MyDB RR: Removal  of overlapping routes

#
# Explanation
# Something like "Your update to the following object..."
# used at start of message and followed by the updated route object

CNO_EXPLAIN_ADD The addition of the route object ... 
CNO_EXPLAIN_DEL The deletion of the route object ... 

#
# Overlap text
# Something like "It overlaps with your routes.."
# used after the updated object and before the list of overlapping routes

CNO_OVERLAP_ADD created new overlaps with your following routes ...
CNO_OVERLAP_DEL removed the overlaps with your following routes ...


###########
##
## Countries
##

##
## A list of valid ISO country codes for inetnum checks
## You probably will never have to modify this
##

COUNTRY AD
COUNTRY AE
COUNTRY AF
COUNTRY AG
COUNTRY AI
COUNTRY AL
COUNTRY AM
COUNTRY AN
COUNTRY AO
COUNTRY AQ
COUNTRY AR
COUNTRY AS
COUNTRY AT
COUNTRY AU
COUNTRY AW
COUNTRY AZ
COUNTRY BA
COUNTRY BB
COUNTRY BD
COUNTRY BE
COUNTRY BF
COUNTRY BG
COUNTRY BH
COUNTRY BI
COUNTRY BJ
COUNTRY BM
COUNTRY BN
COUNTRY BO
COUNTRY BR
COUNTRY BS
COUNTRY BT
COUNTRY BV
COUNTRY BW
COUNTRY BY
COUNTRY BZ
COUNTRY CA
COUNTRY CC
COUNTRY CD
COUNTRY CF
COUNTRY CG
COUNTRY CH
COUNTRY CI
COUNTRY CK
COUNTRY CL
COUNTRY CM
COUNTRY CN
COUNTRY CO
COUNTRY CR
COUNTRY CU
COUNTRY CV
COUNTRY CX
COUNTRY CY
COUNTRY CZ
COUNTRY DE
COUNTRY DJ
COUNTRY DK
COUNTRY DM
COUNTRY DO
COUNTRY DZ
COUNTRY EC
COUNTRY EE
COUNTRY EG
COUNTRY EH
COUNTRY ER
COUNTRY ES
COUNTRY ET
COUNTRY EU
COUNTRY FI
COUNTRY FJ
COUNTRY FK
COUNTRY FM
COUNTRY FO
COUNTRY FR
COUNTRY FX
COUNTRY GA
COUNTRY GB
COUNTRY GD
COUNTRY GE
COUNTRY GF
COUNTRY GH
COUNTRY GI
COUNTRY GL
COUNTRY GM
COUNTRY GN
COUNTRY GP
COUNTRY GQ
COUNTRY GR
COUNTRY GS
COUNTRY GT
COUNTRY GU
COUNTRY GW
COUNTRY GY
COUNTRY HK
COUNTRY HM
COUNTRY HN
COUNTRY HR
COUNTRY HT
COUNTRY HU
COUNTRY ID
COUNTRY IE
COUNTRY IL
COUNTRY IN
COUNTRY IO
COUNTRY IQ
COUNTRY IR
COUNTRY IS
COUNTRY IT
COUNTRY JM
COUNTRY JO
COUNTRY JP
COUNTRY KE
COUNTRY KG
COUNTRY KH
COUNTRY KI
COUNTRY KM
COUNTRY KN
COUNTRY KP
COUNTRY KR
COUNTRY KW
COUNTRY KY
COUNTRY KZ
COUNTRY LA
COUNTRY LB
COUNTRY LC
COUNTRY LI
COUNTRY LK
COUNTRY LR
COUNTRY LS
COUNTRY LT
COUNTRY LU
COUNTRY LV
COUNTRY LY
COUNTRY MA
COUNTRY MC
COUNTRY MD
COUNTRY MG
COUNTRY MH
COUNTRY MK
COUNTRY ML
COUNTRY MM
COUNTRY MN
COUNTRY MO
COUNTRY MP
COUNTRY MQ
COUNTRY MR
COUNTRY MS
COUNTRY MT
COUNTRY MU
COUNTRY MV
COUNTRY MW
COUNTRY MX
COUNTRY MY
COUNTRY MZ
COUNTRY NA
COUNTRY NC
COUNTRY NE
COUNTRY NF
COUNTRY NG
COUNTRY NI
COUNTRY NL
COUNTRY NO
COUNTRY NP
COUNTRY NR
COUNTRY NU
COUNTRY NZ
COUNTRY OM
COUNTRY PA
COUNTRY PE
COUNTRY PF
COUNTRY PG
COUNTRY PH
COUNTRY PK
COUNTRY PL
COUNTRY PM
COUNTRY PN
COUNTRY PR
COUNTRY PS
COUNTRY PT
COUNTRY PW
COUNTRY PY
COUNTRY QA
COUNTRY RE
COUNTRY RO
COUNTRY RU
COUNTRY RW
COUNTRY SA
COUNTRY SB
COUNTRY SC
COUNTRY SD
COUNTRY SE
COUNTRY SG
COUNTRY SH
COUNTRY SI
COUNTRY SJ
COUNTRY SK
COUNTRY SL
COUNTRY SM
COUNTRY SN
COUNTRY SO
COUNTRY SR
COUNTRY ST
COUNTRY SV
COUNTRY SY
COUNTRY SZ
COUNTRY TC
COUNTRY TD
COUNTRY TF
COUNTRY TG
COUNTRY TH
COUNTRY TJ
COUNTRY TK
COUNTRY TM
COUNTRY TN
COUNTRY TO
COUNTRY TP
COUNTRY TR
COUNTRY TT
COUNTRY TV
COUNTRY TW
COUNTRY TZ
COUNTRY UA
COUNTRY UG
COUNTRY UM
COUNTRY US
COUNTRY UY
COUNTRY UZ
COUNTRY VA
COUNTRY VC
COUNTRY VE
COUNTRY VG
COUNTRY VI
COUNTRY VN
COUNTRY VU
COUNTRY WF
COUNTRY WS
COUNTRY YE
COUNTRY YT
COUNTRY YU
COUNTRY ZA
COUNTRY ZM
COUNTRY ZW
