/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;

public final class XMLReaderFactory {
    private XMLReaderFactory() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        String string = System.getProperty("org.xml.sax.driver");
        if (string == null) {
            Parser parser;
            try {
                parser = ParserFactory.makeParser();
            }
            catch (Exception exception) {
                parser = null;
            }
            if (parser == null) {
                throw new SAXException("System property org.xml.sax.driver not specified");
            }
            return new ParserAdapter(parser);
        }
        return XMLReaderFactory.createXMLReader(string);
    }

    public static XMLReader createXMLReader(String string) throws SAXException {
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException("SAX2 driver class " + string + " not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("SAX2 driver class " + string + " found but cannot be loaded", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("SAX2 driver class " + string + " loaded but cannot be instantiated (no empty public constructor?)", instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("SAX2 driver class " + string + " does not implement XMLReader", classCastException);
        }
    }
}

