
#       rfc822.pl - parse RFC822 mail header
#
#	$RCSfile: rfc822.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

# Takes filehandle from input mail to read as argument
#
# Sets the following global variables:
#
# $FROM	- "From:" field in header
# $REPLYTO - equal to $FROM if "Reply-To:" is not present, else equal to 
#            the "Reply-To:" field
# $SUBJECT - subject in header
# $MDATE - date in header
# $MSGID - message ID in header
# $HELPREQUESTED - help file is requested
# $NEWMODE - only accept new objects
# $opt_A if send to auto-assign or ASSIGN in Subject line
# $opt_v if LONGACK in subject


sub parserfc822 {
    local($file)=@_;

    local(%header) = ();

    while (<$file>) {

        s/\s+$//;
        
        last if (!$_);
        
        #
	# check to see if this went to auto-assign, then set -A flag
	# Hardcoded and yuck.

	$opt_A = 1 if (/auto\-assign/i);

        if (/^From:\s+(.*)/i) {
	    
	   if (!$header{"ra"}) {
	      $curfield = "ra";
	      $header{$curfield}=$1;
	   }
	   
	   next;
	   
	}
	
	if (/^Cc:\s+(.*)/i) {
           $curfield = "cc";
           $header{$curfield} = $1;
           next;
        }

	if (/^Reply-To:\s+(.*)/i) {
	    
	    $curfield = "rp";
	    
	    if ($header{$curfield}) {
		$header{$curfield}.=", ".$1;
	    }
	    else {
		$header{$curfield}=$1;
	    }
	    
	    next;
	    
	}
	
	if (/^Subject:\s+(.*)/i) {
	   
	   $curfield="sj";
	   $header{$curfield} = $1;
	   
	   next;
	   
	}

	if (/^Message-Id:\s+(.*)/i) {
	   $curfield = "mi";
	   $header{$curfield} = $1;
	   next;
	}

        
          
	if (/^Date:\s+(.*)/i) {
	    $curfield = "dt";
	    $header{$curfield} = $1;
	    next;
	}

	if (/^\s+(\S.*)$/) {
	   
	   if ($curfield) {
	      $header{$curfield}.=" ".$1;
	   }
	    
	   next;
	
	}

	$curfield = "";
	
    }
    
    if ($header{"ra"}) {
		
       $FROM=$header{"ra"};
		
       $REPLYTO=$FROM;
       $REPLYTO=$header{"rp"} if ($header{"rp"}); 
		
       $CC=$header{"cc"};
		
       $SUBJECT=$header{"sj"};
       $opt_v=1 if ($SUBJECT=~ /LONGACK/i);
       $NEWMODE=1 if ($SUBJECT=~ /NEW/i);
       $opt_A=1 if ($SUBJECT=~ /ASSIGN/i);
       $HELPREQUESTED=1 if ($SUBJECT=~ /(HELP|HOWTO)/i);
		
       $MDATE=$header{"dt"};
		
       $MSGID=$header{"mi"};
		
       return $OK;
		
    }
    else {
	    
       return $NOK;
		
    }

}

1;
