/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/keysym.h>

#include "mode.h"
#include "view.h"
#include "viewer.h"


extern void MoveSheet();
extern void InitLineSelect();
extern void InitXYLineSelect();
extern void LineSelect();
extern void XYLineSelect();
extern void DoneLineSelect();
extern void InitPointSelect();
extern void PointSelect();
extern void DonePointSelect();
extern void InitGlobalPoint();
extern void GlobalPoint();
extern void DoneGlobalPoint();
extern void InitDrawAreaSel();
extern void DrawAreaSel();
extern void DoneDrawAreaSel();
extern void InitRasterSel();
extern void RasterSel();
extern void DoneRasterSel();
extern void InitDrawDoodle();
extern void DrawDoodle();
extern void DoneDrawDoodle();
extern void InitDrawLine();
extern void DrawLine();
extern void DoneDrawLine();
extern void DoneDrawArrow();
extern void InitDrawBox();
extern void DrawBox();
extern void DoneDrawBox();
extern void DoneDrawOval();
extern void InitDrawErase();
extern void DrawErase();
extern void DoneDrawErase();
extern void DoneEraseBlock();
extern void PutSelection();
extern void InitDrawText();
extern void KeyDoodle();
extern void UnsetMode();

extern void StartPolyview();
extern void MovePolyview();
extern void DonePolyview();


extern int SdrawWidth, SdrawHeight, SdrawAscent;



void
CBDrawAreaKeyPress(w, data, event)
	Widget w;
	caddr_t data;
	XEvent *event;
{
	XKeyPressedEvent *KEvent = (XKeyPressedEvent *)event;
	View *V = (View *)data;

	if (V->Mode == TEXTINSERT)
	{
		KeyDoodle(V, w, KEvent);
	}
}


void
CBDrawAreaPress(w, data, event)
	Widget w;
	caddr_t data;
	XEvent *event;
{
	XButtonPressedEvent *BuEvent = (XButtonPressedEvent *)event;
	View *V = (View *)data;
	int com_type;

/*EJB
	if (BuEvent->button == Button3)
	{
		com_type = UNSET;
	}
	else if (BuEvent->button == Button2)
	{
		com_type = PATTERN;
	}
	else if (BuEvent->button == Button1)
	{
		com_type = SET;
	}
	else
	{
		com_type = NOP;
	}
*/
	switch(V->Mode)
	{
		case NONE:
			break;
		case AREASEL:
			if (V->type == V_SHEET)
			{
				InitDrawAreaSel(V, w, BuEvent->x, BuEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_RASTER))
				{
					int x, y;

					x = (BuEvent->x + V->Scroll_x) /
						(SdrawWidth * S_DIGITS);
					y = (BuEvent->y + V->Scroll_y) /
						SdrawHeight;
					x = x * V->next->cData->xmag;
					y = y * V->next->cData->ymag;
					InitRasterSel(V->next,
						V->next->drawArea, x, y);
				}
			}
			else if (V->type == V_RASTER)
			{
				InitRasterSel(V, w, BuEvent->x, BuEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_SHEET))
				{
					int bx, by;
					int x, y;

					bx = BuEvent->x / V->cData->xmag;
					by = BuEvent->y / V->cData->ymag;
					x = (bx * SdrawWidth * S_DIGITS) -
						V->next->Scroll_x;
					y = (by * SdrawHeight) -
						V->next->Scroll_y;
					MoveSheet(V->next, w, x, y);
					x = (bx * SdrawWidth * S_DIGITS) -
						V->next->Scroll_x;
					y = (by * SdrawHeight) -
						V->next->Scroll_y;
					InitDrawAreaSel(V->next,
						V->next->drawArea, x, y);
				}
			}
			break;
		case LINESEL:
/*EJB
			if ((V->type == V_RASTER)&&
			    (V->next != NULL)&&
			    (V->next->type == V_SHEET))
			{
				int x, y;

				x = (BuEvent->x * SdrawWidth * S_DIGITS) -
					V->next->Scroll_x;
				y = (BuEvent->y * SdrawHeight) -
					V->next->Scroll_y;
				MoveSheet(V->next, w, x, y);
			}
*/
			if (V->type == V_RASTER)
			{
				InitLineSelect(V, w, BuEvent->x, BuEvent->y);
			}
			break;
		case XLINESEL:
			if (V->type == V_RASTER)
			{
				InitXYLineSelect(V, w, BuEvent->x, BuEvent->y,
					False);
			}
			break;
		case YLINESEL:
			if (V->type == V_RASTER)
			{
				InitXYLineSelect(V, w, BuEvent->x, BuEvent->y,
					True);
			}
			break;
		case POINTSEL:
			if (V->type == V_SHEET)
			{
				int x, y;

				x = (BuEvent->x + V->Scroll_x) /
					(SdrawWidth * S_DIGITS);
				y = (BuEvent->y + V->Scroll_y) /
					SdrawHeight;

				InitPointSelect(V, w, x, y);

				if ((V->next != NULL)&&
				    (V->next->type == V_RASTER))
				{
					x = x * V->next->cData->xmag;
					y = y * V->next->cData->ymag;
					InitPointSelect(V->next,
						V->next->drawArea, x, y);
				}
			}
			else if (V->type == V_RASTER)
			{
				InitPointSelect(V, w, BuEvent->x, BuEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_SHEET))
				{
					int bx, by;
					int x, y;

					bx = BuEvent->x / V->cData->xmag;
					by = BuEvent->y / V->cData->ymag;
					x = (bx * SdrawWidth * S_DIGITS) -
						V->next->Scroll_x;
					y = (by * SdrawHeight) -
						V->next->Scroll_y;
					MoveSheet(V->next, w, x, y);
					InitPointSelect(V->next,
						V->next->drawArea,
						bx, by);
				}
			}
			break;
		case GLOBALPOINT:
			if (V->type == V_RASTER)
			{
				InitGlobalPoint(V, w, BuEvent->x, BuEvent->y);
			}
			break;
		case TEXTINSERT:
			if ((BuEvent->button == Button2)&&
			    (BuEvent->state & ShiftMask))
			{
				PutSelection(V, w, BuEvent);
			}
			else
			{
				InitDrawText(V, w, BuEvent->x, BuEvent->y);
			}
			break;
		case TEXT:
			InitDrawText(V, w, BuEvent->x, BuEvent->y);
			break;
		case ERASE:
			InitDrawErase(V, w, BuEvent->x, BuEvent->y);
			break;
		case FREEHAND:
			InitDrawDoodle(V, w, BuEvent->x, BuEvent->y);
			break;
		case ARROW:
		case LINE:
			InitDrawLine(V, w, BuEvent->x, BuEvent->y);
			break;
/* EJB
		case LINES:
			StartLines(w, BuEvent->x, BuEvent->y, com_type);
			break;
*/
		case BOX:
		case OVAL:
		case ERASEBLOCK:
			InitDrawBox(V, w, BuEvent->x, BuEvent->y);
			break;
		case PASTE:
		case PASTENOBACK:
			if (V->cutbuffer != NULL)
			{
				StartPutArea(V, w, BuEvent->x, BuEvent->y);
			}
			break;
		case POLYVIEW:
			StartPolyview(V, w, BuEvent->x, BuEvent->y);
			break;
	}
}


void
CBDrawAreaMove(w, data, event)
	Widget w;
	caddr_t data;
	XEvent *event;
{
	XPointerMovedEvent *MoEvent = (XPointerMovedEvent *)event;
	View *V = (View *)data;
	int com_type;

	if ((MoEvent->state & (Button1Mask | Button2Mask | Button3Mask)) == 0)
	{
		return;
	}
/*EJB
	if (MoEvent->state & Button3Mask)
	{
		com_type = UNSET;
	}
	else if (MoEvent->state & Button2Mask)
	{
		com_type = PATTERN;
	}
	else if (MoEvent->state & Button1Mask)
	{
		com_type = SET;
	}
	else
	{
		com_type = NOP;
	}
*/
	switch(V->Mode)
	{
		case NONE:
			break;
		case AREASEL:
			if (V->type == V_SHEET)
			{
				DrawAreaSel(V, w, MoEvent->x, MoEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_RASTER))
				{
					int x, y;

					x = (MoEvent->x + V->Scroll_x) /
						(SdrawWidth * S_DIGITS);
					y = (MoEvent->y + V->Scroll_y) /
						SdrawHeight;
					x = x * V->next->cData->xmag;
					y = y * V->next->cData->ymag;
					RasterSel(V->next,
						V->next->drawArea, x, y);
				}
			}
			else if (V->type == V_RASTER)
			{
				RasterSel(V, w, MoEvent->x, MoEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_SHEET))
				{
					int bx, by;
					int x, y;

					bx = MoEvent->x / V->cData->xmag;
					by = MoEvent->y / V->cData->ymag;
					x = (bx * SdrawWidth * S_DIGITS) -
						V->next->Scroll_x;
					y = (by * SdrawHeight) -
						V->next->Scroll_y;
					DrawAreaSel(V->next,
						V->next->drawArea, x, y);
				}
			}
			break;
		case LINESEL:
			if (V->type == V_RASTER)
			{
				LineSelect(V, w, MoEvent->x, MoEvent->y);
			}
			break;
		case XLINESEL:
			if (V->type == V_RASTER)
			{
				XYLineSelect(V, w, MoEvent->x, MoEvent->y,
					False);
			}
			break;
		case YLINESEL:
			if (V->type == V_RASTER)
			{
				XYLineSelect(V, w, MoEvent->x, MoEvent->y,
					True);
			}
			break;
		case POINTSEL:
			if (V->type == V_SHEET)
			{
				int x, y;

				x = (MoEvent->x + V->Scroll_x) /
					(SdrawWidth * S_DIGITS);
				y = (MoEvent->y + V->Scroll_y) /
					SdrawHeight;

				PointSelect(V, w, x, y);
				if ((V->next != NULL)&&
				    (V->next->type == V_RASTER))
				{
					x = x * V->next->cData->xmag;
					y = y * V->next->cData->ymag;
					PointSelect(V->next,
						V->next->drawArea, x, y);
				}
			}
			else if (V->type == V_RASTER)
			{
				PointSelect(V, w, MoEvent->x, MoEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_SHEET))
				{
					int bx, by;
					int x, y;

					bx = MoEvent->x / V->cData->xmag;
					by = MoEvent->y / V->cData->ymag;
					x = (bx * SdrawWidth * S_DIGITS) -
						V->next->Scroll_x;
					y = (by * SdrawHeight) -
						V->next->Scroll_y;
					MoveSheet(V->next, w, x, y);
					PointSelect(V->next,
						V->next->drawArea,
						bx, by);
				}
			}
			break;
		case GLOBALPOINT:
			if (V->type == V_RASTER)
			{
				GlobalPoint(V, w, MoEvent->x, MoEvent->y);
			}
			break;
		case TEXT:
			break;
		case ERASE:
			DrawErase(V, w, MoEvent->x, MoEvent->y);
			break;
		case FREEHAND:
			DrawDoodle(V, w, MoEvent->x, MoEvent->y);
			break;
		case ARROW:
		case LINE:
		case LINES:
			DrawLine(V, w, MoEvent->x, MoEvent->y);
			break;
		case BOX:
		case OVAL:
		case ERASEBLOCK:
			DrawBox(V, w, MoEvent->x, MoEvent->y);
			break;
		case PASTE:
		case PASTENOBACK:
			if (V->cutbuffer != NULL)
			{
				MovePutArea(V, w, MoEvent->x, MoEvent->y);
			}
			break;
		case POLYVIEW:
			MovePolyview(V, w, MoEvent->x, MoEvent->y);
			break;
	}
}


void
CBDrawAreaRelease(w, data, event)
	Widget w;
	caddr_t data;
	XEvent *event;
{
	XButtonReleasedEvent *BuEvent = (XButtonReleasedEvent *)event;
	View *V = (View *)data;
	int com_type;

/*EJB
	if (BuEvent->button == Button3)
	{
		com_type = UNSET;
	}
	else if (BuEvent->button == Button2)
	{
		com_type = PATTERN;
	}
	else if (BuEvent->button == Button1)
	{
		com_type = SET;
	}
	else
	{
		com_type = NOP;
	}
*/
	switch(V->Mode)
	{
		case NONE:
			break;
		case AREASEL:
			if (V->type == V_SHEET)
			{
				DoneDrawAreaSel(V, w, BuEvent->x, BuEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_RASTER))
				{
					int x, y;

					x = (BuEvent->x + V->Scroll_x) /
						(SdrawWidth * S_DIGITS);
					y = (BuEvent->y + V->Scroll_y) /
						SdrawHeight;
					x = x * V->next->cData->xmag;
					y = y * V->next->cData->ymag;
					DoneRasterSel(V->next,
						V->next->drawArea, x, y);
				}
			}
			else if (V->type == V_RASTER)
			{
				DoneRasterSel(V, w, BuEvent->x, BuEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_SHEET))
				{
					int bx, by;
					int x, y;

					bx = BuEvent->x / V->cData->xmag;
					by = BuEvent->y / V->cData->ymag;
					x = (bx * SdrawWidth * S_DIGITS) -
						V->next->Scroll_x;
					y = (by * SdrawHeight) -
						V->next->Scroll_y;
					DoneDrawAreaSel(V->next,
						V->next->drawArea, x, y);
				}
			}
			break;
		case LINESEL:
		case XLINESEL:
		case YLINESEL:
			if (V->type == V_RASTER)
			{
				DoneLineSelect(V, w, BuEvent->x, BuEvent->y);
			}
			break;
		case POINTSEL:
			if (V->type == V_SHEET)
			{
				int x, y;

				x = (BuEvent->x + V->Scroll_x) /
					(SdrawWidth * S_DIGITS);
				y = (BuEvent->y + V->Scroll_y) /
					SdrawHeight;

				DonePointSelect(V, w, x, y);

				if ((V->next != NULL)&&
				    (V->next->type == V_RASTER))
				{
					x = x * V->next->cData->xmag;
					y = y * V->next->cData->ymag;
					DonePointSelect(V->next,
						V->next->drawArea, x, y);
				}
			}
			else if (V->type == V_RASTER)
			{
				DonePointSelect(V, w, BuEvent->x, BuEvent->y);
				if ((V->next != NULL)&&
				    (V->next->type == V_SHEET))
				{
					int bx, by;
					int x, y;

					bx = BuEvent->x / V->cData->xmag;
					by = BuEvent->y / V->cData->ymag;
					x = (bx * SdrawWidth * S_DIGITS) -
						V->next->Scroll_x;
					y = (by * SdrawHeight) -
						V->next->Scroll_y;
					MoveSheet(V->next, w, x, y);
					DonePointSelect(V->next,
						V->next->drawArea,
						bx, by);
				}
			}
			break;
		case GLOBALPOINT:
			if (V->type == V_RASTER)
			{
				DoneGlobalPoint(V, w, BuEvent->x, BuEvent->y);
			}
			break;
		case TEXT:
			break;
		case ERASE:
			DoneDrawErase(V, w, BuEvent->x, BuEvent->y);
			break;
		case FREEHAND:
			DoneDrawDoodle(V, w, BuEvent->x, BuEvent->y);
			break;
		case ARROW:
			DoneDrawArrow(V, w, BuEvent->x, BuEvent->y);
			break;
		case LINE:
		case LINES:
			DoneDrawLine(V, w, BuEvent->x, BuEvent->y);
			break;
		case BOX:
			DoneDrawBox(V, w, BuEvent->x, BuEvent->y);
			break;
		case OVAL:
			DoneDrawOval(V, w, BuEvent->x, BuEvent->y);
			break;
		case ERASEBLOCK:
			DoneEraseBlock(V, w, BuEvent->x, BuEvent->y);
			break;
		case PASTE:
			if (V->cutbuffer != NULL)
			{
				DonePutArea(V, w, BuEvent->x, BuEvent->y);
			}
			UnsetMode(V, PASTE);
			break;
		case PASTENOBACK:
			if (V->cutbuffer != NULL)
			{
				DonePutAreaTrans(V, w, BuEvent->x, BuEvent->y);
			}
			UnsetMode(V, PASTENOBACK);
			break;
		case POLYVIEW:
			DonePolyview(V, w, BuEvent->x, BuEvent->y);
			break;
	}
}

