;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : DELAY.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : Macro and function to produce an accurate clock
;**           : cycle delay.
;**           :
;****************************************************************
;
*************************************************************************
* DELAY
* Macro to generate a delay of a specific # of clock cycles
* WARNING: delays > 3 cycles use 1 stack, >9 cycles use W (return W=0)
* Delays use 1 instruction, except 3 and >9
*************************************************************************

DELAY:  .macro  *[1]                    ;waste a number of cycles
        .switch ([1])
        .case   1
          nop                           ;delay 1 cycle
        .else

        .case   2
          DEL2                          ;delay 2 cycles
        .else

        .case   3
          DEL2
          nop
        .else

        .case   4
          call DELAY4
        .else
        .case   5
          call DELAY5
        .else
        .case   6
          call DELAY6
        .else
        .case   7
          call DELAY7
        .else
        .case   8
          call DELAY8
        .else
        .case   9
          call DELAY9
        .else
        .case   (other)
            movlw   ([1]-8)/4
            .switch  (([1]-8)%4)
               .case 0
               CALL DELAYW
               .else
               .case 1
               CALL DELAYW1         ;add 1 cycle
               .else
               .case 2
               CALL DELAYW2         ;add 2 cycles
               .else
               .case 3
               CALL DELAYW2         ;add 2 cycles
            .endif
        .endif
        .endm

        .seg CODE
;*************************************************************************
;** DELAYn Code for DELAY macro for 16C71 / 84
;** DELAYW For really long delays. Delays W*3+8 cycles.
;** DELAYWn Entries to DELAYW with offsets for 1 cycle resolution (ie. t%4)
;*************************************************************************
DELAY9: nop
DELAY8: nop
DELAY7: nop
DELAY6: nop
DELAY5: nop
DELAY4: return

DELAYW3: nop            ;delay by W*3+10 (including movlw and call)
DELAYW2: nop            ;delay by W*3+10 (including movlw and call)
DELAYW1: nop            ;delay by W*3+9  (including movlw and call)
DELAYW:                 ;delay by W*3+8  (including movlw and call)

..loop:
        addlw  -1	;count down                      4  8
	bbc	CY,..loop ;wait intil carry             5/6 9/10		
        retlw   0       ;done                            7  11 (+1)

;*************************************************************************
