/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* gtkext.h: extensions to gtk/gdk/glib that might go into the real libs later
 * RCS_ID("$Id: gtkext.h,v 1.5 1997/08/18 03:37:09 timj Exp $")
*/


#ifndef		__gtkext_h__
#define		__gtkext_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	<gtk.h>



/* --- defines --- */



/* --- gtk prototypes --- */


/* the _gtk_widget_raise() function raises the given widget
 * if it is a GtkWindow.
*/
void	_gtk_widget_raise		(GtkWidget	*widget);

/* the _gtk_widget_set_sensitivity() function just calls
 * gtk_widget_set_sensitive() to set the sensitivity of
 * widget to TRUE.
*/
void	_gtk_widget_set_sensitivity	(GtkWidget	*widget);


/* the _gtk_widget_unset_sensitivity() function just calls
 * gtk_widget_set_sensitive() to set the sensitivity of
 * widget to FALSE.
*/
void	_gtk_widget_unset_sensitivity	(GtkWidget	*widget);


/* the _gtk_object_describe_heritage() function calls
 * gtk_type_describe_heritage() for the type of this object.
 * this is mainly usefull for debugging.
*/
void	_gtk_object_describe_heritage	(GtkObject	*object);
void	_gtk_object_describe_tree	(GtkObject	*object,
					 guint		show_size);
gchar	*_gtk_object_type		(GtkObject	*object);


/* the _gtk_adjustment_set_value() function changes the current
 * value of a GtkAdjustment and sends out signal "value_changed".
*/
void	_gtk_adjustment_set_value	(GtkAdjustment	*adjustment,
					 gfloat		value);



/* --- gdk prototypes --- */


/* the _gdk_window_clear_expose() function acts just like
 * gdk_window_clear(), but after the window is cleared an
 * expose event is generated.
*/
void	_gdk_window_clear_expose	(GdkWindow	*window);






#ifdef		__cplusplus
  }
#endif
#endif		/*__gtkext_h__*/
