/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
%{
#include	"rcs.h"
RCS_ID("$Id: gbclex.l,v 1.6 1997/08/18 03:35:23 timj Exp $")

#define		__gbclex_l__


#include	"defines.h"
#include	"gbcio.h"

/* some versions of stdio.h
 * skip this declaration if __STRICT_ANSI__
 * is defined (e.g. "gcc -ansi" does this)
*/
extern	int	fileno(FILE*);


/* since input is never interactive, we can define
 * YY_INPUT for fread() only
*/
#define	YY_INPUT(buf,result,max_size) \
	if (((result=fread(buf, 1, (unsigned)max_size, yyin))==0) && ferror(yyin)) \
		/*YY_FATAL_ERROR*/ g_error("fatal: input in flex scanner failed");

/* this isn't really needed
*/
#define ECHO	(void)fwrite(yytext, (unsigned)yyleng, 1, yyout)


extern	void	gbc_warn	(const gchar	*format,
				 ...)			/* from gbcio.c */
				 #ifdef         __GNUC__
				 	__attribute__
				 	((format (printf, 1, 2)))
				 #endif         /*__GNUC__*/
				 ;


%}



%option	noyywrap
%array

DIGIT	[0-9]
HEX_D	[0-9A-Fa-f]
WORD	[A-Za-z]+
IDENT	[A-Za-z][A-Za-z_0-9]*

%x	lvlComment
%x	lvlString


%%


		gchar		yybuffer[8192]="";
		gchar		*yybuffer_p=0;
	extern	guint		yyline;		/* from gbcio.c */
	extern	yytoken_U	yylval;		/* from gbcio.c */
	


	/* --- rules --- */


			/* eat up comments
			 * but count newlines
			*/
"/*"			{ BEGIN(lvlComment); }
<lvlComment>{
	[^*\n]*		/* eat anything that's not an '*' */
	"*"+[^*/\n]*	/* eat up '*'s not followed by '/'s */
	\n		{ yyline++; }
	"*"+"/"		{ BEGIN(INITIAL); }
}


			/* read string (like in c-source)
			*/
\"			{ yybuffer_p=yybuffer; BEGIN(lvlString); }
<lvlString>{
	\"		{
			  *yybuffer_p='\0';
			  yylval.String=g_strdup(yybuffer);
			  BEGIN(INITIAL); return TOKEN_STRING;
			}
	\n		{
			  gbc_warn("unterminated string constant");
			  yyline++;
			  unput('"');
			}
	\\[0-7]{1,3}	{
			  /* octal */ int result;
			  (void) sscanf(yytext+1, "%o", &result);
			  if (result>0xff)
			  	gbc_warn("octal value out of bounds");
			  *yybuffer_p++=result&0xff;
			}
	\\[0-9]+	{ }
	\\n		{ *yybuffer_p++='\n'; }
	\\t		{ *yybuffer_p++='\t'; }
	\\r		{ *yybuffer_p++='\r'; }
	\\b		{ *yybuffer_p++='\b'; }
	\\f		{ *yybuffer_p++='\f'; }
	\\(.|\n)	{ *yybuffer_p++=yytext[1]; }
	[^\\\n\"]+	{
			  char *yptr=yytext;
			  while (*yptr) *yybuffer_p++=*yptr++;
			}
}


			/* count newlines
			*/
\n			{ yyline++; }


			/* NULL value
			*/
NULL			{ return TOKEN_NULL; }

			
			/* structure key words
			*/
GB_WIDGET_{IDENT}	{ yylval.String=g_strdup(&yytext[10]);	return TOKEN_WIDGET;	}
GB_{IDENT}		{ yylval.String=g_strdup(&yytext[3]);	return TOKEN_STRUCT;	}


			/* eat up whitespace
			*/
[ \t\f\v\b\r]		{ /* nothing */ }


			/* number scanning
			*/
-?{DIGIT}+		{ yylval.Long=strtol(yytext, (char **)NULL, 10); return TOKEN_LONG;	}
0[xX]{HEX_D}+		{ yylval.Long=strtol(yytext, (char**)NULL, 16);  return TOKEN_LONG;	}
-?{DIGIT}+"."{DIGIT}*	{ yylval.Double=strtod(yytext, (char **)NULL); return TOKEN_DOUBLE;	}
-?{DIGIT}*"."{DIGIT}+	{ yylval.Double=strtod(yytext, (char **)NULL); return TOKEN_DOUBLE;	}


			/* structure fields
			*/
{IDENT}			{ yylval.String=g_strdup(yytext);	return TOKEN_FIELD;	}


			/* default: scan 1 character
			*/
.			{ return yytext[0]; }


%%
