;;; sun-eos-toolbar.el --- Implements the EOS toolbar interface

;; Copyright (C) 13 Jun 1995  Sun Microsystems, Inc.

;; Maintainer:	Eduardo Pelegri-Llopart <eduardo.pelegri-llopart@Eng.Sun.COM>
;; Author:      Eduardo Pelegri-Llopart <eduardo.pelegri-llopart@Eng.Sun.COM>
;; Version:	1.14
;; Header:	@(#) sun-eos-toolbar.el: v1.14 95/06/15 19:02:13

;; Keywords:	SPARCworks EOS Era on SPARCworks toolbar

;;; Commentary:

;; Please send feedback to eduardo.pelegri-llopart@eng.sun.com

;;; Code:

(defvar eos::toolbar-run-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	s FgColor c #000000000000\",
\"X	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                 .......    \",
\"                            \",
\"     .....                  \",
\"     .X+@.       .......    \",
\"     .X+@.                  \",
\"  ......@....               \",
\"   .XXX++++.     .......    \",
\"    .XX++@.                 \",
\"     .@+@.                  \",
\"      .@.        .......    \",
\"       .                    \",
\"                            \",
\"                 .......    \",
\"                            \",
\"                            \",
\"                 .......    \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Run icon pair.")

(defvar eos::toolbar-type-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 2 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\"X	c #000000000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"     XX XX                  \",
\"     XX XX                  \",
\"   XXXX XXXX  XX XX         \",
\"  XX XX XX XX XX XX  XXX  X \",
\"  XX XX XX XX  XXX   X X X  \",
\"  XX XX XX XX   X    XXXX   \",
\"  XX XX XX XX  XXX     XXXX \",
\"  XX XX XX XX XX XX   X X X \",
\"   XXX   XXX  XX XX  X  XXX \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Type-at icon pair.")


(defvar eos::toolbar-stop-at-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #4B4B4B4B4B4B\",
\"X	c #FFFFFFFFFFFF\",
\"o	c #AFAFAFAFAFAF\",
\"O	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"          ........          \",
\"         .XXXXXXXX.         \",
\"        .XoOOOOOOoX.        \",
\"       .XoOOOOOOOOoX.       \",
\"      .XoOOOOOOOOOOoX.      \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"    .XoOOOOOOOOXOOOOOoX.    \",
\"    .XOOOOOOOOOXXOOOOOX.    \",
\"    .XOOOOXXXXXXXXOOOOX.    \",
\"    .XOOOOXXXXXXXXXOOOX.    \",
\"    .XOOOOXXXXXXXXOOOOX.    \",
\"    .XOOOOOOOOOXXOOOOOX.    \",
\"    .XOOOOOOOOOXOOOOOOX.    \",
\"    .XoOOOOOOOOOOOOOOoX.    \",
\"     .XoOOOOOOOOOOOOOX.     \",
\"      .XoOOOOOOOOOOoX.      \",
\"       .XoOOOOOOOOoX.       \",
\"        .XoOOOOOOoX.        \",
\"         .XXXXXXXX.         \",
\"          ........          \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Stop At icon pair.")

(defvar eos::toolbar-clear-at-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #4B4B4B4B4B4B\",
\"X	c #FFFFFFFFFFFF\",
\"o	c #AFAFAFAFAFAF\",
\"O	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"          ........          \",
\"         .XXXXXXXX.         \",
\"        .XoOOOOOOoX.        \",
\"       .XoOOOOOOOOoX.       \",
\"      .XoOOOOOOOOOOoX.      \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"    .XoOOOXXOOOOXXOOOoX.    \",
\"    .XOOOOOXXOOXXOOOOOX.    \",
\"    .XOOOOOOXXXXOOOOOOX.    \",
\"    .XOOOOOOOXXOOOOOOOX.    \",
\"    .XOOOOOOXXXXOOOOOOX.    \",
\"    .XOOOOOXXOOXXOOOOOX.    \",
\"    .XOOOOXXOOOOXXOOOOX.    \",
\"    .XoOOOXOOOOOOXOOOoX.    \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"      .XoOOOOOOOOOOoX.      \",
\"       .XoOOOOOOOOoX.       \",
\"        .XoOOOOOOoX.        \",
\"         .XXXXXXXX.         \",
\"          ........          \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Clear At icon pair.")

(defvar eos::toolbar-stop-in-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #4B4B4B4B4B4B\",
\"X	c #FFFFFFFFFFFF\",
\"o	c #AFAFAFAFAFAF\",
\"O	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"          ........          \",
\"         .XXXXXXXX.         \",
\"        .XoOOOOOOoX.        \",
\"       .XoOOOOOOOOoX.       \",
\"      .XoOOOOOOOOOOoX.      \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"    .XoOOOOOOOOOXOXOOoX.    \",
\"    .XOOOXXXXOOXOOOXOOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XOOOXXXOOXOOOOOXOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XoOOXOOOOOXOOOXOoX.    \",
\"     .XoOOOOOOOOXOXOoX.     \",
\"      .XoOOOOOOOOOOoX.      \",
\"       .XoOOOOOOOOoX.       \",
\"        .XoOOOOOOoX.        \",
\"         .XXXXXXXX.         \",
\"          ........          \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Stop in icon pair.")

(defvar eos::toolbar-step-into-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"O	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      .....   .......       \",
\"     .OOOO.                 \",
\"    .O++++.                 \",
\"    .O+....   ........      \",
\"    .O+.                    \",
\"    .O+. .                  \",
\"    .O+. ..                 \",
\"    .O+. .O.                \",
\"    .O+...O@.    .......    \",
\"    .O++OOO+@.              \",
\"    .O+++++++@.             \",
\"     .++++++@.   .......    \",
\"      ....O@.               \",
\"         .O.                \",
\"         ..      .......    \",
\"         .                  \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Step Into icon pair.")

(defvar eos::toolbar-step-over-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"X	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      .....                 \",
\"     .XXXX.      .......    \",
\"    .X++++.                 \",
\"    .X+....                 \",
\"    .X+.         .......    \",
\"    .X+. .                  \",
\"    .X+. ..                 \",
\"    .X+. .X.     .......    \",
\"    .X+...X@.               \",
\"    .X++XXX+@.              \",
\"    .X+++++++@.  .......    \",
\"     .++++++@.              \",
\"      ....X@.               \",
\"         .X.     .......    \",
\"         ..                 \",
\"         .                  \",
\"                 .......    \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Step Over icon pair.")

(defvar eos::toolbar-evaluate-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 2 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"         ....               \",
\"         .. ..  ......      \",
\"         .. ..  ......      \",
\"         .. ..              \",
\"         .. ..  ......      \",
\"         .. ..  ......      \",
\"         ....               \",
\"         ..                 \",
\"         ..                 \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Evaluate icon pair.")

(defvar eos::toolbar-evaluate-star-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 2 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\"X	c #000000000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"     XX XX                  \",
\"      XXX                   \",
\"    XXXXXXX                 \",
\"      XXX   XXXX            \",
\"     XX XX  XX XX XXXXXX    \",
\"            XX XX XXXXXX    \",
\"            XX XX           \",
\"            XX XX XXXXXX    \",
\"            XX XX XXXXXX    \",
\"            XXXX            \",
\"            XX              \",
\"            XX              \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Evaluate Star icon pair.")

(defvar eos::toolbar-fix-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #7D7D7D7D7D7D\",
\"X	c #000000000000\",
\"o	c #FFFFFFFF0000\",
\"O	c #FFFF99990000\",
\"+	c #FFFFCCCC3333\",
\"@	c #CCCC9999FFFF\",
\"#	c #99996666CCCC\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"         .XX.               \",
\"         XoOXX.             \",
\"        .Xo+OOXXX.          \",
\"        Xo++++OOOXXX        \",
\"       .Xo+++++++OOOX.      \",
\"       Xo++++++OOOXX.       \",
\"      .Xo++++OOXXX.         \",
\"      Xo++OOOXX.            \",
\"     .XoOOOXXXXXXXXXXXX     \",
\"     XoOXXX@@@@@@@@@@@X     \",
\"     XXX##############X     \",
\"      X@##############X     \",
\"      XXXXXXXXXXXXXXXXX     \",
\"      X@@@@X     X@@@@X     \",
\"      X@###X     X@###X     \",
\"      X@###X     X@###X     \",
\"      X@###X     X@###X     \",
\"      X@###X     X@###X     \",
\"      XXXXXX     XXXXXX     \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Fix icon pair.")

(defvar eos::toolbar-run2-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	s FgColor c #000000000000\",
\"X	c #0000FFFF0000\",
\"o	c #000077770000\",
\"O	c #000044440000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                .           \",
\"                ..          \",
\"                .X.         \",
\"     ............XX.        \",
\"     .XXXXXXXXXXXXoX.       \",
\"     .XoooooooooooooX.      \",
\"     .Xooooooooooooooo.     \",
\"     .XoooooooooooooO.      \",
\"     .oOOOOOOOOOOOoO.       \",
\"     ............OO.        \",
\"                .O.         \",
\"                ..          \",
\"                .           \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Run icon pair.")

(defvar eos::toolbar-cont-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 6 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"O	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"o	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      .....   .......       \",
\"     .OOOO.                 \",
\"    .O++++.                 \",
\"    .O+....   ........      \",
\"    .O+.                    \",
\"    .O+. .                  \",
\"    .O+. ..                 \",
\"    .O+. .O.                \",
\"    .O+...O@.     ..        \",
\"    .O++OOO+@.   .oo.       \",
\"    .O+++++++@. .oooo.      \",
\"     .++++++@.  .oooo.      \",
\"      ....O@.    .oo.       \",
\"         .O.      ..        \",
\"         ..                 \",
\"         .                  \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
  "A Cont icon pair.")	  
		      

(defvar eos::toolbar-up-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	s FgColor c #000000000000\",
\"X	c #CCCC9999FFFF\",
\"o	c #99996666CCCC\",
\"O	c #FFFFFFFF0000\",
\"+	c #FFFFCCCC3333\",
\"@	c #0000FFFF0000\",
\"#	c #000077770000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                  .         \",
\"                 ...        \",
\"      ........  .....       \",
\"      .XXXXXX. .......      \",
\"      .Xooooo.   ...        \",
\"      .Xooooo.   ...        \",
\"      .Xooooo.   ...        \",
\"      .Xooooo.   ...        \",
\"      .O+++++.   ...        \",
\"      .O+++++.   ...        \",
\"      .O+++++.              \",
\"      .O+++++.              \",
\"      .O+++++.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      ........              \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Up icon pair.")

(defvar eos::toolbar-down-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	s FgColor c #000000000000\",
\"X	c #CCCC9999FFFF\",
\"o	c #99996666CCCC\",
\"O	c #FFFFFFFF0000\",
\"+	c #FFFFCCCC3333\",
\"@	c #0000FFFF0000\",
\"#	c #000077770000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      ........              \",
\"      .XXXXXX.              \",
\"      .Xooooo.              \",
\"      .Xooooo.              \",
\"      .Xooooo.              \",
\"      .Xooooo.              \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .@#####.    ...       \",
\"      .@#####.  .......     \",
\"      .@#####.   .....      \",
\"      .@#####.    ...       \",
\"      .@#####.     .        \",
\"      ........              \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Down icon pair.")

(defvar eos::toolbar-build-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"X	c #CCCC9999FFFF\",
\"o	c #99996666CCCC\",
\"O	c #FFFFFFFF0000\",
\"+	c #FFFFCCCC3333\",
\"@	c #FFFF99990000\",
\"#	c #FFFF66666666\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                ......      \",
\"                .XXXX.      \",
\"                .Xooo.      \",
\"                .Xooo.      \",
\"                .Xooo.      \",
\"                .Xooo.      \",
\"           .    .Xooo.      \",
\"          .O.   .Xooo.      \",
\"         .O+@.  .Xooo.      \",
\"        .O+++@. .Xooo.      \",
\"       .O+++++@..Xooo.      \",
\"      .O+++++++@.Xooo.      \",
\"     .O+++..............    \",
\"    .O@@@@.            .    \",
\"    ....... ###########.    \",
\"          . ###########.    \",
\"          . ###########.    \",
\"          ..............    \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Build icon pair.")

(defvar eos::toolbar-dismiss-icon
  (toolbar-make-button-list
   "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\"X	c #4B4B4B4B4B4B\",
\". 	c #FFFFFFFFFFFF\",
\"o	c #AFAFAFAFAFAF\",
\"O	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"       X            X       \",
\"       XX          XX       \",
\"        XX        XX        \",
\"         XX      XX         \",
\"          XX    XX          \",
\"           XX  XX           \",
\"            XXXX            \",
\"             XX             \",
\"            XXXX            \",
\"           XX  XX           \",
\"          XX    XX          \",
\"         XX      XX         \",
\"        XX        XX        \",
\"       XX          XX       \",
\"       X            X       \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
"A Dismiss icon pair.")

(defvar eos::toolbar-intro-icon
  (toolbar-make-button-list
   "/* XPM */
static char * info[] = {
\"28 28 2 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c #000077770000\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXoooooooXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXooooooXXXXXXXXXXXX\",
\"XXXXXXXXXoooooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXoooooooXXXXXXXXXXX\",
\"XXXXXXXXXoooooooooXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "An intro icon pair.")

(defvar eos::toolbar-introD-icon
  (toolbar-make-button-list
   "/* XPM */
static char * info[] = {
\"28 28 2 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c #000077770000\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXoooooooXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXooooooXXXXXXXXXXXX\",
\"XXXXXXXXXoooooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXoooXXXXXXoooooXXXXXXXXXXXX\",
\"XXoXXoXXXXXoooooXXXXXXXXXXXX\",
\"XXoXXoXXXXoooooooXXXXXXXXXXX\",
\"XXoXXoXXXoooooooooXXXXXXXXXX\",
\"XXoXXoXXXXXXXXXXXXXXXXXXXXXX\",
\"XXoXXoXXXXXXXXXXXXXXXXXXXXXX\",
\"XXoooXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "An intro icon pair.")

(defvar eos::toolbar-introDB-icon
  (toolbar-make-button-list
   "/* XPM */
static char * info[] = {
\"28 28 2 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c #000077770000\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXoooooooXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXooooooXXXXXXXXXXXX\",
\"XXXXXXXXXoooooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXoooXXXXXXoooooXXXXXXoooXXX\",
\"XXoXXoXXXXXoooooXXXXXXoXXoXX\",
\"XXoXXoXXXXoooooooXXXXXoXXoXX\",
\"XXoXXoXXXoooooooooXXXXoooXXX\",
\"XXoXXoXXXXXXXXXXXXXXXXoXXoXX\",
\"XXoXXoXXXXXXXXXXXXXXXXoXXoXX\",
\"XXoooXXXXXXXXXXXXXXXXXoooXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "An intro icon pair.")

(defvar eos::toolbar-introB-icon
  (toolbar-make-button-list
   "/* XPM */
static char * info[] = {
\"28 28 2 1\",
\"X	c Gray75 s backgroundToolBarColor\",
\"o	c #000077770000\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXoooooooXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXoXXXXXXXXXXXXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\",
\"XXXXXXXXXXooooooXXXXXXXXXXXX\",
\"XXXXXXXXXoooooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXXXXXXX\",
\"XXXXXXXXXXXoooooXXXXXXoooXXX\",
\"XXXXXXXXXXXoooooXXXXXXoXXoXX\",
\"XXXXXXXXXXoooooooXXXXXoXXoXX\",
\"XXXXXXXXXoooooooooXXXXoooXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXoXXoXX\",
\"XXXXXXXXXXXXXXXXXXXXXXoXXoXX\",
\"XXXXXXXXXXXXXXXXXXXXXXoooXXX\",
\"XXXXXXXXXXXXXXXXXXXXXXXXXXXX\"};")
  "An intro icon pair.")


(defvar eos::debugger-toolbar
      '(
	[eos::toolbar-introD-icon
	 eos::sw-intro
	 t
	 "Show Introduction to Eos"]
	[eos::toolbar-stop-at-icon
	 eos::stop-at
	 t
	 "stop at: Stop at selected position"]
	[eos::toolbar-stop-in-icon
	 eos::stop-in
	 t
	 "stop in: Stop in function whose name is selected"]
	[eos::toolbar-clear-at-icon
	 eos::clear-at
	 t
	 "clear at: Clear at selected position"]
	[eos::toolbar-evaluate-icon
	 eos::print
	 t
	 "print: Evaluate selected expression; shows in separate XEmacs frame"]
	[eos::toolbar-evaluate-star-icon
	 eos::print*
	 t
	 "print *: Evaluate selected expression as a pointer; shows in separate XEmacs frame"]
	[eos::toolbar-run-icon
	 eos::run
	 t
	 "run: Run current program"]
	[eos::toolbar-cont-icon
	 eos::cont
	 t
	 "cont: Continue current program"]
	[eos::toolbar-step-over-icon
	 eos::next
	 t
	 "next: Step over subprogram calls"]
	[eos::toolbar-step-into-icon
	 eos::step
	 t
	 "step: Step into subprogram calls)"]
	[eos::toolbar-up-icon
	 eos::up
	 t
	 "up: move in stack towards \"cooler\" (less recently visited) frames"]
	[eos::toolbar-down-icon
	 eos::down
	 t
	 "down: move in stack towards \"warmer\" (more recently visited) frames)"]
	[eos::toolbar-build-icon
	 eos::build
	 t
	 "make: Build target"]
	[eos::toolbar-fix-icon
	 eos::fix
	 t
	 "fix: Fix file"]
	[eos::toolbar-type-icon
	 eos::type
	 t
	 "Prompt for typing a Dbx command"]
	))

(defvar eos::debugger-sbrowser-toolbar
      '(
	[eos::toolbar-introDB-icon
	 eos::sw-intro
	 t
	 "Show Introduction to Eos"]
	[eos::toolbar-stop-at-icon
	 eos::stop-at
	 t
	 "stop at: Stop at selected position"]
	[eos::toolbar-stop-in-icon
	 eos::stop-in
	 t
	 "stop in: Stop in function whose name is selected"]
	[eos::toolbar-clear-at-icon
	 eos::clear-at
	 t
	 "clear at: Clear at selected position"]
	[eos::toolbar-evaluate-icon
	 eos::print
	 t
	 "print: Evaluate selected expression; shows in separate XEmacs frame"]
	[eos::toolbar-evaluate-star-icon
	 eos::print*
	 t
	 "print *: Evaluate selected expression as a pointer; shows in separate XEmacs frame"]
	[eos::toolbar-run-icon
	 eos::run
	 t
	 "run: Run current program"]
	[eos::toolbar-cont-icon
	 eos::cont
	 t
	 "cont: Continue current program"]
	[eos::toolbar-step-over-icon
	 eos::next
	 t
	 "next: Step over subprogram calls"]
	[eos::toolbar-step-into-icon
	 eos::step
	 t
	 "step: Step into subprogram calls)"]
	[eos::toolbar-up-icon
	 eos::up
	 t
	 "up: move in stack towards \"cooler\" (less recently visited) frames"]
	[eos::toolbar-down-icon
	 eos::down
	 t
	 "down: move in stack towards \"warmer\" (more recently visited) frames)"]
	[eos::toolbar-build-icon
	 eos::build
	 t
	 "make: Build target"]
	[eos::toolbar-fix-icon
	 eos::fix
	 t
	 "fix: Fix file"]
	[eos::toolbar-type-icon
	 eos::type
	 t
	 "Prompt for typing a Dbx command"]
	))

(defvar eos::sbrowser-toolbar
      '([eos::toolbar-introB-icon
	 eos::sw-intro
	 t
	 "Show Introduction to Eos"]
	))

(defvar eos::print-toolbar
      '(
	[eos::toolbar-intro-icon
	 eos::sw-intro
	 t
	 "Show Introduction to Eos"]
	[eos::toolbar-evaluate-icon
	 eos::print
	 t
	 "print: Evaluate selected expression; shows in separate XEmacs frame"]
	[eos::toolbar-evaluate-star-icon
	 eos::print*
	 t
	 "print *: Evaluate selected expression as a pointer; shows in separate XEmacs frame"]
	[eos::toolbar-cont-icon
	 eos::cont-and-dismiss
	 t
	 "cont & dismiss: Continue current program and dismiss this frame"]
	[eos::toolbar-step-over-icon
	 eos::next-and-dismiss
	 t
	 "next  & dismiss: Step over subprogram calls and dismiss this frame"]
	[eos::toolbar-step-into-icon
	 eos::step-and-dismiss
	 t
	 "step & dismiss: Step into subprogram calls and dismiss this frame)"]
	[eos::toolbar-dismiss-icon
	 eos::dismiss-print-frame
	 t
	 "dismiss (make invisible) this print frame"]
	))

(defun eos::toolbar-position ()
  (let ((pos (default-toolbar-position)))
    (cond ((eq pos 'top) top-toolbar)
	  ((eq pos 'bottom) bottom-toolbar)
	  ((eq pos 'left) left-toolbar)
	  ((eq pos 'right) right-toolbar)
	  (t top-toolbar))))

(provide 'eos-toolbar)

;;; sun-eos-toolbar.el ends here
