/*				v s p r i n t f
 *
 * This function provides the same functionality as sprintf except
 * that it uses varargs.h.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 * 05-Sep-1989  Minor adjustments for Gnu C (actually any ansi C) ++jrb
 * 03-Sep-1989	Changed to PUTC() since no chance of line buffering.
 */

#define __SRC__
#include <varargs.h>
#include "stdiolib.h"

/*LINTLIBRARY*/

int vsprintf(buf, fmt, args)

char       *buf;				/* output buffer */
CONST char *fmt;				/* format */
va_list    args;				/* argument list */

{
  int v;				/* return value */
  FILE f;				/* temporary file */

  f._flag   = _IOWRITE | _IOSTRING;
  f._base   = (unsigned char *) buf;
  f._ptr    = f._base;
  f._bufsiz = 0;

  INITWRITEBUFFER(&f);

  v = vfprintf(&f, fmt, args);
  (void) PUTC(0, &f);

  return v;
}
