/*				u n g e t c
 *
 * This function pushes a character back into an input stream. The
 * character will be returned by the next getc call on the stream.
 * One character of pushback is guaranteed provided something
 * is read from the stream.
 *
 * Attempts to pushback EOF will fail and the function will return
 * EOF, otherwise the character pushed back will be returned. EOF
 * will also be returned if the attempt to pushback fails.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int ungetc(ch, fp)

int ch;					/* character to push back */
FILE *fp;

{
  if (ch == EOF  || TESTFLAG(fp, _IOREAD) == 0 ||
      fp->_base == NULL || (fp->_ptr == fp->_base && ! TESTFLAG(fp, _IONBF)))
    return EOF;

  if (TESTFLAG(fp, _IONBF) != 0)
    fp->_ptr = fp->_end = fp->_base + fp->_bufsiz;

  return *--fp->_ptr = ch;
}
