/*				s e t b u f
 *
 * This function causes the specified buffer to be used for IO buffering
 * instead of an automatically allocated buffer. It is called immediately
 * after the stream has been opened, but before it is read from or
 * written to. It is legal to call setbuf after making the stream
 * unbuffered.
 *
 * If buf if NULL, IO will be unbuffered, otherwise it will be fully
 * buffered. The manifest constant BUFSIZ in <stdio.h> tells how
 * big an array is needed. Line buffering will be initiated if the
 * output stream is directed to a terminal.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

void setbuf(fp, buf)

FILE *fp;				/* stream */
char *buf;				/* buffer */

{
  if (buf != NULL)
    (void) setvbuf(fp, buf, _IOFBF, BUFSIZ);
  else
    (void) setvbuf(fp, (char *) NULL, _IONBF, 0);
}
