/*				p r i n t f
 *
 * Formatted output to stdout. The function returns the number of bytes
 * output on success and EOF on failure.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 *
 *  [atw] 22-Sep-89  Changed so we declare it as varargs.  This must be done
 *                   on the 960 to force the compiler to copy out register
 *                   arguments into the arg block.
 */
/*
 * [atw] No prototypes, please.
 */

#define __NO_PROTO__ 
#include <varargs.h>
#include "stdiolib.h"

/*LINTLIBRARY*/
/*VARARGS1*/
/*ARGSUSED*/

int printf( va_alist )
va_dcl
{
  va_list arg;				/* argument vector */
  int v;				/* return value */
  const char *fmt;

  va_start(arg);
  fmt = va_arg(arg, const char *);
  v = vfprintf(stdout, fmt, arg);
  va_end(arg);
  return v;
}
