/*
 * pow(x, y) : return x**y
 *
 * Andy Wilson, 12-Oct-89.
 */

#include <math.h>

const double 
pow (const double x, const double y)
{
  if (x > 0)
    return exp (y * log (x));
  else if (x == 0)
    {
      if (y > 0)
	return 0.0;
      else
	{
	  errno = EDOM;
	  return M_ERRVAL;
	}
    }
  else
    /*
     * x < 0, y must be integer-valued.
     */
    {
      double temp;

#if defined(__i960_KB__) || defined(__i960_MC__)
      __asm ("cvtzril %1,%0"
	     : "=dG" (temp)			/* integer-ize */
	     : "f" (y));
      __asm ("cvtilr %1,%0"
	     : "=f" (temp)
	     : "dG" (temp));			/* convert back to float */
#else
 unsigned long ulong;

      ulong = y; /* integer-ize */
      temp = ulong; /* refloat */
#endif

      if (y == temp)
        {
	  int i = (int) y;
	  
	  if ((i & 1) == 0)			/* even power, pos. */
	    return exp (y * log (fabs(x)));
	  else					/* odd power, neg. */
	    return - exp (y * log (fabs(x)));
        }
      else
        {
	  errno = EDOM;
	  return M_ERRVAL;
        }
    }
}
