#include "lib.h"
#include <string.h>

/*
 * memchr - search for a byte
 *
 * CHARBITS should be defined only if the compiler lacks "unsigned char".
 * It should be a mask, e.g. 0377 for an 8-bit machine.
 */

#ifdef NULL
#undef NULL
#endif

#define	NULL	0

#ifndef CHARBITS
#	define	UNSCHAR(c)	((unsigned char)(c))
#	define  uchar		unsigned char
#else
#	define	UNSCHAR(c)	((c)&CHARBITS)
#	define  uchar		char
#endif

VOIDSTAR
memchr(s, ucharwanted, size)
CONST VOIDSTAR s;
int ucharwanted;
SIZET size;
{
	register CONST uchar *scan;
	register SIZET n;
	register int uc;

	scan = s;
	uc = UNSCHAR(ucharwanted);
	for (n = size; n > 0; n--)
		if (UNSCHAR(*scan) == uc)
			return(scan);
		else
			scan++;

	return(NULL);
}
