/*				f c l o s e
 *
 * This function will flush any buffered data for the specified
 * stream, then close it. Buffers that have been allocated
 * to the stream by the stdio library will be freed. Buffers
 * that have been allocated explicitly by the user will not
 * be freed. It is the user's responsibility to free these
 * if so required. This function is called automagically from
 * exit().
 *
 * The function returns 0 on success and EOF if an error was
 * detected.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int fclose(fp)

FILE *fp;				/* stream */

{
  FILE **sp;				/* slot */
  int close();				/* close a channel */
  void free();				/* free allocated memory */

/* Free slot occupied by this stream */
  if ((sp = _slot(fp)) == NULL)
    return EOF;
  if (sp - _iop > 2)
    *sp = NULL;

/* Flush any pending buffers */
  (void) fflush(fp);

/* Close this channel */
  if (close(fp->_file))
    return EOF;

/* Free allocated buffer */
  if (TESTFLAG(fp, _IOMYBUF))
    free((void *) fp->_base);
  if (*sp == NULL)
    free((void *) fp);

  return 0;
}
