/*
 * <stdlib.h> for gcc960.
 */

#ifndef __STDLIBH__
#define __STDLIBH__


/*
 * bring in size_t.
 */
#include <stddef.h>


/*
 * div_t, ldiv_t : "quotient and remainder in any order"
 *
 */
typedef struct {
  int rem;
  int quot; } div_t;

typedef struct {
  long rem;
  long quot; } ldiv_t;

/*
 * Be sure ERANGE is defined.
 */
#include <errno.h>

/*
 * other macros required by ANSI.
 */
#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0
#define RAND_MAX     0x7ffffffe	/* 2**31-2 */

/*
 * Prototypes (if not -traditional, e.g. __STDC__ is defined).
 */
#ifdef __STDC__
#ifndef __INSTANTIATE_STDLIB__
#define INLINE __inline__
#define STATIC static
#else
#define INLINE
#define STATIC
#endif
void		abort(void);
STATIC INLINE const 
		abs(int i) {  return i<0 ? -i : i; }
int 		atexit(void (*)(void));
double		atof(const char *);
int		atoi(const char *);
long		atol(const char *);
void *		bsearch(const void *, const void *, size_t, size_t,
			int(*)(const void *, const void *));
void *		calloc(unsigned, unsigned);
STATIC INLINE const div_t
		div(int n, int d) {div_t val; val.quot = n / d; val.rem = n % d; return val; }
void		exit(int);
void		free(void *);
char *		getenv(const char *);
STATIC INLINE long int
                labs(long int x) {  return x<0 ? -x : x; }
STATIC INLINE ldiv_t
		ldiv(long n, long d) {ldiv_t val; val.quot = n / d; val.rem = n % d; return val; }
void *		malloc(unsigned);
void		qsort(void *, size_t, size_t,
		      int(*)(const void *, const void *));
int		rand(void);
void *		realloc(void *, unsigned);
void		srand(unsigned int);
double		strtod(const char *, char **);
long		strtol(const char *, char **, int);
unsigned long  	strtoul(const char *, char **, int);
int		system(const char *);
#undef STATIC
#undef INLINE
#endif /* __STDC__ */
#endif /* __STDLIBH__ */
