/* Interface to wait system calls for GDB, the GNU debugger.
   Copyright (C) 1989 Free Software Foundation, Inc.

   MODIFIED BY CHRIS BENENATI, FOR INTEL CORPORATION, 12/88

GDB is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GDB General Public License for full details.

Everyone is granted permission to copy, modify and redistribute GDB,
but only under the conditions described in the GDB General Public
License.  A copy of this license is supposed to have been given to you
along with GDB so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share GDB, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!
*/


/* Define how to access the structure that the wait system call stores.
 * On many systems, there is a structure defined for this.
 * But on vanilla-ish USG systems there is not.
 */

#ifdef USG
#	define WAITTYPE		int
#	define WIFSTOPPED(w)	(((w)&0377) == 0177)
#	define WIFEXITED(w)	(((w)&0377) == 0)
#	define WIFSIGNALED(w)	(!WIFSTOPPED(w) && !WIFEXITED(w))
#	define WRETCODE(w)	((w) >> 8)
#	define WSTOPSIG(w)	((w) >> 8)
#	define WCOREDUMP(w)	(((w)&0200) != 0)
#	define WTERMSIG(w)	((w) & 0177)
#	define WSETEXIT(w,status) ((w) = (status) << 8 )
#	define WSETSTOP(w,sig)	((w) = (0177 | ((sig) << 8)))
#else
#	include <sys/wait.h>
#	define WAITTYPE		union wait
#	define WRETCODE(w)	(w).w_retcode
#	define WSTOPSIG(w)	(w).w_stopsig
#	define WCOREDUMP(w)	(w).w_coredump
#	define WTERMSIG(w)	(w).w_termsig
#	define WSETEXIT(w,status) ( (w).w_stopval=0, WRETCODE(w)=(status) )
#	define WSETSTOP(w,sig)	( (w).w_stopval=WSTOPPED, WSTOPSIG(w)=(sig) )
#endif
