/*
 * <time.h> : time zone stuff for gnu cc.
 *            (Does *your* laser printer know what time zone it's in??)
 *
 * Andy Wilson, 18-Oct-89.
 */


#ifndef __TIME_H__
#define __TIME_H__
/*
 * must have size_t defined.
 */
#include <stddef.h>

typedef	long		time_t;		/* <time> type */
typedef unsigned long   clock_t;

#define CLK_TCK 1
#define CLOCKS_PER_SEC 1000000

struct	tm {	
	int	tm_sec;		/* seconds (0-59) */
	int	tm_min;		/* minutes (0-59) */
	int	tm_hour;	/* hours (0-23) */
	int	tm_mday;	/* days (1-31) */
	int	tm_mon;		/* months (0-11) */
	int	tm_year;	/* year -1900 */
	int	tm_wday;	/* day of week (sun = 0) */
	int	tm_yday;	/* day of year (0 - 365) */
	int	tm_isdst;	/* non-zero if DST */
};

extern long timezone;
extern int daylight;
extern char *tzname[];

clock_t clock(void);
time_t time(time_t *);
char *asctime(const struct tm *);
char *ctime(const time_t *);
struct tm *gmtime(const time_t *);
struct tm *localtime(const time_t *);
double difftime(time_t, time_t);
time_t mktime(struct tm *);
size_t strftime( char *s, size_t, const char *,
		 const struct tm *);

#endif

