.LP
.nr LL +0.5i
.ll +0.5i
.sp 2
.ce 1
.ps +4
\fBGNU/960 Tools Release Notice\fP
.ps -4
.sp
.ce 1
for Release 1.0
.sp 2
.PP
This notice contains a list of notes concerning specific charateristics
of this release of the GNU/960 tools.  Some of these notes concern known
bugs in the tools which we have not been able to repair by the time of
release, some are minor deviations from the specifications that we expect
to repair for the next release, and some are notes concerning differences
between these tools and others that you may have used.  You should
read these notes carefully, so you are aware of the limitations of this
release.
.SH
Statement of Purpose
.PP
The GNU/960 package is provided by Intel as a courtesy to 960 users.
These tools are intended to be used for development
of evaluation programs for the Intel 960 architecture, and for the
use of 960 customers who do not have access to host computers on which
the normal Intel tools operate, and for those 960 users who wish
to have inexpensive access to the source code to compilers and other
tools, for modification and maintenance.
.PP
\fIThese GNU/960 programs are not replacements for the normal Intel-supported
960 tools.\fP Intel's standard 960 tools, including the
.B iC960
and
.B asm960
products, are maintained by Intel on a regular basis, and Intel provides
normal support services for these tools.  If you have a need for supported
tools, you should be using the standard Intel tools.
.SH
Copyrights and Where These Tools Came From
.PP
Most of the tools in this release were developed and/or distributed
by an organization called the \fBFree Software Foundation\fP.  This
organization has provided tools in source code form, along with a
copyright notice requiring that the tools be redistributed in source
code form.  You should read the copyright notice at the front of the
GCC, CPP, or GDB User's Manuals, or in the file "src/gcc960/common/COPYING".
This explains the restrictions that the FSF has placed on this software.
There are two important exceptions to this:
.IP 1)
The NINDY runtime monitor was wholly developed by Intel, and is copyrighted
by Intel.  You may use the program as you wish, and freely distribute
the source code, but there are some other restrictions regarding use of
Intel Corporation's name in advertising.  This is the NINDY copyright
notice:
.sp
Copyright (c) 1989, Intel Corporation
.sp
Intel hereby grants you permission to copy, modify, and 
distribute this software and its documentation.  Intel grants
this permission provided that the above copyright notice 
appears in all copies and that both the copyright notice and
this permission notice appear in supporting documentation.  In
addition, Intel grants this permission provided that you
prominently mark as not part of the original any modifications
made to this software or documentation, and that the name of 
Intel Corporation not be used in advertising or publicity 
pertaining to distribution of the software or the documentation 
without specific, written prior permission.  

Intel Corporation does not warrant, guarantee or make any 
representations regarding the use of, or the results of the use
of, the software and documentation in terms of correctness, 
accuracy, reliability, currentness, or otherwise; and you rely
on the software, documentation and results solely at your own 
risk.
.sp
.IP 2)
All of the libraries distributed as part of this release are freely
distributable, and do not carry the FSF copyright notice.  Most of the
files are truly in the "public domain", though the files:
\fIstdiolib.h\fP, \fItmpnam.c\fP, and \fIvfprintf.c\fP
are copyrighted with copyrights
that allow redistribution of source code.  These copyrights are in
the source code in "src/lib/libc/common".  The file "vfprintf.c"
contains this notice:
.sp
Copyright (c) 1988 Regents of the University of California.
.br
All rights reserved.
.sp
Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the University of California, Berkeley.  The name of the
University may not be used to endorse or promote products derived
from this software without specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.LP
This \fIshould\fP mean that programs compiled with the GNU/960 tools and
linked with GNU/960 libraries are free from any restrictions.  However,
Intel does not warrant this.
.SH
Warranty and Maintenance
.PP
The GNU/960 tools may or may not meet your needs.  If, during the
first 90 days after you receive these tools, you discover that they
do not meet your needs, you may return the entire GNU/960 package,
including distribution tape, manual, and packing materials, and
we will refund your distribution fee.
.PP
Other than this \fBIntel offers no warranty whatsoever for these tools\fP.
While we will accept bug reports and attempt to make periodic releases
to fix these bugs, we cannot promise to be able to fix any bugs that arise
on a particular schedule.
.LP
In particular:
.sp
THERE IS NO WARRANTY FOR ANY PROGRAM, LIBRARIES, OR OTHER SOFTWARE PROVIDED
AS PART OF THIS GNU/960 DISTRIBUTION, TO THE EXTENT PERMITTED BY
APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THEY COPYRIGHT
HOLDERS, INTEL CORPORATION, AND/OR OTHER PARTIES PROVIDE THESE PROGRAMS
"AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
OF THESE PROGRAMS IS WITH YOU.  SHOULD THE PROGRAMS PROVE DEFECTIVE,
UNDER NO CIRCUMSTANCES SHALL INTEL OR ANY OTHER PARTY
BE RESPONSIBLE FOR THE COST OF NECESSARY SERVICING,
REPAIR, OR CORRECTION.
.sp
IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL
THE COPYRIGHT HOLDERS, INTEL CORPORATION, OR ANY OTHER PARTY WHO MAY
MODIFY AND/OR REDISTRIBUTE THESE PROGRAMS BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OR INABILITY TO USE THESE PROGRAMS (INCLUDING BUT
NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES
SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAMS TO OPERATE
WITH OTHER PROGRAMS), EVEN IN THE EVENT THAT THE COPYRIGHT HOLDER,
INTEL CORPORATION, OR OTHER THIRD PARTIES HAVE BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.
.LP
.SH
Reporting Bugs
.PP
If you report a bug to us, we will attempt to fix it.  However, we
cannot accept bug reports by telephone.  The best way is via
electronic mail, to:
\fBbug-gnu960@mipon2.intel.com\fP,
or by FAX to 'GNU/960 Bug Reports' at (503) 696-4930,
or by normal mail to:
.in +0.5i
.sp
GNU/960 Bug Reports
.br
Intel Corporation, M/S JF1-84
.br
2111 NE 25th Ave
.br
Hillsboro, OR 97124
.in -0.5i
.sp
If you wish to report GCC bugs not specific to the i960 implementation
directly to the FSF, they may be sent to
\fBbug-gcc@prep.ai.mit.edu\fP.  See the GNU CC manual for more details.
.PP
Your bug reports play an important role in making GNU/960 reliable.
In order for a bug report to serve its purpose, you must include
information we need to fix the bug.
.PP
If you are not sure whether you have found a bug, here are some guidelines:
.IP \(bu
If any of the tools gets a fatal signal, for any input whatever, that is a bug.
.sp
.IP \(bu
If the compiler produces invalid assembly code, for any input whatever
(except an \fBasm\fP statement), that is a bug, unless the
compiler reports errors (not just warnings) which would ordinarily
prevent the assembler from being run.
.sp
.IP \(bu
If the compiler produces valid assembly code that does not correctly
execute the input source code, that is a compiler bug.
.sp
.IP \(bu
If a tool produces an error message for valid input, that is a bug.
.sp
.IP \(bu
Your suggestions for improvement of GNU CC are welcome in any case,
though they are usually lower priority than fixinf actual bugs.
.LP
The fundamental principle of reporting bugs usefully is this:
\fIreport all the facts\fP.  If you are not sure whether to state a
fact or leave it out, state it!

To enable us to fix the bug, you should include all these things:

.IP \(bu
Both the base version of problem tool and the 960 release version of that
tool. You can get these by running the tool with the
.B \-v
and
.B \-v960
options, respectively.  GNU/960 CC also
places relevant version number information in comments at the beginning
of each generated assembler file.
Without this, we won't know whether there is any point in looking for
the bug in the current version of GNU CC.

.IP \(bu
A complete input file that will reproduce the bug.  If the bug is in
the C preprocessor, send a source file and any header files that it
requires.  If the bug is in the compiler, run your
source file through the C preprocessor by doing
.DS
gcc960 -E sourcefile > outfile
.DE
and include the contents of outfile in the bug report.
(Any
\fB\-I\fP,
.B \-D
or
.B \-U
options that you used in actual compilation should also be
used when doing this.)

.IP \(bu
The command arguments you gave to the tool to 
observe the bug.  To guarantee
you won't omit something important, list them all.

.IP \(bu
The type of machine you are using, and the operating system name and
version number.

.IP \(bu
A description of what behavior you observe that you believe is
incorrect.  For example, "It gets a fatal signal," or, "There is an
incorrect assembler instruction in the output."

.IP \(bu
If you send me examples of assembler output from
.B gcc960,
please use
.B \-g
when you make them.  The debugging information includes source line
numbers which are essential for correlating the output with the input.
.bp
.sp 2
.ce 1
\fBHost Support\fP
.sp 2
.PP
The GNU/960 tools were developed primarily in a Sun-3, SunOs 4.0 Unix
environment.  We also developed and tested the tools on a Vax 11/785
running Berkeley 4.3BSD Unix.  We provide binaries for several other
systems on the distribution tape, but \fIwe are not able to fully test
the release on every host system\fP.  In particular, the following caveats
apply:
.sp
.IP \(bu
The GNU/960 tools build correctly under Intel's System V Unix, Release 3.2.
The compiler, assembler, loader, and most of the other tools appear
to operate correctly in this environment.  However, due to limitations
in the serial port drivers in this system, \fBgdb960\fP and \fBcomm960\fP
do not work reliably.  The terminal driver does not support receipt of
incoming characters above 240 characters per second, and the XON/XOFF
flow-control protocol that normally throttles the serial port does not
work correctly on this version of Unix.
.sp
.IP \(bu
We have previously built the GNU/960 tools on the Bell Technologies
System V Unix, Release 3.0, and all of the tools operated correctly
in this environment.  However, the tools distributed in binary form
in this distribution were not compiled in that environment, and
may need to be recompiled.
.sp
.IP \(bu
Many systems advertise that they are "System V".  Often, however, these
systems are different from one another in subtle ways, including the
behaviour of the serial ports, the location of include files, various
bugs and resource limitations in the system compilers, and the
presence of Berkeley extensions (often incomplete).  Recompiling and
rebuilding the GNU/960 tools under one of these versions of Unix will
probably \fInot\fP be a "turnkey" operation.  Some experience with
your version of UNIX, and some changes to the GNU/960 Makefiles
will probably be required.
.sp
.IP \(bu
It is unlikely that these tools will work on a system that does not have
at least a 386 processor.  Many data structures used in the tools exceed
64Kb in size, and no provision has been made for compiling them in
a 16-bit environment.
.bp
.sp 2
.ce 1
\fBOverview of GNU/960 Distribution Directory Structure\fP
.sp 2
.LP
.IP admin 1i
Scripts and data files for installation and (re)building of the
GNU/960 tool set and application libraries.
.sp
.IP ROMS 1i
NINDY ROM images.
.sp
.IP i386v 1i
.IP sun3 1i
.IP vax-bsd 1i
Host-specific tool binaries and application libraries for
(respectively):  an i386 system running System V Unix;  a Sun3
running SunOS 4.0;  and a DEC VAX running BSD 4.3 Unix.
.sp
The G960BASE environment variable should be set to the full path
of one of these directories.
.sp
Each host directory is further subdivided into these directories:
.RS
.IP bin 1i
Host-specific executable binaries.
.sp
.IP include 1i
Include files for i80960 applications developed
with the GNU/960 cross-development tools.
.sp
.IP lib 1i
Host-specific executable compiler passes; and
i80960 application libraries and startup files
in host-specific byte ordering.
.sp
.IP man	1i
Manual pages for the GNU/960 tools.
.sp
.IP doc/man 1i
Manual pages for the GNU/960 tools.  Format use "nroff -man"
to format a manual page.  These pages are also linked into the
'man' subdirectories of the host-specific binary directories
(see above).
.sp
.IP doc/misc 1i
Assorted documentation of interest to GNU/960 users.
Documents that fit in a single file and require no formatting appear
in this directory.
.sp
The following subdirectories contain documents that must be formatted
with the TeX text formatter.  Each directory also contains a ".ps"
file with a formatted copy of the document suitable for dumping
directly to a Postscript printer.
.RS
.IP doc/misc/cpp
A description of the GNU C preprocessor.
.IP doc/misc/gcc
gcc960 User's manual
.IP doc/misc/gdb
gdb960 User's manual
.RE
.RE
.sp
.IP include 1i
.IP include/sys 1i
Include (".h") files for applications developed with the GNU/960
tools to run under the NINDY monitor.  These files are also linked
into the 'include' subdirectories of the host-specific binary
directories (see above).
.sp
.IP src/bison/common 1i
Source code for 'bison' the Project GNU version of 'yacc'.  This
tool is not normally needed by GNU/960 users, and is not distributed
in binary form.  See src/bison/READ_ME for more information.
.sp
.IP src/comm960/common 1i
.IP src/fmt960/common 1i
.IP src/gar960/common 1i
.IP src/gas960/common 1i
.IP src/gcc960/common 1i
.IP src/gcc960/common/ORIG 1i
.IP src/gdb960/common 1i
.IP src/gdmp960/common 1i
.IP src/gld960/common 1i
.IP src/gnm960/common 1i
.IP src/gsize960/common 1i
.IP src/gstrip960/common 1i
.IP src/gswab960/common 1i
.IP src/gver960/common 1i
'src/\fItool\fPcommon' contains the source code for the GNU/960 tool
named '\fItool\fP'.  src/gcc960/common/ORIG contains copies of
unalterted files from the 1.36 GCC distribution.
.sp
.IP src/include 1i
Include files needed to build more than one of the GNU/960 tools.
.sp
.IP src/sx/common 1i
Source for the "sx" XMODEM transfer utility, which is invoked
by 'comm960' and 'gdb960' to download to NINDY.  GNU/960 users
should never have to invoke this tool directly.
.sp
.IP src/pcomm/common 1i
Source for a serial communication program for UNIX modeled after
the popular PC program \fBProComm\fP.  This program is not a part
of the standard release, and is not built by default.
.sp
.IP src/lib/crt/common 1i
Source code for the C runtime startup files for application code.
The object files built from these sources are found in the 'lib'
subdirectory of the host-specific binary directories (see above).
These object files provide an entry point for C programs that
will set up the runtime environment appropriately for executing
under the NINDY monitor, then call the 'main()' routine.
.sp
.IP src/lib/libasv/common 1i
.IP src/lib/libc/common 1i
.IP src/lib/libfp/common 1i
.IP src/lib/libgnu/common 1i
.IP src/lib/libnin/common 1i
.IP src/lib/libqt/common 1i
Source code for i960 application code runtime libraries.
The object files built from these sources are found in the 'lib'
subdirectory of the host-specific binary directories (see above).
.sp
.IP src/nindy/common 1i
Source for NINDY Monitor ROM.
.LP
.bp
.sp 2
.ce 1
\fBRelease Notes for GNU/960 Tools\fP
.sp 2
.SH
comm960
.PP
For versions of NINDY older than X1.04,
.B comm960
\fIwill not work\fP
unless invoked with the "-f" option.
This means you cannot download to RAM.  Flash memory can be
loaded (on boards that contain it) with the following procedure:
.IP 1)
comm960 -f /dev/ttyXX
.IP 2)
at the NINDY prmompt ("=>") erase Flash with the "ef" command.
.IP 3)
Press the ESC key;  at the prompt enter the name of the
file containing the new NINDY image.
.LP
NOTE: It is \fPessential\fP that Flash be erased with the "ef" command
before the download is started, and that the NINDY image be
linked specifically for Flash memory.
.PP
For version X1.04 of NINDY,
.B comm960
can be used to download programs to RAM as described
in the manual page, but the procedure described for pre-X1.04
versions must still be used to load new NINDY images into Flash.
.SH
gar960
.PP
Object file headers use the byte-ordering of the host on which they
were created.  If a library is transferred to a host with a different
byte-ordering, the local version of gar960 will not recognize it.
Use gswab960(1GNU) to change a library's byte ordering.
.SH
gas960
.PP
The following ASM-960 directives (most of which are related to symbolic
debugging) are silently ignored if they ever show up in an input source
file: ABORT, def, dim, endif, ident, ln, scl, size, tag, type, val.
.PP
The following limitations have been placed on the .leafproc directive:
.IP \(bu
its argument(s) must be symbol(s) defined in the current assembly.
.IP \(bu
a symbol cannot appear in more than one .leafproc directive
.IP \(bu
if a .leafproc has 2 arguments, they must both be global or both be local.
.SH
gcc960
.PP
The following bugs and limitations exist in this release of the compiler:
.sp
.IP \(bu
The use of
.B "long double"
types is incompletely tested.  This type attempts to generate an
extended-precision (80-bit) floating-point value.  Support in the compiler
for such values is untested.  Since most other C compilers do not
support this type, this should not be a problem.  However, the Intel
.B iC960
compiler does support it, so programs ported from that environment
may not compile, or if they compile, they may not operate correctly.
.sp
.IP \(bu
The compiler currently uses the host computer's native floating-point
format to translate floating-point constant strings into floating-point
binary representations.  This is not much of a problem on machines
such as the Sun or 386-based machines which have IEEE-compatible
floating-point support, but the Vax architecture does not support
a compatible floating-point format.  The Vax-hosted
compiler will generate warning messages noting that the range of
certain floating-point constants exceeds the range available on the Vax.
Even on IEEE architectures, a constant that is too big for a
.B double
but which would fit in a
.B "long double"
will generate such a warning, since none of these machines support
extended-precision arithmetic.
These warnings are important if one expects to use large or very accurate
floating-point numbers when compiling from the Vax.  We hope to
correct this problem in the next release of the compiler.
.IP \(bu
Bitfields that straddle word boundaries do not work correctly, and
will generate a compiler internal error.  The compiler should make
the offending bitfield start at the beginning of the next word, but
it does not.  This can be worked around by placing an empty bitfield
(":0;") before the offending bitfield.
.sp
.IP \(bu
If the
.B \-msoft-float
flag is passed, either explicitly, or implicitly by specifying the
.B \-AKA
or
.B \-ACA
architecture switches, the compiler will generate calls to the following
routines:
.TS
center, box;
l l.
___adddf3	add double-precision
___addsf3	add single-precision
___cmpdf2	compare double-precision
___cmpsf2	compare single-precision
___divdf3	divide double-precision
___divsf3	divide single-precision
___extendsfdf2	extend single to double precision
___fixdfsi	convert double precision to integer
___fixunsdfsi	convert double precision to unsigned
___floatsidf	convert integer to double-precision
___muldf3	multiply double-precision
___mulsf3	multiply single-precision
___negdf2	negate double-precision
___negsf2	negate single-precision
___subdf3	subtract double-precision
___subsf3	subtract single-precision
___truncdfsf2	shorten double to single-precision
.TE
.sp
The routines are not currently supplied with the GNU/960 tools.  No
floating-point emulation library is currently available for these
tools.  We hope to correct this in the next release.
.sp
.IP \(bu
The use of
.B "long long"
to get 64-bit integers is not fully supported.
.sp
.IP \(bu
On the Sun 386i system, certain modules fail to compile, due to a compiler
core-dump in the system "fprintf" routine.  We do not currently understand
the reasons for this.  It will be fixed in the next release.
.sp
.PP
The following notes apply to rebuilding the compiler from source:
.LP
Rebuilding the front end (parser) of the compiler requires the use
of 'bison', the GNU version of 'yacc', which is not a standard part
of the GNU/960 release.
It should never be necessary to modify the parser since it is in no
way related to the runtime environment or the code generated by the
compiler.
.PP
\fBBison\fP is invoked from the
.B gcc960
Makefile to create the parsing tables
in c-parse.tab.c and cexp.c from the input files c-parse.y and cexp.y,
respectively.  If you need to rebuild
\fBgcc960\fP, you can avoid running
bison to rebuild these ".c" files by making sure that they are newer
than c-parse.y and cexp.y (e.g., by using the Unix 'touch' command).
If for some reason you truly wish to modify the the ".y" files, you
will have to build and install a version of bison first.  A copy
of the bison source exactly as received from the Free Software
Foundation is included with the GNU/960 distribution for this purpose.
There is no additional support for creating bison in the GNU/960
package.
.SH
gdb960
.PP
\fIGreat\fP care must be taken in assigning values to variables
that are stored in or accessed through global registers.
You may not be changing what you think you're changing.
.PP
The QT960 board must contain X1.04 or newer of the NINDY ROM monitor.
.PP
The current version of
.B gdb960
cannot tell when addresses are in ROM
or Flash memory.  Breakpoints set on instructions in ROM/Flash and
modifications to data in ROM/Flash will seem to succeed but will have
no effect.
.PP
You must re-download before rerunning if initialized variables (data seg)
are modified.
.SH
gdmp960/gdb960 disassembly
.PP
The opcode mnemonic of a branch instruction whose branch-prediction bit
is set to "false" (no branch expected) is displayed with a suffix of
".f".  If the bit is set to "true" (the default), no suffix is added.
This avoids cluttering displays of 960KX code (which doesn't support
branch prediction) while providing the necessary information for 960CX
code.  E.g.,
.DS
	cmpobg.f  3,r4,0x1267	# "won't branch" predicted
	cmpobg    3,r4,0x1267	# "will branch" predicted
.DE
.bp
.sp 2
.ce 1
\fBRelease Notes for GNU/960 Support Libraries\fP


.SH
Overview
.PP
Release 1.0 of GNU/960 C contains an ANSI-compliant library.  The primary
documentation for the library functions is
\fIC: A Reference Manual\fP
(second edition) by 
Harbison and Steele, as supplied with the compiler.
This release notice documents 
omissions, extensions, usage notes, defaults, known bugs, and errata.
.sp
.SH
Sources
.PP
The GNU960 C library has been drawn from many public-domain sources.
In the course 
of adapting this code to run in the 80960 environment, some of the
history and commentary pertaining to other computer systems have been
removed, but in all cases the original 
author's attribution and copyright notice (if any) have been left intact.
You are free to make whatever use you wish of these sources, but please
maintain the same courtesy to the original authors.
.sp
.SH
Omissions
.LP
.sp
.IP "<locale.h>" 1i
Only locale "C" (the default locale) is supported in release 1.0.
.sp
.IP "<stdarg.h>" 1i
The ANSI style of variable argument lists, <stdarg.h>, does not work 
correctly in this release.  Use the older style of variable argument lists 
(<varargs.h>) instead.
.sp
IP "<time.h>" 1i
Although the header file <time.h> is present, all date and time conversion 
routines are no-ops in release 1.0.
.sp
.IP "OS routines" 1i
Functions that depend on the presence of an operating system or command 
interpreter (system and getenv) are no-ops in the library as shipped 
from the factory.
.sp
.SH
Extensions
.LP
The GNU library includes the non-ANSI functions \fBbcopy()\fP and \fBbzero()\fP.
.sp
.SH
Usage Notes
.LP
.sp
.IP "<math.h>" 1i
If you are compiling for a KB or MC processor, the following functions are 
defined as inline in <math.h>:
\fBatan(), atan2(), ceil(), cos(), exp(), 
fabs(), floor(), fmod(), frexp(), ldexp(), log(), log10(), modf(), 
sin(), sqrt(),\fP and \fBtan()\fP.
You can suppress the inlining by defining 
__NOINLINE__ before including <math.h>, making your program 
smaller but slower.
.sp
To get maximum performance from inlined math routines, you can suppress 
error checking by defining __NOERRCHECK__ before including <math.h>.
.sp
.IP "<stdio.h>" 1i
When the library is compiled for the 80960 KA or CA, floating point 
conversions are not supported in printf and scanf.
.sp
.SH
Bugs and Warnings
.LP
.sp
.IP clock 1i
In this release of the library, clock works by calling the Nindy benchmark 
timing routines.  On the QT960 board, this causes timer interrupts.  If you 
use clock, call the Nindy routine term_bentime at the end of your 
program to disable timer interrupts.
.sp
.IP <math.h> 1i
There are vestiges of the non-ANSI \fBmatherr()\fP error reporting function in 
the header <math.h> and in the sources for some functions.  These vestiges 
will disappear in future releases.
.sp
.IP <stdio.h> 1i
In future releases of the library, these routines will be converted to work 
correctly in a multi-tasking environment and their internal structures will 
change.  Do not access stdio internal data structures directly.
.sp
.SH
Defaults
.LP
.sp
.IP <signal.h> 1i
All signals default to SIG_DFL, i.e., when raised they call _exit and 
terminate the program.
.sp
.IP <stdio.h> 1i
The streams stdout and stderr default to non-buffered IO.  The stream 
stdin defaults to line buffering.  Use the setvbuf function if you wish 
to change these settings.
.sp
.SH
Errata
.LP
C: A Reference Manual (second edition) contains a few errors in describing
the library, generally of a fairly picayune nature.
.sp
.IP \(bu
Page 307: arguments ptr1 and ptr2 to memcmp have type const void *.
.IP \(bu
Page 308: memcpy returns the value of dest.
.IP \(bu
Page 309: The first argument to memset has type void *.
.IP \(bu
Page 353: The second argument to modf has type double *.
.IP \(bu
Page 364: The macro assert prints its message on the standard error stream, 
not standard output.
.sp
.SH
libnin.a
.LP
The Intel format version of the NINDY runtime library requires V2.0
of ic960 (and the associated header files) in order to recompile
correctly.
.bp
.sp 2
.ce 1
\fBRelease Notes for GNU/960 NINDY Monitor\fP
.sp 2
.PP
The source code for the NINDY runtime monitor is provided with this
distribution.  However, it is likely that the Makefiles and other
procedures for rebuilding NINDY roms do not operate correctly.
Pre-compiled image for burning into ROMs or for downloading into
Flash memory are provided in the directory "ROMS" on this release.
A file in that directory called "install.doc" will instruct you
regarding how to install these ROM images on your boards.
.PP
The next release will include a fully reconfigurable NINDY monitor.
