.LP
.sp 2
.ps +4
.ce 1
Installing the GNU/960 Tools
.ps -4
.sp
.ce 1
Notes for Release 1.0
.sp 2
.PP
The GNU/960 tool set assumes you are running under Unix:  either BSD,
System V, or a derivative of one of them.
.sp
.ce 1
\fBNOTE
.sp
If you are running under system V Unix, you
must be running under the Bourne shell in
order for any of the scripts on the "admin"
directory to work.  (This is not a problem
under a BSD derivative.)\fP
.sp
.SH
To install the tools:
.LP
.IP 1)
Create a root directory for the tools, and change to it.  E.g.,
.DS
	mkdir /usr/local/g960
	cd /usr/local/g960
.DE
.sp
The exact path and name of the directory is up to you. 
.sp
NOTES:
.RS
.IP \(bu
To install the entire GNU/960 distribution, you will require
approximately 20 Mbytes of free disk space.  To rebuild the
distribution from sources, you will require approximately 35 Mbytes
of free disk space.  If space is a concern, you can save approximately
3.5 Mbytes by not loading the "doc" directory, or approximately
12 Mbytes by not loading any source code to the tools.
.IP \(bu
In the rest of this document, the root directory will be
referred to as "<root>".  Wherever you see <root>,
substitute the full path of the directory you actually
created for this purpose.
.sp
.IP \(bu
You must be in <root> to run any of the GNU/960
installation or configuration utilities.
.RE
.sp
.IP 2)
Load the distribution tape into your tape drive and ask your
system administrator for the name of the tape device (e.g.,
"/dev/rmt8").   Use that name wherever "<tapedev>" appears below.
On Sun systems, the devices is usually /dev/rst8.  On Unix 386 System V
systems, the device is usually /dev/tape.
.sp
.IP 3)
Use the Unix "tar" command to load the GNU/960 "admin" directory
from the tape; type:
.DS
	tar xvfo <tapedev> admin
.DE
.sp
NOTES:
.RS
.IP \(bu
See step (2) for <tapedev>.
.IP \(bu
The "o" option is needed under System V;  it does not hurt under BSD.
.IP \(bu
On some systems, you may have to say "/etc/tar" instead of "tar".
.RE
.sp
.IP 4)
Now determine what is available for installation by invoking
the "ginstall" command without arguments;  type:
.DS
	admin/ginstall
.DE
.sp
You will see a list of symbolic names and a brief description
of what each represents.  Included will be executable binaries
and libraries for assorted hosts, tool source code, and the
NINDY ROM monitor.
.sp
.IP 5)
Load the desired items from the tape;  type:
.DS
	admin/ginstall -f <tapedev> <items>
.DE
.sp
NOTES:
.RS
.IP \(bu
See step (2) for <tapedev>.
.IP \(bu
Replace <items> with a blank-separated list of the items you selected in step
(4).
.IP \(bu
Regardless of your selection(s), documentation and
application include files are ALWAYS installed.
.RE
.sp
.IP 6)
You can now consult the directory <root>/doc for additional
documentation (see step (1) for <root>).
.sp
.LP
.SH
To run the tools:
.LP
.sp
.IP 7)
If your host is one of the standard supported hosts (binary for
it was listed in step (4)) you should have loaded its binary in
step (5).  Set two environment variables to make the tools accessible:
.RS
.IP a)
set the environment variable G960BASE to the base
directory for your host, using the syntax appropriate
for the shell under which you are running:
.TS
center;
l l.
Bourne shell:	G960BASE=<root>/<host>; export G960BASE
e.g.:	G960BASE=/usr/local/g960/sun3; export G960BASE

C-shell:	setenv G960BASE <base>/<host>
e.g.:	setenv G960BASE /usr/local/g960/sun3
.TE
.sp
.IP b)
Now add $G960BASE/bin to your PATH environment variable
.TS
center;
l l.
Bourne shell:	PATH=$PATH:$G960BASE/bin
C-shell:	setenv PATH $PATH:$G960BASE/bin
.TE
.sp
NOTES:
.RS
.IP \(bu
see step (1) for <root>.
.IP \(bu
<host> should be one of the choices presented in step (4).
.RE
.RE
.sp
.IP 8)
If your host is NOT one of the standard supported hosts, you
should have loaded the tool source code in step (5).  Now:
.RS
.IP a)
Change to the <root> directory
.IP b)
Configure the source directories for your host, create
directories for its executable binaries, and create a
top-level makefile by typing:
.DS
	admin/mkhost <host>
.DE
.IP c)
Build and install the tool and library binaries by typing:
.DS
	make HOST=<host>
.DE
If the make fails for your host, you will have to modify source
code and/or makefiles and re-run the make.  See the document
"GNU/960 Tool Development" for further information.
.IP d)
Set the environment variables as in step (7).
.sp
NOTES:
.RS
.IP \(bu
see step (1) for <root>.
.IP \(bu
you may pick any string for <host>, as long as you use
it consistently.  You should also add it to the
<root>/admin/HOSTS file if it's not already there.
.RE
.RE
.sp
.IP 9)
See the document "GNU/960 Application Development" for an overview
of tool usage.  See the individual manual pages for detailed
information about each tool.
