.LP
.nr LL +0.5i
.ll +0.5i
.sp 2
.ce
.ps +4
\fBGNU/960 Application Development\fP
.ps -4
.sp
.ce 1
Notes for Release 1.0
.sp 2
.PP
This document covers the process of compiling, linking, downloading,
and running a program in the GNU/960 environment.

.SH
ENVIRONMENT
.PP
The GNU/960 tool set provides, on a variety of hosts running Unix operating
systems, a cross-development environment for members of the Intel i960
processor family.
.PP
In order to run the GNU/960 tools, a tools root directory must first be
created on the host sytem and the tools loaded into it according to the
instructions in \fIInstalling the GNU/960 Tools\fP.  The tools root directory
will then contain one or more subdirectories named after supported host
computers (e.g., "sun3", "vax-bsd").
.LP
Each host-specific directory contains four subdirectories:
.IP \(bu
\fBbin\fP \(em contains the executable tools.
.sp
.IP \(bu
\fBinclude\fP \(em contains ".h" files to be included by application programs.
.sp
.IP \(bu
\fBlib\fP \(em
contains i960 object code libraries, compiler passes, and other runtime files.
.sp
.IP \(bu
\fBman\fP \(em
contains the manual pages for the tools.
.sp
.PP
The GNU/960 tools can be made accessible by setting the G960BASE
environment variable to the full pathname of the directory for your
host and then adding "$G960BASE/bin" to your PATH environment variable.
.PP
Various tools will then make use of the G960BASE variable to find
runtime files in the relevant subdirectories:
.IP
$G960BASE/bin is accessed by:
.in +0.5i
.sp
.nf
.na
.ta \w'comm960 'u
comm960	to find the sx ZMODEM transfer utility
gran960	to find gar960 librarian
gcc960	to find the gas960 assembler and the gld960 linker
gdb960	to find the comm960 file conversion/download tool
.fi
.ad
.in -0.5i
.sp
.IP
$G960BASE/include is accessed by:
.sp
.in +0.5i
.br
.ta \w'comm960 'u
gcc960  to find the application #include files
.in -0.5i
.sp
.IP
$G960BASE/lib is accessed by:
.sp
.in +0.5i
.ta \w'comm960 'u
gld960	to find the i960 object libraries
.br
gcc960	to find the compiler passes and i960 C runtime startup file
.in -0.5i
.sp
.IP
Other environment variables, whose setting is optional, will also be
checked by the tools:
.sp
.in +0.5i
.ta \w'G960BASE 'u
.nf
.na
G960BIN:	if set, its value overrides the path $G960BASE/bin.
G960INC:	if set, its value overrides the path $G960BASE/include.
G960LIB:	if set, its value overrides the path $G960BASE/lib.
.fi
.ad
.in -0.5i
.sp
.PP
In addition,
.B gcc960
supports a large number of environment variables
that allow customization of all aspects of its functionality.
See the ENVIRONMENT section of the individual tool manual pages for details
on environment variables examined by each tool.
.sp 2
.ce 1
.SH
Creating Object Files 
.SH
Object File format
.PP
The GNU/960 tools produce object files in a \fIb.out\fP format, a modified
version of \fIa.out\fP format.  These object files are \fInot\fP compatible
with the COFF format files produced by the Intel development tools.
.SH
Compiling
.PP
Compile your C programs with the \fBgcc960\fP compiler.  \fBgcc960\fP provides
a large number of switches to tailor and control code generation;
see the manual page for details.  Among the more important ones are
the following ones:
.sp
.IP \-A
Use this switch to specify the i960 architecture for which
code should be generated.  If you do not specify an architecture,
it will default to the i960KB.
.sp
.IP \-c 
Use this switch to compile and assemble a C source file and
leave the resulting object file around for later processing
in a link step (as opposed to passing it to the linker
immediately).
.sp
.IP \-g
Be sure to use this switch if you intend to use
.B gdb960
to debug
your program.  NOTE: debug information generated by this option
is incompatible with the Intel assembler.
.sp
.IP \-S 
If you need to create files compatible with the Intel COFF
object format but wish to mix code generated with
.B gcc960
and
.BR ic960 :
use this switch, feed the resulting assembler
source (".s") file to the Intel assembler (\fBasm960\fP), and
follow the Intel tool path from that point on.
.sp
.SH
Assembling
.LP
The C compiler driver
.B gcc960
compiles C programs (files ending in ".c"),
assembler programs (files ending in ".s"),
object files (files ending in ".o"),
and libraries (files ending in ".a")
and automatically invokes the C preprocessor, the C compiler itself,
the
.B gas960
assembler,
and the
.B gld960
linker
to create the requested output file.
.B gas960
may also be invoked directly to assemble
programs written in assembler.
.LP
The
.B gas960
assembler
accepts the same input syntax as the Intel
.B asm960
assembler, with
the following caveats:
.IP \(bu
the following
.B asm960
directives (most of which are related to
symbolic debugging) are silently ignored if they appear in a
source file:
.LP
.TS
center, box;
c | c | c | c.
\|.ABORT	\|.endif	\|.scl	\|.type
_
\|.def	\|.ident	\|.size	\|.val
_
\|.dim	\|.ln	\|.tag
.TE
.LP
.sp
.IP \(bu
the following limitations have been placed on the .leafproc
directive:
.RS
.IP \(bu
its argument(s) must be symbol(s) defined in the current assembly.
.IP \(bu
the same symbol cannot appear in more than one .leafproc directive.
.IP \(bu
if a .leafproc has two arguments, either they must both
be global or they must both be local.  (If only one is
declared with ".extern",
.B gas960
will force the other
to be global as well.)
.RE
.PP
NOTE: The default name of the object file produced by gas960 is
"b.out";  this name is normally overridden with the "-o" switch.
.LP
See the
.B gas960
manual page for further details.

.SH
Linking Object Files 
.PP
The GNU/960 linker (\fBgld960\fP) can be invoked directly to link object
files, or
.B gcc960
can invoke the linker for you.
.B gld960
will be
described first, in order to present the necessary concepts; but
.B gcc960
is normally more convenient since it provides useful defaults for most
of the information the linker needs.
.SH
gld960
.PP
The \fBgld960\fP linker combines object files and searches object file libraries,
producing an output file that can be downloaded to and run on a board
containing an i960 processor.  It is typically invoked as:
.DS
gld960 \fIarch\fP \fIloadaddr\fP \fIcrt\fP \fIobjs ...\fP \fIlibs ...\fP
.DE
where
.IP \fIarch\fP 1i
is an optional target architecture specification (the \fB-A\fP
switch).  The target architecture is used to select among
the alternatives when multiple (target-specific) versions
of a library exist.
.sp
If not specified, the architecture defaults to KB.
.sp
.IP \fIloadaddr\fP 1i
is an optional (but usually necessary) specification of
the runtime memory map under which the code will be running.
.sp
Two separate load addresses can be specified:
.sp
.RS
.IP \(bu
the "-Ttext" switch specifies the address at which
the program Text segment (executable instructions)
should begin.  If not specified, the Text is loaded
at address 0.
.IP \(bu
the "-Tdata" switch specifies the origin of the Data
segment (initialized data).  If not specified, the
Data is loaded immediately after the Text.
The BSS segment (uninitialized data) is always loaded
immediately after the Data segment.
.RE
.sp
.IP \fIcrt\fP 1i
is the C runtime startup file, an object file containing
a routine that initializes the runtime environment
appropriately and then invokes the main() routine.
.sp
This file \fImust\fP be the first object file specified on
the linker invocation line, unless a "-e" switch is also
used to call it out as the entry point.
.sp
.IP "\fIobjs ...\fP" 1i
are object files and/or libraries previously compiled or
assembled from user-written source code.
.sp
.IP "\fIlibs ...\fP" 1i
are the GNU/960 object libraries to be searched.  The order
in which they are specified indicates the order in which
they are to be searched and is highly significant.  They
should follow the user objects and libraries and be
specified in this order:
.RS
.IP 1)
the C runtime library;
.IP 2)
the NINDY interface library (or equivalent, if not running under NINDY);
.IP 3)
the board-specific library (or equivalent, if not running under NINDY); and
.IP 4)
libgnu (if any of the code was generated by gcc960);
.RE
.sp
See the section "Standard Libraries" (below) for further details.
.sp
The linker output file is named \fIb.out\fP unless the -o switch is used.
.sp
See the
.B gld960
manual page for further details.

.SH
gcc960
.PP
As noted above, the linker can be indirectly invoked by \fBgcc960\fP.
\fBgcc960\fP provides defaults
for most of the linker arguments described above;  when they are appropriate,
these defaults can greatly simplify invocation of the linker.
.PP
The linker defaults provided by
.B gcc960
are:
.ta \w'<loadaddr> 'u
.DS
\fIarch\fP	= -AKB
\fIloadaddr\fP	= -Ttext 8000000
\fIcrt\fP	= $G960BASE/lib/crtning.o
\fIlibs\fP	= -lcg -lning -lqtg -lgnu
.DE
.PP
These default values are appropriate for code to be run on the QT960
Evaluation Board under the NINDY ROM Monitor.  With the defaults, the
following invocation will link a set of user objects and libraries (\fIobjs\fP):
.DS
	gcc960 \fIobjs ...\fP
.DE
The executable file will be named "b.out" unless the "-o" switch is also
used.
.LP
.B gcc960
linker defaults can be overriden as follows:
.sp
.IP \fIarch\fP 1i
Use the
.B \-A
switch
.sp
.IP \fIloadaddr\fP 1i
Use
.B \-Ttext
and/or
.B \-Tdata
switches.
.sp
.IP \fIcrt\fP 1i
Use the
.B \-crt
switch, followed by the name of the crt file
you wish to use (e.g., "-crt crtninfg.o").  Note that this
switch must appear before any object files, unless you also
use the "-e" switch.  Also note that crt file must be present
locally or specified with a path (the "standard places" will
not be searched).
.IP \fIlibs\fP 1i
Use the
.B \-nostdlib
switch to turn off inclusion of the
default libraries (except for libgnu.a, which gcc960 will
always pass as the last library to be searched).  Then
specify \fIall\fP libraries to be searched, using the "-l"
(letter "ell") switch and/or full pathnames.  Order is important.
.PP
To link for the EV80960CA evaluation board the following is needed:
.ta \w'<loadaddr> 'u
.DS
\fIarch\fP	= -ACA
\fIloadaddr\fP	= -Ttext e0000000
\fIlibs\fP	= -lcg -lning -lasvg -lfpg
.DE
Thus, the invocation would be:
.DS
	gcc960 -ACA -Ttext e0000000 \fIobjs...\fP -nostdlib -lcg -lning -lasvg -lfpg
.DE
See the gcc960 manual page for further details.

.SH
Stack and Heap
.PP
Among other things, the standard crt routine (which assume you are running
under the NINDY monitor) allocate your program's heap and stack.  (The
heap is the memory available for dynamic allocation via the "malloc()"
routine in the C library.)
.PP
The symbol \fI_end\fP (\fIend\fP in C) is defined by the linker and refers to
the first location above all data.  The crt routine allocates the heap
beginning at \fI_end\fP, i.e., immediately after the Data/BSS segments.
The size of the heap is 'heap_size' bytes, where 'heap_size' is a constant
defined in an object file in libning.a, the NINDY runtime library.
The default 'heap_size' is 0x1000.
.PP
The stack is then allocated at the first 64-byte boundary after the heap, and
will grow into higher memory into whatever additional RAM is available.
.sp
.ce 1
NOTE
.in +0.5i
\fBWhen loading Text at a higher address than Data/BSS, it is
essential to leave enough memory above Data/BSS for the heap
and stack.\fP
.in -0.5i
.LP
If you wish to override the default and set the heap size to XXXX bytes,
add the following lines to a file that will be assembled and linked into
your program:
.DS
	.globl	heap_size
	.set	heap_size,XXXX
.DE

.SH
Standard Libraries
.PP
Five types of standard libraries are shipped with the GNU/960 tool set.
In the order in which they should be linked, they are:
.IP 1)
C runtime (libc) \(em
An ANSI-compliant version of the C runtime library, as described
in "C: A Reference Manual" (second edition) by Harbison and
Steele, except as amended by the GNU/960 release notes.
.sp
.IP 2)
NINDY runtime (libnin) \(em
Contains lower-level "operating system" functions that interface
the routines in libc with the NINDY monitor.
.sp
.IP 3)
Board-specific (libqt, libasv) \(em
Contains functions providing user access to board-specific
hardware such as timers.  See the documentation that comes
with the board in question.
.RS
.IP libqt:
QT960 Evaluation and Protyping Board
.IP libasv:
EV80960CA Evaluation Board
.RE
.sp
.IP 4)
Floating point emulation libraries (libfp) \(em
Emulation of floating point for i960 architectures that do not
have a floating point instruction set.
.sp
.IP 5)
GNU runtime library (libgnu) \(em
Intrinsic runtime support routines to which gcc960 implicitly
generates calls.
.sp
.LP
The names given above are logical names.  In fact, most of the libraries
exist in multiple versions, for one (or both) of two reasons:
.sp
.IP 1)
most of the libraries are available in either of two formats:
b.out (compatible with GNU/960 tools) or COFF (compatible with
Intel tools).
.sp
.IP 2)
some libraries vary depending on the target i960 architecture (KA, KB, MC, CA).
.LP
The actual library names follow the following convention:
.IP \(bu
They start with the logical name;
.IP \(bu
If the library is in GNU/960 b.out format, the letter "g" is appended; and
.IP \(bu
If the library exists in architecture-specific versions,
the appropriate architecture: "ka", "kb", or "ca" (the "kb"
version is used for both the i960KB and the i960MC) is appended; and
.IP \(bu
The suffix ".a" is appended, indicating an archive library;
.IP 5)
except:
.RS
.IP \(em
libgnu exists in b.out format only and is named "libgnu.a"
.IP \(em
the COFF version of libfp is named "libfpal.a".
.RE
.sp
The chart below summarizes the names of the available libraries.

.TS
center, box;
l | l | l.
	b.out (GNU)	COFF (Intel)
	version	version
_
	libcgka.a	* libcka.a
C runtime	libcgkb.a	* libckb.a
	libcgca.a	* libcca.a
_
NINDY	libning.a	libnin.a
_
	libasvg.a	libasv.a
board-specific	libqtg.a	libqt.a
_
Floating point	libfpgka.a	* libfpal.a
emulation	libfpgca.a	* libfpal.a
_
GNU runtime	libgnu.a	(none)
.TE
* part of Intel tool set, NOT shipped with GNU/960
.sp
.PP
Libraries to be searched can be specified to the GNU/960 linker either with a
full pathname or with the
.B \-l
switch.
.LP
To use the
.B \-l
switch:
.RS
.IP \(em
omit the leading "lib" and the trailing ".a".
E.g., specify libqtg.a as "-lqtg".
.IP \(em
if architecture-specific variations of the library exist, you
may further omit the architecture letters and allow the linker
to choose based on the architecture for which it is linking.
E.g., you may specify libcgka.a as "-lcg" if the -AKA switch
has also been used.
.IP \(em
gld960's algorithm for locating a library specified with "-lXXX" is as
follows:
.RS
.IP 1)
Locate the library directory:
.RS
.IP \(em
get the path from environment variable G960LIB, if defined.
.IP \(em
otherwise look in $G960BASE/lib, if G960BASE is defined.
.IP \(em
otherwise look in directory /usr/local/g960/<host>/lib, if it exists.
.IP \(em
otherwise look in the current working directory.
.RE
.sp
.IP 2)
If "libXXX.a" exists in the library directory, use it.
.sp
.IP 3)
Otherwise, pick the appropriate suffix "AA" based on the
architecture for which we are linking and use "libXXXAA.a".
.RE
.RE
.SH
Standard CRT Files
.PP
The crt file is an object file containing the C runtime startup routine, 
a routine that initializes the runtime environment appropriately and then
invokes the C main() routine.
.PP
The code in the crt file is highly dependent on the compiler used to generate
the application code and the operating system under which it is run.  The
GNU/960 distribution includes two crt files appropriate for running, under the
NINDY monitor, code generated with the GNU/960 tools:
.IP \(bu
\fIcrtnin\fP \(em
startup code for applications to be run under the NINDY monitor.
.IP \(bu
\fIcrtfnin\fP \(em
a variation of \fIcrtnin\fP, to be used when the application is
intended to be downloaded to and run out of Flash memory (on QT960 boards).
.PP
As with the libraries, both b.out (GNU/960) and COFF (Intel) versions of
these files are distributed.  The GNU/960 version has a "g" appended to
the file name, and all files have ".o" extensions.  The following chart
summarizes the names of the available crt files.
.sp
.TS
center, box;
l | l | l.
	b.out (GNU)	COFF (Intel)
	version	version
_
Normal	crtning.o	crtnin.o
_
Flash memory	crtfning.o	crtfnin.o
.TE
.sp
See also the section "Stack and Heap", above.

.SH
Debugging
.PP
The GNU/960 distribution includes two tools for running and debugging
programs on a board containing a NINDY ROM monitor.  Both tools run on
the host system and communicate with NINDY over a (non-loginable) serial
line.

.SH
Comm960
.LP
comm960 provides the ability to:
.IP 1)
download executable object files created with either the GNU/960
or Intel development tools to a target board containing a NINDY
ROM monitor, and
.IP 2)
use the host computer as a virtual terminal to NINDY and the
application program.
.LP
Once the program is downloaded, NINDY can be used to set breakpoints,
examine memory and register, disassemble instructions, run the program, etc.
See the comm960 manual page and NINDY documentation for more details.
.SH
gdb960
.PP
gdb960 provides download capability (by invoking comm960) and complete
C-level symbolic debug capabilities for code generated with the GNU/960
tool set.
In order to take full advantage of symbolic debug, the application code
should be compiled with the -g switch.
See the gdb960 manual page for more details.
.PP
The Makefile distributed with the gdb960 source contains a target for a
version (called gdb960c) that works with COFF files generated with the
Intel development tools.  See "GNU/960 Tool Development" for details on
rebuilding the tools.


.SH
Caveats
.LP
Both comm960 and gdb960 require:
.IP 1)
the version of NINDY to be X1.04 or higher, and
.IP 2)
NINDY's baud rate to be set to 9600.
.LP
Note that if a program modifies initialized variables (the Data segment),
it is necessary to re-download it before re-running it in order to assure
correct execution.
