/* Ranlib.h -- random library table of contents
 *
 * A random library is an archive with a table of contents called __.SYMDEF
 * as its first file and a.out files for the rest.  The table of contents
 * is a list of file table entries, each of which contains a list of symbols
 * the file defines.
 *
 * The format of the __.SYMDEF file is:
 *
 *   +------------------------+
 *   | ranlib header          |
 *   +------------------------+
 *   | file table             |
 *   +------------------------+
 *   | string table           |
 *   +------------------------+
 */

struct rl_head {       /* ranlib header */
  long rl_ftabsz;      /* size of file table in bytes */
  long rl_stabsz;      /* size of string table in bytes */
};

struct rl_file {       /* ranlib file table entry */
  long rl_offset;      /* offset of file in archive suitable for lseek'ing */
  short rl_numsym;     /* number of entries in rl_sym[] */
  long rl_sym[1];      /* actually variable length, offsets into string table */
};

#define RL_NAME "__.SYMDEF"
