/* NS32000 Assembler
 * Phase3.c
 * Writes the .o file.
 */
#include <stdio.h>
#ifdef MSDOS
#  include "a_out.h"
#else
#  include "a.out.h"
#endif
#include "conv.h"
#include "glob.h"

/* Writes the .o file.
 */
phase3()
{
  phase = 3;
  if (debug) printf ("header.a_text: 0x%lx, header.a_data: 0x%lx\n",
    header.a_text, header.a_data);
  myfseek (outfp, (long) sizeof (struct exec));
  patch_seg (T_TEXT);                  /* write text segment */
  patch_seg (T_DATA);                  /* write data segment */
  update_symtab ();                    /* compute sym tab len, indices */
  write_reloc (T_TEXT);                /* write the text relocation table */
  write_reloc (T_DATA);                /* write the data relocation table */
  write_symtab();
  write_strtab();
  write_header();
}

/* Backpatch segment.  This consists of reading the segment's tmp file,
 * merging it with its patch list, and writing it to the .o file.
 */
patch_seg (seg)
int seg;
{
  long locptr, bytes_written, inc, end;
  patchptr pch;
  FILE *ifile;
  U32 ival;
  U8 outstr [4];

  if (seg == T_TEXT) {                 /* setup for text or data segment */
    end = header.a_text;               /* text segment */
    ifile = tmpt;
    pch = tpatch_head;
  } else {
    end = header.a_data;               /* data segment */
    ifile = tmpd;
    pch = dpatch_head;
  }
  myfseek (ifile, 0L, 0);
  curlocptr = &locptr;
  bytes_written = 0;
  for (;;) {
    while (pch != NULL &&              /* skip patch if already written */
      pch->flags & pWRITTEN) pch = pch->link;
    if (pch == NULL) {                 /* patches done, write remaining bytes */
      copy_tmp (end - bytes_written, ifile);
      break;
    }
    inc = (locptr = pch->offset) +
      pch->pcoff - bytes_written;
    copy_tmp (inc, ifile);             /* write up to next patch */
    bytes_written += inc;
    if (!(pch->typ & T_RESOLVED)) {    /* compute expression if needed */
      lnnum = pch->lnnum;              /* for error reporting */
      eval_exp (pch->exp, &pch->typ,
        &pch->val, &pch->undf);
    }
    if (!(pch->typ & T_RESOLVED))      /* remove after debugging */
      error ("!#could not resolve expression");
    if (pch->flags & pSHORT) {         /* must | into bytes already written */
      ival = 0;
      for (inc = 0; inc < pch->size; ++inc)
        ival |= mygetc (ifile) << (inc << 3);
    }
    fmt_patch (pch, ival, outstr);     /* format and write patch bytes */
    myfwrite ((char *)outstr, pch->size, outfp);
    bytes_written += pch->size;
    pch = pch->link;
  }
  if (inc = end % SEGALIGN) {          /* round off size of segment */
    inc = SEGALIGN - inc; 
    if (seg == T_TEXT) header.a_text += inc;
    else header.a_data += inc;
    while (inc--) myputc (0, outfp);
  }
}

#define BUFSZ 100
/* Copy len bytes from ifile to .o file.
 */
copy_tmp (len, ifile)
long len;
FILE *ifile;
{
  char buf [BUFSZ];
  int inc;

  while (inc = len > BUFSZ? BUFSZ: len) {
    myfread (buf, inc, ifile);
    myfwrite (buf, inc, outfp);
    len -= inc;
  }
}

/* For each T_UNDF and non-T_STATIC label, we need 1) its index in the symbol
 * table and 2) the index of the identifier in the string table.  While
 * we are at it, compute the lengths of the symbol table and the string
 * table.
 */
static update_symtab1 (p)
register lblptr p;
{
  if (p->typ & T_STATIC) return;
  p->sym_ix = header.a_sym++;          /* symbol table index */
  p->llink = (lblptr) header.a_str;    /* use llink for strtab offset */
  header.a_str += p->id_len;
}

/* Used with update_symtab1.
 */
update_symtab()
{
  hashnav (T_TEXT | T_DATA | T_BSS | T_UNDF, update_symtab1);
  header.a_sym *= sizeof (struct nlist);
}

/* Write the relocation table for the given segment.
 */
write_reloc (seg)
int seg;
{
  patchptr pch;
  long *cntp;
  register U32 tmp;
  struct r_info rel;

  if (seg == T_TEXT) {
    pch = tpatch_head;
    cntp = &header.a_trsize;
  } else {
    pch = dpatch_head;
    cntp = &header.a_drsize;
  }
  for (; pch != NULL; pch = pch->link) {
    switch (pch->typ & T_LBL) {
      case T_TEXT:
        if (seg == T_TEXT &&           /* if pc rel text ref to text sym */
          pch->flags & pPCREL)
          continue;                    /* write no relocation entry */
        rel.r_sym = R_SPECIAL | R_TEXT;
        break;
      case T_DATA:
        rel.r_sym = R_SPECIAL | R_DATA;
        break;
      case T_BSS:
        rel.r_sym = R_SPECIAL | R_BSS;
        break;
      case T_UNDF:
        rel.r_sym = pch->undf->sym_ix; /* index in symtab */
        break;
      default:			       /* T_IMM, pALIGN... */
        continue;                      /* write no relocation entry */
    }
    if (pch->flags & pPCREL) rel.r_sym |= R_PCREL;
    if (pch->flags & pGENIMM) rel.r_sym |= R_GENIMM;
    if (pch->flags & pDISP) rel.r_sym |= R_NSCDISP;
    tmp = pch->offset + pch->pcoff;
    WL2M (rel.r_adr, tmp);
    CS2M (rel.r_sym, tmp);
    if (pch->size != 4) {
      lnnum = pch->lnnum;
      error ("#size of relocatable object is not 4 bytes");
    }
    myfwrite ((char *)&rel, sizeof (struct r_info), outfp);
    ++*cntp;                           /* update header.xrsize */
  }
  *cntp *= sizeof (struct r_info);     /* convert count to len in bytes */
}

/* Write a symbol table entry.
 */
write_symtab1 (p)
lblptr p;
{
  struct nlist nl;
  register U32 tmp;

  if (p->typ & T_STATIC) return;
  nl.n_stroff = (long) p->llink;
  nl.n_value = p->val;
  nl.n_type = p->typ & (T_TEXT | T_DATA | T_BSS | T_UNDF);
  CL2M (nl.n_value, tmp);
  CL2M (nl.n_stroff, tmp);
  CS2M (nl.n_type, tmp);
  myfwrite ((char *)&nl, sizeof (struct nlist), outfp);
}

/* Write the symbol table.
 */
write_symtab()
{
  hashnav (T_TEXT | T_DATA | T_BSS | T_UNDF, write_symtab1);
}

/* Write an identifier to the string table.
 */
write_strtab1 (p)
lblptr p;
{
  if (p->typ & T_STATIC) return;
  myfwrite (p->id, p->id_len, outfp);
}

/* Write the string table.
 */
write_strtab()
{
  hashnav (T_TEXT | T_DATA | T_BSS | T_UNDF, write_strtab1);
}

/* Write an a.out file header.
 */
write_header()
{
  register U32 tmp;

  CL2M (header.a_magic, tmp);
  CL2M (header.a_text, tmp);
  CL2M (header.a_data, tmp);
  CL2M (header.a_bss, tmp);
  CL2M (header.a_trsize, tmp);
  CL2M (header.a_drsize, tmp);
  CL2M (header.a_sym, tmp);
  CL2M (header.a_str, tmp);
  header.a_entry = 0;
  header.a_tstart = 0;
  header.a_dstart = 0;
  header.dummy = 0;
  myfseek (outfp, 0L, 0);
  myfwrite ((char *)&header, sizeof (struct exec), outfp);
}
