/* NS32000 Assembler
 * Main.c
 * Bruce Culbertson
 * 10 April 1987
 *
 * Debug options:
 *    3 expressions
 *    4 tokens
 *    5 expressions
 *    6 general operands
 *    8 print patches after phase 1
 *    9 print patches after phase 2
 */
#include <stdio.h>
#include <ctype.h>
#ifdef MSDOS
#  include "a_out.h"
#else
#  include "a.out.h"
#endif
#include "glob.h"
#include "magic.h"

main (argc, argv)
int argc;
char **argv;
{
  initvars();			/* initialize variables */
  hashinit();			/* init hash table, enter ops */
  getargs (argc, argv);		/* process command line args */
  openfiles();
  phase1();			/* read input file */
  if (debug == 8) print_patch_lists();
  if (num_errors) quit();
  phase2();			/* make displacements as short as possible */
  if (debug == 9) print_patch_lists();
  if (num_errors) quit();
  phase3();			/* write .o file */
  if (num_errors) quit();
  if (listing) list();		/* write listing file */
  if (!debug) {			/* remove temporaries (MSDOS needs close) */
    if (NULL != tmpt)	{fclose (tmpt);		unlink (tmptname);}
    if (NULL != tmpd)	{fclose (tmpd);		unlink (tmpdname);}
  }
  exit (0);
}

/* Initialize global variables */
initvars()
{
  header.a_magic = RELOC_MAGIC;
  usage = "!usage: as [{-a file |-A}] [-o file] file";
  curseg = T_TEXT;
  curlocptr = &header.a_text;
  tlbl_head = NULL;
  dlbl_head = NULL;
  blbl_head = NULL;
  ln_head = NULL;
  tpatch_head = NULL;
  dpatch_head = NULL;
}

/* Get arguements */
getargs (argc, argv)
int argc;
char **argv;
{
  *outname = '\0';
  listname = NULL;
  inname = NULL;
  while (--argc) {
    if (**++argv == '-') {
      switch (*++*argv) {
        case 'd':			/* -d[digit]: debug */
          if (isdigit (*++*argv))
	    while (isdigit (**argv))
	      debug = debug*10 + *(*argv)++ - '0';
          else ++debug;
          break;
        case 'A':			/* -A: list to default name */
          ++listing;
          break;
        case 'a':			/* -a: list to given name */
          listname = *++argv;
          --argc;
          ++listing;
          break;
        case 'o':			/* -o: output to given name */
          strcpy (outname, *++argv);
          --argc;
          break;
        case 'v':			/* -v: print version */
	  printf ("AS32K Version: %s\n", version);
        default:
          error (usage);
      }
    } else if (inname != NULL) error (usage);
    else inname = *argv;		/* source file name */
  }
  if (inname == NULL) error (usage);
}

/* Open source, .o and listing files.  Open a temporary for text segment
 * and a temporary for data segment.
 */
openfiles()
{
  char *p, *q, *dot, *slash;

  if (*outname == '\0') {               /* construct output file name */
    dot = NULL;
    slash = inname;
    for (p = inname; *p; ++p)           /* find root name */
      if (*p == '.') dot = p;
      else if (*p == '/') slash = p + 1;
    if (dot == NULL || *(dot + 1) != 's' || *(dot + 2) != '\0')
      dot = p;
    q = outname;
    for (p = slash; p < dot;) *q++ = *p++;
    *q++ = '.';
    *q++ = 'o';
    *q = '\0';
  }
  if (strlen (outname) > 14)
    error ("!filename %s is too long", outname);
  sprintf (tmptname, "as%dt", getpid());
  sprintf (tmpdname, "as%dd", getpid());
#ifdef MSDOS
  infp = myfopen (inname, "rt");
  outfp = myfopen (outname, "w+b");
  tmpt = myfopen (tmptname, "w+b");
  tmpd = myfopen (tmpdname, "w+b");
  if (listname != NULL)
    listfp = myfopen (listname, "wt");
#else
  infp = myfopen (inname, "r");
  outfp = myfopen (outname, "w+");
  tmpt = myfopen (tmptname, "w+");
  tmpd = myfopen (tmpdname, "w+");
  if (listname != NULL)
    listfp = myfopen (listname, "w");
#endif
  else listfp = stdout;
}

/* Clean up and die.
 */
quit()
{
  if (!debug) {
    if (NULL != outfp)	{fclose (outfp);	unlink (outname);}
    if (NULL != listfp)	{fclose (listfp);	unlink (listname);}
    if (NULL != tmpt)	{fclose (tmpt);		unlink (tmptname);}
    if (NULL != tmpd)	{fclose (tmpd);		unlink (tmpdname);}
  }
  exit (-1);
}
