/* NS32000 Assembler
 * Glob.h
 * Declares global variables and macros.
 */

/* DEFINE is true only in glob.c.  The EXTERN macro allows variable
 * definitions and declarations to be the same.
 */
#ifdef DEFINE
#  define EXTERN
#else
#  define EXTERN extern
#endif

#define TRUE 1
#define FALSE 0
#define HASHLEN (1<<10)                /* hash table length (pwr of 2) */
#define LNLEN   200
#define MAXEXP  100                    /* largest expression */
#define MAXSTK  10                     /* expression evaluation stack size */
#define MAXMAP  500                    /* line number maps per lnmap */
#define SEGALIGN 4                     /* segments will be rounded to a */
                                       /*   multiple of this */

#define U32 unsigned long
#define U16 unsigned short
#define U8  unsigned char

/* For aligning pointers and longs in expressions */
#define ALIGN(x) ((expptr)((long)(x)+exp_align&exp_align_mask))

/* Symbol types not in a.out.h
 */
#define T_IMM   0x040                  /* immediate */
#define T_OP    0x080                  /* mneumonic, assembler directive */
#define T_REG   0x100                  /* register */
#define T_AOP   0x200                  /* arithmetic operator */
#define T_RESOLVED 0x400               /* set if resolved */
#define T_CYCLE    0x800               /* set while evaluating expression */
#define T_EXPORTDIR 0x1000             /* appeared in .EXPORT directive */
#define T_LBL   (T_TEXT|T_DATA|T_BSS|T_UNDF|T_IMM)

/* Addressing mode opcodes
 */
#define mR0         0x00
#define mRXIND      0x08
#define mFPDBLIND   0x10
#define mIMM        0x14
#define mABS        0x15
#define mEXT        0x16
#define mTOS        0x17
#define mFPIND      0x18
#define mPCIND      0x1b
#define mBYTINX     0x1c

/* tokens */
#define tAND    0x01                   /* arithmetic operators - these must */
#define tCOM    0x02                   /* not overlap with literals *, +,   */
#define tMOD    0x03                   /* etc. whose ASCII values we use.   */
#define tNOT    0x04
#define tOR     0x05
#define tSHL    0x06
#define tSHR    0x07
#define tXOR    0x08
#define tUMINUS 0x09                   /* for expressions, not scanner */
#define tEOE    0x0a                   /* end of expression */
#define tEXT    0x0b
#define tBAD    0x80
#define tOP     0x81                   /* mneumonic, assembler directive */
#define tLBL    0x82                   /* a user defined symbol */
#define tREG    0x83                   /* NS32000 hardware register */
#define tSTR    0x84                   /* string */
#define tNUM    0x85                   /* numeric constant */
#define tFLOAT	0x86		       /* floating point constant */
#define tEOF    0x90                   /* end of file */

/* register numbers */
#define rR0     0x00                   /* Rx is (rR0 + x) */
#define rF0     0x10                   /* Fx is (rF0 + x) */

#define rUS     0x20                   /* 0010xxxx is CPU reg */
#define rFP     0x28
#define rSP     0x29
#define rSB     0x2a
#define rPC     0x2b
#define rPSR    0x2d
#define rINTBASE 0x2e
#define rMOD    0x2f

#define rDCR	0x21		       /* '532 extensions */
#define rBPC	0x22
#define rDSR	0x23
#define rCAR	0x24
#define rUSP    0x2b
#define rCFG	0x2c

#define rBPR0   0x40                   /* 0100xxxx is MMU reg */
#define rBPR1   0x41
#define rPF0    0x44
#define rPF1    0x45
#define rSC     0x48
#define rMCR	0x49
#define rMSR    0x4a
#define rBCNT   0x4b
#define rTEAR   0x4b
#define rPTB0   0x4c
#define rPTB1   0x4d
#define rIVAR0	0x4e
#define rEIA    0x4f
#define rIVAR1  0x4f
#define rTOS    0x50

typedef struct hashnode *hashptr;
typedef struct lblnode *lblptr;
typedef struct opnode *opptr;
typedef struct lnmap *lnptr;
typedef struct patch *patchptr;
typedef struct genrec *genptr;
typedef U8 exptyp [MAXEXP];
typedef U8 *expptr;

/* Line Map -- Keeps a mapping of object offsets to line numbers for
 * building listings.  Offset is first byte PAST those defined by this line.
 * MSbit of offset is set if T_DATA, clear if T_TEXT.
 */
struct lnmap {
  lnptr link;                          /* keep a list of these */
  short len;                           /* number of maps used so far */
  struct melt {                        /* map element */
    int lnnum;                         /* line number */
    long size;                         /* bytes generated by this line */
  } map [MAXMAP];
};
#define lDATA 0x80000000
#define lOFF  0x7fffffff

/* Keeps information needed for minimizing text displacements, backpatching,
 * and generating relocation tables.  There is one list of these for the
 * text segment and one for data.
 */
struct patch {
  patchptr link;
  U32 offset;                          /* location to be patched or reloc'd */
  int lnnum;                           /* for reporting errors */
  U16 flags;                           /* type of object */
  char size;                           /* size of object to patch */
  char pcoff;                          /* offset of object from current pc */
  expptr exp;                          /* expression */
  U16 typ;                             /* typ, undf and val are the result */
  lblptr undf;                         /*   of evaluating the expression */
  U32 val;
};
/* values for patch.flags */
#define pDISP         0x01
#define pIMM          0x02
#define pSHORT        0x04
#define pPCREL        0x08
#define pNEED_IMM     0x20
#define pNEED_TEXT    0x40
#define pWRITTEN      0x80             /* written during pass 1 */
#define pREDUCED      0x100            /* displacement whose size was reduced */
#define pBYTEREV      0x200            /* reverse bit map */
#define pGENIMM       0x400            /* gen immediate (msb first) */
#define pALIGN	      0x800	       /* for .align's in text segment */
#define pWORDSIZE     0x3000	       /* used for cmpm and movm */
#define pBYTE	      0x1000	       /* " */
#define pWORD	      0x2000	       /* " */
#define pDOUBLE	      0x3000	       /* " */

/* Hash Table Entries
 *
 * Hashnode, opnode and lblnode must agree on the first three fields for 
 * the hash table to work!
 */
struct hashnode {                       /* generic entry */
  char *id;                             /* id and typ form hash key */
  U16 typ;                              /* T_??? bitmap */
  hashptr link;                         /* for overflow buckets */
};

struct lblnode {                        /* label hash table entry */
  char *id;
  U16 typ;
  hashptr link;
  U32 val;                              /* value */
  expptr exp;                           /* compiled equation if unknown */
  int lnnum;                            /* ph1-2: line #, ph3: symtab index */
  short sym_ix;				/* index in symbol table */
  int id_len;                           /* id length including \0 */
  lblptr llink;                         /* ph1-2: list in order of definition
                                           ph3: strtab offset */
};

/* Functions */
extern U32 get_bracket();
extern int no_opnd1(), disp1(),         /* from inst.c */
  pcdisp1(),
  imm1(), revimm1(), immdisp1(), gen2(), gengen2(), shortgendisp2(),
  gengen3(), bgengen3(), genbgen3(), fgengen3(), genfgen3(), fgenfgen3(),
  cpureggen2(), shortgen2(), mmureggen3(), short3(),
  reggengen3(), reggengendisp3(), gengendisp3(), gengenimm3(),
  gen3a(), gen3b(), buw3(), cinv(), not_implemented();
extern int proc_equ(), setseg(),        /* from pseudo.c */
  align(), ds(), dc(), df(), ascii(), export();
patchptr wr_exp_imm();
extern U32 get_imm(), byte_reverse();
extern FILE *myfopen(), *fopen();
extern lblptr insert_lbl();
extern hashptr find();
extern char *myalloc(), *malloc();

struct opnode {                         /* (pseudo) op hash table entry */
  char *id;
  U16 typ;
  hashptr link;
  U32 inst;                             /* opcode */
  int (*f)();                           /* routine which assembles this op */
} ops []
#ifdef DEFINE
= {
# include "hashinit.h"
  {NULL},
};
#endif
;

struct genrec {                         /* info parsed from gen operand */
  int type1;                            /* if type2=0: this is the mode */
                                        /*   else mode part of index byte */
  int type2;                            /* mode if scaled index, else 0 */
  int inxreg;                           /* index register if scaled index */
  exptyp exp1, exp2;                    /* compiled expressions */
  int len1, len2;                       /* expression lengths */
  int flt;                              /* true if float operand */
  double fltimm;			/* floating point immediate */
};

EXTERN struct exec header;              /* a.out header */

EXTERN hashptr hash [HASHLEN],          /* the hash table */
               curhash;                 /* current token if tOP or tLBL */

EXTERN lblptr curlbl;                   /* most recently defined label */

/* We keep lists of the labels defined in each segment, in the order they
 * are defined.  For the text segment, this is used to update the labels
 * when displacements are minimized.  For the data and bss segments, the
 * lists are used for converting segment offsets to module offsets.
 */
EXTERN lblptr tlbl_head,                /* text label list */
              tlbl_tail;
EXTERN lblptr dlbl_head,                /* data label list */
              dlbl_tail;
EXTERN lblptr blbl_head,                /* bss label list */
              blbl_tail;
EXTERN lnptr  ln_head,                  /* list of lnmap structures */
              ln_tail;
EXTERN patchptr tpatch_head,            /* text segment patch list */
                tpatch_tail;
EXTERN patchptr dpatch_head,            /* data segment patch list */
                dpatch_tail;

/* FILE */
EXTERN FILE *tmpt,                      /* text segment temporary */
            *tmpd,                      /* data segment temporary */
            *infp,                      /* input file pointer */
            *outfp,                     /* output file pointer */
            *listfp;                    /* listing file pointer */

/* char */
EXTERN char *inname,                    /* input file name */
            *usage,                     /* usage message */
            outname [LNLEN],            /* output file name */
            curstr [LNLEN],             /* current token string value */
            *listname,                  /* list file name */
            tmptname [20],              /* text segment temporary file name */
            tmpdname [20],              /* data segment temporary file name */
	    version[];			/* updated by make */

/* unsigned long */
EXTERN U32
            exp_align,                  /* aligns objects in expressions */
            exp_align_mask,
            curval;                     /* current token numeric value */

/* int */
EXTERN int  debug,                      /* true for verbose output */
	    gcc,			/* true for GCC type strings */
            phase,                      /* current phase of assembly */
            lnnum,                      /* line number in input file */
            num_errors,                 /* number of errors */
            listing,                    /* true if listing requested */
            curseg,                     /* current segment */
            curtok,                     /* current token code */
	    toklen,			/* for string constants */
            curc;                       /* current character from input file */

/* long */
EXTERN long *curlocptr;                 /* current location pointer */

EXTERN double curfloat;			/* current float token */
