; These routines reverse (mirror) the byte, word or double-word
; in r0, without the use of a table.
;
; See National's application note AN-530 Bit Mirror Routine,
; pg. 8-99 in 1988 (rev. 1) Series 32000 Microprocessors Databook.
;
; Everyone is granted permission to use, copy, modify and redistribute
; the subroutines herein, however, I assume no responsibility for the
; consequences of using them.  J. S. Edwards, January 13, 1989.
;
; J. Scott Edwards
; P.O. Box 27511
; Salt Lake City, UT
;                84127
;
;
;                8-bit table       4-bit table         No table
;  bits   in    bytes   clocks    bytes   clocks    bytes   clocks
;    8    reg    260      20        48     125        32     112
;   16    reg     -       -         -       -         58     183
;   32    reg    305     286        -       -         92     262
;   32    mem    289     169        -       -         -       -
;
;
        page
;
;  routine to mirror the 32-bit double-word in r0
;
;  r1 contents lost
;
;  92 bytes - 262 clocks (32016-32032 timing charts)
;
        align
Mirror32:
        movd    r0,r1
        rotd    -1,r0
        andd    055555555H,r0
        rotd    1,r1
        andd    0AAAAAAAAH,r1
        ord     r1,r0
;
;  3 3 2 2 2 2 2 2  2 2 2 2 1 1 1 1  1 1 1 1 1 1 0 0  0 0 0 0 0 0 0 0
;  0 1 8 9 6 7 4 5  2 3 0 1 8 9 6 7  4 5 2 3 0 1 8 9  6 7 4 5 2 3 0 1
;
        movd    r0,r1
        rotd    -2,r0
        andd    033333333H,r0
        rotd    2,r1
        andd    0CCCCCCCCH,r1
        ord     r1,r0
;
;  2 2 3 3 2 2 2 2  2 2 2 2 1 1 1 1  1 1 1 1 0 0 1 1  0 0 0 0 0 0 0 0
;  8 9 0 1 4 5 6 7  0 1 2 3 6 7 8 9  2 3 4 5 8 9 0 1  4 5 6 7 0 1 2 3
;
        movd    r0,r1
        rotd    -4,r0
        andd    0F0F0F0F0H,r0
        rotd    4,r1
        andd    00F0F0F0FH,r1
        ord     r1,r0
;
;  0 0 0 0 2 2 2 2  2 2 2 2 1 1 1 1  1 1 1 1 0 0 0 0  0 0 1 1 2 2 3 3
;  0 1 2 3 0 1 2 3  4 5 6 7 2 3 4 5  6 7 8 9 4 5 6 7  8 9 0 1 8 9 0 1
;
        movd    r0,r1
        andd    0F00FF00FH,r0
        rotd    16,r1
        andd    00FF00FF0H,r1
        ord     r1,r0
;
        ret
;
;
        page
;
; routine to mirror the 16-bit word in r0
;
;  r1 contents lost
;
;  58 bytes - 183 clocks (32016-32032 timing charts)
;
;
        align
Mirror16:
        movw    r0,r1
        rotw    -1,r0
        andw    05555H,r0
        rotw    1,r1
        andw    0AAAAH,r1
        orw     r1,r0
;
;   1 1 1 1 1 1 0 0  0 0 0 0 0 0 0 0
;   4 5 2 3 0 1 8 9  6 7 4 5 2 3 0 1
;
        movw    r0,r1
        rotw    -2,r0
        andw    0CCCCH,r0
        rotw    2,r1
        andw    03333H,r1
        orw     r1,r0
;
;  0 0 1 1 1 1 0 0  0 0 0 0 0 0 1 1
;  0 1 0 1 2 3 6 7  8 9 2 3 4 5 4 5
;
        movw    r0,r1
        andw    0C3C3H,r0
        rotw    8,r1
        andw    03C3CH,r1
        orw     r1,r0
;
        ret
;
;
        page
;
; routine to mirror the 8-bit byte in r0
;
;  r1 contents lost
;
;  32 bytes - 112 clocks (32016-32032 timing charts)
;
        align
Mirror8:
        movb    r0,r1
        rotb    -1,r0
        andb    0AAH,r0
        rotb    1,r1
        andb    055H,r1
        orw     r1,r0
;
;   0 0 0 0 0 0 0 0
;   0 5 6 3 4 1 2 7
;
        movb    r0,r1
        andb    099H,r0
        rotb    4,r1
        andb    066H,r1
        orb     r1,r0
;
        ret

