/*   ------------------------------------------------------------------
 *   Function: Compute a long PI-constant	 (4..15,000 see	"smax")
 *
 *   Made by Waldemar Kebsch, Salzkotten, Germany - December 1985
 *                              UUCP: {uunet,mcvax}!unido!nixpbe!kebsch
 *
 * Many changes by Jordan Hubbard, too numerous to mention.
 *
 *
 *   Usage: pi [number]	      (number of digits	on the right hand)
 */

#define	 hmax	  10000l	    /* one element contains: 0..9999 */
#define	 lmax	       4	    /* max digits of an	element	     */
#define	 smin	    lmax	    /* min digits on the right hand  */
#define	 smax	    15000	    /* max digits ..		     */
#define	 ml   (1+smax/lmax+7-lmax)  /* max. necessary matrix length  */

#ifdef STANDALONE
#define PM_BASE 8000
#define TM_BASE 40000
#else
#include <stdio.h>
#endif

main()
{
    int	s;
    char digits[20];

    printf("Calculate pi to how many (decimal) digits? ");
    gets(digits);
    s = atoi(digits);
    if (s < smin || s > smax) {
        printf("Sorry, out of range (must be > %d and < %d).\n", smin, smax);
#ifdef STANDALONE
        asm("bpt");
#endif
    }
    doit(s);	  /* 2.	Let's do it */
#ifdef STANDALONE
    asm("bpt");
#endif
}


doit(s)	   /* Work */
int s;
{
    int	  b, xb;       /* number of necessary blocks (elem.) in	the matrix */
    long  n, t;	       /* n=current term, t=max. terms */

    s =	((s + lmax - 1)	/ lmax)	* lmax;	    /* digits */
    b =	xb = s / lmax +	7 - lmax;	    /* blocks */
    t =	s + 2l * s / 3l;		    /* terms  */
    {
#ifdef STANDALONE
	 long *pm = (long *)PM_BASE;
	 long *tm = (long *)TM_BASE;
#else
	 long pm[b], tm[b];
#endif
	 initial(pm, tm, b);

         printf("digits: %d,  terms: %d\n", s, t);
#ifdef STANDALONE
         printf("Using %d bytes of scratchpad memory (starting at %d).\n",
		b * 4, PM_BASE);
#endif

	 for(n = 1l; n <= t; n++) {  /* time eating loop */
	      if (!(n % 100)) {
		   printf("\rterm: %d ", n);
#ifndef STANDALONE
		   fflush(stdout);
#endif
	      }
	      if(n < 232l)
		   multiply(tm, (4l * (n * n -	n) + 1l), xb);
	      else {
		   multiply(tm, (2l * n - 1l),	xb );
		   multiply(tm, (2l * n - 1l),	xb );
	      }
	      if(n < 115l)
		   divide(tm, (n * (16l * n + 8l)), xb);
	      else {
		   divide(tm, (8l * n), xb );
		   divide(tm, (2l * n + 1l), xb );
	      }
	      add(pm,	tm, xb);
	      xb = checkxb(pm, xb);
	 }
	 multiply(pm, 6l, b);
	 display(pm,	b);
    }
}

initial(cm1, cm2, cb)	   /* cm1 = cm2	= 0.5 */
register long *cm1, *cm2;  /* current matrix */
int cb;
{
    long *cmm;

    for(cmm = cm1 + cb;	cm1 < cmm; )
	*++cm1 = *++cm2	= 0;

    *--cm1 = *--cm2 = hmax / 2l;
}

checkxb(cm, cb)	   /* Reduce current block number (speed up) */
register long *cm;
int cb;
{
    static long	mm = 0,	mn = 0,	nn = 0;
    register long *cmm;

    cmm	= cm;
    cm += cb;
    if(*cm == mm && *--cm == mn	&& *--cm == nn)
	cb--;

    cmm	+= cb;
    mm = *cmm;
    mn = *--cmm;
    nn = *--cmm;
    return(cb);
}

multiply(cm, x,	cb)  /*	cm *= x	*/
register long *cm;   /*	current	matrix	 */
long x;	    /* multiply	with ..	*/
int cb;	    /* current blocks	*/
{
    long *cmm;
    long c, z;	  /*	  carry	*/

    for(c = 0, cmm = cm	+ cb; cm < cmm;	)
    {
	z = *++cm * x +	c;
	c = z /	hmax;
	*cm = z	- c * hmax;	  /* the same as "*cm = z % hmax;" */
    }				  /* but faster! */
}

divide(cm, x, cb)  /* cm /= x */
register long *cm;   /*	current	matrix */
long x;	    /* divide by ..   */
int cb;	    /* current blocks */
{
    long *cmm;
    long c, z, q;      /* c=carry, z, q=temporary variable */

    for(c = 0, cmm = cm, cm += cb; cm >	cmm; )
    {
	z = *cm	+ c;
	*cm-- =	q = z /	x;
	c = (z - q * x)	* hmax;	  /* the same as  "c = (z % x) * hmax;"	*/
    }				  /* but faster! */
}

add(cm1, cm2, cb)	/* cm1 += cm2 */
register long *cm1, *cm2;    /*	current	matrix */
int cb;		    /* current blocks */
{
    long *cmm;
    long c;  /*	carry */

    for(c = 0, cmm = cm1 + cb; cm1 < cmm; )
    {
	if((*++cm1 += (*++cm2 +	c)) >= hmax)
	{
	    *cm1 -= hmax;
	    c =	1;
	}
	else
	    c =	0;
    }
}

display(cm, cb)
register long *cm;  /* current matrix */
int cb;
{
    int	i;

    printf("\n%d.", *(cm += cb));	/* one digit on the left hand */
    for (i = cb-1; i >= (7-lmax); i--)
	printf("%d", *--cm);		/* print all digits on the rigth hand */
    printf("\n");
}
